/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import java.util.ArrayList;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.events.MouseButtonClickedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseStoppedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.render.InputSourceWindow;

public final class MouseEventPool {
    private static ArrayList<MouseMovedEvent> instances_moved = new ArrayList(64);
    private static ArrayList<MouseButtonPressedEvent> instances_pressed = new ArrayList(64);
    private static ArrayList<MouseButtonReleasedEvent> instances_released = new ArrayList(64);
    private static ArrayList<MouseButtonClickedEvent> instances_clicked = new ArrayList(16);
    private static ArrayList<MouseWheelEvent> instances_wheel = new ArrayList(64);
    private static ArrayList<MouseStoppedEvent> instances_stopped = new ArrayList(64);
    private static int n_moved = 0;
    private static int n_pressed = 0;
    private static int n_released = 0;
    private static int n_clicked = 0;
    private static int n_wheel = 0;
    private static int n_stopped = 0;
    private static final Object LOCK_moved = new Object();
    private static final Object LOCK_pressed = new Object();
    private static final Object LOCK_released = new Object();
    private static final Object LOCK_clicked = new Object();
    private static final Object LOCK_wheel = new Object();
    private static final Object LOCK_stopped = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseMovedEvent allocMoved() {
        Object object = LOCK_moved;
        synchronized (object) {
            if (n_moved > 0) {
                MouseMovedEvent e = instances_moved.remove(--n_moved);
                return e;
            }
            return new MouseMovedEvent();
        }
    }

    public static MouseMovedEvent allocMoved(Mouse mouse, int x, int y, int dx, int dy, long when, long lastWhen) {
        MouseMovedEvent e = MouseEventPool.allocMoved();
        e.set(mouse, x, y, dx, dy, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeMoved(MouseMovedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_moved;
        synchronized (object) {
            instances_moved.add(e);
            ++n_moved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseButtonPressedEvent allocPressed() {
        Object object = LOCK_pressed;
        synchronized (object) {
            if (n_pressed > 0) {
                MouseButtonPressedEvent e = instances_pressed.remove(--n_pressed);
                return e;
            }
            return new MouseButtonPressedEvent();
        }
    }

    public static MouseButtonPressedEvent allocPressed(Mouse mouse, MouseButton button, long when, long lastWhen) {
        MouseButtonPressedEvent e = MouseEventPool.allocPressed();
        e.set(mouse, button, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freePressed(MouseButtonPressedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_pressed;
        synchronized (object) {
            instances_pressed.add(e);
            ++n_pressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseButtonReleasedEvent allocReleased() {
        Object object = LOCK_released;
        synchronized (object) {
            if (n_released > 0) {
                MouseButtonReleasedEvent e = instances_released.remove(--n_released);
                return e;
            }
            return new MouseButtonReleasedEvent();
        }
    }

    public static MouseButtonReleasedEvent allocReleased(Mouse mouse, MouseButton button, long when, long lastWhen) {
        MouseButtonReleasedEvent e = MouseEventPool.allocReleased();
        e.set(mouse, button, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeReleased(MouseButtonReleasedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_released;
        synchronized (object) {
            instances_released.add(e);
            ++n_released;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseButtonClickedEvent allocClicked() {
        Object object = LOCK_clicked;
        synchronized (object) {
            if (n_clicked > 0) {
                MouseButtonClickedEvent e = instances_clicked.remove(--n_clicked);
                return e;
            }
            return new MouseButtonClickedEvent();
        }
    }

    public static MouseButtonClickedEvent allocClicked(Mouse mouse, MouseButton button, long when, long lastWhen) {
        MouseButtonClickedEvent e = MouseEventPool.allocClicked();
        e.set(mouse, button, 1, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeClicked(MouseButtonClickedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_clicked;
        synchronized (object) {
            instances_clicked.add(e);
            ++n_clicked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseWheelEvent allocWheel() {
        Object object = LOCK_wheel;
        synchronized (object) {
            if (n_wheel > 0) {
                MouseWheelEvent e = instances_wheel.remove(--n_wheel);
                return e;
            }
            return new MouseWheelEvent();
        }
    }

    public static MouseWheelEvent allocWheel(Mouse mouse, MouseWheel wheel, int wheelDelta, boolean isPageMove, long when, long lastWhen) {
        MouseWheelEvent e = MouseEventPool.allocWheel();
        e.set(mouse, wheel, wheelDelta, isPageMove, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeWheel(MouseWheelEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_wheel;
        synchronized (object) {
            instances_wheel.add(e);
            ++n_wheel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseStoppedEvent allocStopped() {
        Object object = LOCK_stopped;
        synchronized (object) {
            if (n_stopped > 0) {
                MouseStoppedEvent e = instances_stopped.remove(--n_stopped);
                return e;
            }
            return new MouseStoppedEvent();
        }
    }

    public static MouseStoppedEvent allocStopped(Mouse mouse, int x, int y, long when, long lastWhen) {
        MouseStoppedEvent e = MouseEventPool.allocStopped();
        e.set(mouse, x, y, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeStopped(MouseStoppedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_stopped;
        synchronized (object) {
            instances_stopped.add(e);
            ++n_stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(InputSourceWindow sourceWindow) {
        int i;
        if (sourceWindow == null) {
            Object object = LOCK_moved;
            synchronized (object) {
                instances_moved.clear();
                n_moved = 0;
            }
            object = LOCK_pressed;
            synchronized (object) {
                instances_pressed.clear();
                n_pressed = 0;
            }
            object = LOCK_released;
            synchronized (object) {
                instances_released.clear();
                n_released = 0;
            }
            object = LOCK_clicked;
            synchronized (object) {
                instances_clicked.clear();
                n_clicked = 0;
            }
            object = LOCK_wheel;
            synchronized (object) {
                instances_wheel.clear();
                n_wheel = 0;
            }
            object = LOCK_stopped;
            synchronized (object) {
                instances_stopped.clear();
                n_stopped = 0;
            }
        }
        Object object = LOCK_moved;
        synchronized (object) {
            i = instances_moved.size() - 1;
            while (i >= 0) {
                if (instances_moved.get(i).getMouse().getSourceWindow() == sourceWindow) {
                    instances_moved.remove(i);
                    --n_moved;
                }
                --i;
            }
        }
        object = LOCK_pressed;
        synchronized (object) {
            i = instances_pressed.size() - 1;
            while (i >= 0) {
                if (instances_pressed.get(i).getMouse().getSourceWindow() == sourceWindow) {
                    instances_pressed.remove(i);
                    --n_pressed;
                }
                --i;
            }
        }
        object = LOCK_released;
        synchronized (object) {
            i = instances_released.size() - 1;
            while (i >= 0) {
                if (instances_released.get(i).getMouse().getSourceWindow() == sourceWindow) {
                    instances_released.remove(i);
                    --n_released;
                }
                --i;
            }
        }
        object = LOCK_clicked;
        synchronized (object) {
            i = instances_clicked.size() - 1;
            while (i >= 0) {
                if (instances_clicked.get(i).getMouse().getSourceWindow() == sourceWindow) {
                    instances_clicked.remove(i);
                    --n_clicked;
                }
                --i;
            }
        }
        object = LOCK_wheel;
        synchronized (object) {
            i = instances_wheel.size() - 1;
            while (i >= 0) {
                if (instances_wheel.get(i).getMouse().getSourceWindow() == sourceWindow) {
                    instances_wheel.remove(i);
                    --n_wheel;
                }
                --i;
            }
        }
        object = LOCK_stopped;
        synchronized (object) {
            i = instances_stopped.size() - 1;
            while (i >= 0) {
                if (instances_stopped.get(i).getMouse().getSourceWindow() == sourceWindow) {
                    instances_stopped.remove(i);
                    --n_stopped;
                }
                --i;
            }
        }
    }

    private MouseEventPool() {
    }
}

