/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.lwjgl;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.InputDeviceFactory;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.impl.lwjgl.LWJGLController;
import org.jagatoo.input.impl.lwjgl.LWJGLKeyboard;
import org.jagatoo.input.impl.lwjgl.LWJGLMouse;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.Log;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;

public class LWJGLInputDeviceFactory
extends InputDeviceFactory {
    protected LWJGLMouse[] initMouses() throws InputSystemException {
        Mouse[] currentMouses = this.getCachedMouses();
        if (currentMouses != null && currentMouses.length == 1 && currentMouses[0] instanceof LWJGLMouse && currentMouses[0].getSourceWindow() == this.getSourceWindow()) {
            return new LWJGLMouse[]{(LWJGLMouse)currentMouses[0]};
        }
        return new LWJGLMouse[]{new LWJGLMouse(this.findSourceFactory(), this.getSourceWindow(), this.getEveneQueue())};
    }

    protected LWJGLKeyboard[] initKeyboards() throws InputSystemException {
        Keyboard[] currentKeyboards = this.getCachedKeyboards();
        if (currentKeyboards != null && currentKeyboards.length == 1 && currentKeyboards[0] instanceof LWJGLKeyboard && currentKeyboards[0].getSourceWindow() == this.getSourceWindow()) {
            return new LWJGLKeyboard[]{(LWJGLKeyboard)currentKeyboards[0]};
        }
        return new LWJGLKeyboard[]{new LWJGLKeyboard(this.findSourceFactory(), this.getSourceWindow(), this.getEveneQueue())};
    }

    protected LWJGLController[] initControllers() throws InputSystemException {
        Controller[] currentControllers = this.getCachedControllers();
        try {
            if (!Controllers.isCreated()) {
                Controllers.create();
            }
            int count = Controllers.getControllerCount();
            LWJGLController[] controllers = new LWJGLController[count];
            boolean alreadyExisting = false;
            int k = 0;
            int i = 0;
            while (i < count) {
                block16: {
                    alreadyExisting = false;
                    if (currentControllers != null) {
                        int j = 0;
                        while (j < currentControllers.length) {
                            if (currentControllers[j] instanceof LWJGLController && currentControllers[j].getName().equals(Controllers.getController(i).getName())) {
                                controllers[k++] = (LWJGLController)currentControllers[j];
                                alreadyExisting = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!alreadyExisting) {
                        try {
                            LWJGLController c = new LWJGLController(this.findSourceFactory(), this.getSourceWindow(), this.getEveneQueue(), Controllers.getController(i));
                            controllers[k++] = c;
                        }
                        catch (InputSystemException ise) {
                            if (ise.getInfo() == InputSystemException.Info.ILLEGAL_CONTROLLER_CONFIGURATION) break block16;
                            throw ise;
                        }
                    }
                }
                ++i;
            }
            if (k != count) {
                LWJGLController[] controllers2 = new LWJGLController[k];
                System.arraycopy(controllers, 0, controllers2, 0, k);
                return controllers2;
            }
            return controllers;
        }
        catch (LWJGLException lwjglEx) {
            if (lwjglEx.getCause() != null && lwjglEx.getCause() instanceof NoClassDefFoundError) {
                NoClassDefFoundError ncdfe = (NoClassDefFoundError)lwjglEx.getCause();
                String message = "Error retrieving Controllers. JInput doesn't seem to be installed.";
                Log.error(InputSystem.LOG_CHANNEL, message);
                throw new InputSystemException(message, (Throwable)ncdfe);
            }
            throw new InputSystemException(lwjglEx);
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    protected void destroyImpl(InputSystem inputSystem) throws InputSystemException {
        try {
            if (Controllers.isCreated()) {
                Controllers.destroy();
            }
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
    }

    public LWJGLInputDeviceFactory(InputDeviceFactory masterFactory, InputSourceWindow sourceWindow, EventQueue eventQueue) {
        super(masterFactory, true, sourceWindow, eventQueue);
    }

    public LWJGLInputDeviceFactory(InputSourceWindow sourceWindow, EventQueue eventQueue) {
        this(null, sourceWindow, eventQueue);
    }
}

