/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.swt;

import java.awt.Point;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.render.InputSourceWindow;

public class SWTMouse
extends Mouse {
    private int calibrationStep = -1;
    private final Control control;
    private final Point centerControl = new Point(0, 0);
    private final Point los = new Point(0, 0);
    private int calibX = 1;
    private int calibY = 1;
    private int lastAbsoluteX = 0;
    private int lastAbsoluteY = 0;
    private long lastGameTimeDelta = System.nanoTime();

    private static MouseButton convertButton(int swtButton) {
        switch (swtButton) {
            case 1: {
                return MouseButtons.LEFT_BUTTON;
            }
            case 2: {
                return MouseButtons.MIDDLE_BUTTON;
            }
            case 3: {
                return MouseButtons.RIGHT_BUTTON;
            }
        }
        return null;
    }

    public void setPosition(int x, int y) throws InputSystemException {
        super.setPosition(x, y);
        try {
            this.isAbsolute();
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void centerMouse() throws InputSystemException {
        try {
            this.control.getDisplay().setCursorLocation(this.los.x + this.calibX + this.centerControl.x, this.los.y + this.calibY + this.centerControl.y);
        }
        catch (Throwable t) {
            throw new InputSystemException(t);
        }
    }

    private void updateCenters() {
        this.control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ((SWTMouse)SWTMouse.this).los.x = ((SWTMouse)SWTMouse.this).control.getLocation().x;
                ((SWTMouse)SWTMouse.this).los.y = ((SWTMouse)SWTMouse.this).control.getLocation().y;
                Composite parent = SWTMouse.this.control.getParent();
                while (parent != null) {
                    ((SWTMouse)SWTMouse.this).los.x += parent.getLocation().x;
                    ((SWTMouse)SWTMouse.this).los.y += parent.getLocation().y;
                    parent = parent.getParent();
                }
                ((SWTMouse)SWTMouse.this).centerControl.x = ((SWTMouse)SWTMouse.this).control.getSize().x / 2 + 1;
                ((SWTMouse)SWTMouse.this).centerControl.y = ((SWTMouse)SWTMouse.this).control.getSize().y / 2 + 1;
                parent = SWTMouse.this.control.getParent();
                while (((SWTMouse)SWTMouse.this).centerControl.x == 1 && ((SWTMouse)SWTMouse.this).centerControl.y == 1 && parent != null) {
                    ((SWTMouse)SWTMouse.this).centerControl.x = parent.getSize().x / 2 + 1;
                    ((SWTMouse)SWTMouse.this).centerControl.y = parent.getSize().y / 2 + 1;
                    parent = parent.getParent();
                }
                SWTMouse.this.calibrationStep = 0;
            }
        });
    }

    private void recenter() {
        if (this.control.getDisplay().getThread().equals(Thread.currentThread())) {
            this.control.getDisplay().setCursorLocation(this.los.x + this.calibX + this.centerControl.x, this.los.y + this.calibY + this.centerControl.y);
        } else {
            this.control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SWTMouse.this.control.getDisplay().setCursorLocation(((SWTMouse)SWTMouse.this).los.x + SWTMouse.this.calibX + ((SWTMouse)SWTMouse.this).centerControl.x, ((SWTMouse)SWTMouse.this).los.y + SWTMouse.this.calibY + ((SWTMouse)SWTMouse.this).centerControl.y);
                }
            });
        }
    }

    private void calibrate(int mouseX, int mouseY) {
        if (this.getCurrentX() == -1 || this.getCurrentY() == -1) {
            return;
        }
        switch (this.calibrationStep) {
            case 0: {
                this.control.getDisplay().setCursorLocation(this.los.x + mouseX, this.los.y + mouseY);
                this.calibX = mouseX;
                this.calibY = mouseY;
                this.calibrationStep = 1;
                break;
            }
            case 1: {
                this.calibX -= mouseX;
                this.calibY -= mouseY;
                this.recenter();
                this.calibrationStep = -1;
            }
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyStatesManagersFromQueue(InputSystem is, EventQueue eventQueue, long nanoTime) {
        if (eventQueue.getNumEvents() == 0) {
            return;
        }
        Object object = EventQueue.LOCK;
        synchronized (object) {
            int i = 0;
            while (i < eventQueue.getNumEvents()) {
                InputEvent event = eventQueue.getEvent(i);
                if (event.getType() == InputEvent.Type.MOUSE_EVENT) {
                    org.jagatoo.input.events.MouseEvent moEvent = (org.jagatoo.input.events.MouseEvent)event;
                    switch (moEvent.getSubType()) {
                        case BUTTON_PRESSED: {
                            is.notifyInputStatesManagers(this, moEvent.getComponent(), 1, 1, nanoTime);
                            break;
                        }
                        case BUTTON_RELEASED: {
                            is.notifyInputStatesManagers(this, moEvent.getComponent(), 0, -1, nanoTime);
                            break;
                        }
                        case WHEEL_MOVED: {
                            MouseWheelEvent mwEvent = (MouseWheelEvent)moEvent;
                            MouseWheel wheel = (MouseWheel)mwEvent.getComponent();
                            is.notifyInputStatesManagers(this, wheel, wheel.getIntValue(), mwEvent.getWheelDelta(), nanoTime);
                            break;
                        }
                        case MOVED: {
                            MouseMovedEvent mmEvent = (MouseMovedEvent)moEvent;
                            if (mmEvent.getDX() != 0) {
                                is.notifyInputStatesManagers(this, mmEvent.getMouse().getXAxis(), mmEvent.getX(), mmEvent.getDX(), nanoTime);
                            }
                            if (mmEvent.getDY() == 0) break;
                            is.notifyInputStatesManagers(this, mmEvent.getMouse().getYAxis(), mmEvent.getY(), mmEvent.getDY(), nanoTime);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void updateMouse(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        try {
            this.notifyStatesManagersFromQueue(is, eventQueue, nanoTime);
            this.getEventQueue().dequeueAndFire(is, InputEvent.Type.MOUSE_EVENT);
            this.handleClickedEvents(nanoTime, is.getMouseButtonClickThreshold());
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
        this.lastGameTimeDelta = System.nanoTime() - nanoTime;
    }

    protected void setAbsoluteImpl(boolean absolute) throws InputSystemException {
        try {
            this.updateCenters();
            this.recenter();
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void destroyImpl() throws InputSystemException {
    }

    protected SWTMouse(MouseFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, "Primary Mouse", 12, true);
        try {
            this.control = (Control)sourceWindow.getDrawable();
            this.control.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent _e) {
                }

                public void mouseDown(MouseEvent _e) {
                    MouseButton button = SWTMouse.convertButton(_e.button);
                    if (button != null) {
                        MouseButtonPressedEvent e = SWTMouse.this.prepareMouseButtonPressedEvent(button, System.nanoTime() - SWTMouse.this.lastGameTimeDelta);
                        if (e == null) {
                            return;
                        }
                        SWTMouse.this.getEventQueue().enqueue(e);
                    }
                }

                public void mouseUp(MouseEvent _e) {
                    MouseButton button = SWTMouse.convertButton(_e.button);
                    if (button != null) {
                        MouseButtonReleasedEvent e = SWTMouse.this.prepareMouseButtonReleasedEvent(button, System.nanoTime() - SWTMouse.this.lastGameTimeDelta);
                        if (e == null) {
                            return;
                        }
                        SWTMouse.this.getEventQueue().enqueue(e);
                    }
                }
            });
            this.control.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent _e) {
                    int x = _e.x;
                    int y = _e.y;
                    long when = System.nanoTime() - SWTMouse.this.lastGameTimeDelta;
                    boolean doEvent = true;
                    if (!SWTMouse.this.isAbsolute() && SWTMouse.this.calibrationStep != -1) {
                        SWTMouse.this.calibrate(x, y);
                        doEvent = false;
                    }
                    if (doEvent && (SWTMouse.this.getCurrentX() != x || SWTMouse.this.getCurrentY() != y)) {
                        if (SWTMouse.this.isAbsolute()) {
                            int dx = x - SWTMouse.this.getCurrentX();
                            int dy = -(y - SWTMouse.this.getCurrentY());
                            SWTMouse.this.storePosition(x, y);
                            MouseMovedEvent e = SWTMouse.this.prepareMouseMovedEvent(x, y, dx, dy, when);
                            if (e == null) {
                                return;
                            }
                            SWTMouse.this.getEventQueue().enqueue(e);
                            SWTMouse.this.lastAbsoluteX = x;
                            SWTMouse.this.lastAbsoluteY = y;
                        } else {
                            int dx = x - ((SWTMouse)SWTMouse.this).centerControl.x;
                            int dy = -(y - ((SWTMouse)SWTMouse.this).centerControl.y);
                            if (dx != 0 || dy != 0) {
                                MouseMovedEvent e = SWTMouse.this.prepareMouseMovedEvent(SWTMouse.this.lastAbsoluteX, SWTMouse.this.lastAbsoluteY, dx, dy, when);
                                if (e == null) {
                                    return;
                                }
                                SWTMouse.this.getEventQueue().enqueue(e);
                                SWTMouse.this.recenter();
                            }
                        }
                    }
                }
            });
            this.control.addListener(37, new Listener(){

                public void handleEvent(Event _e) {
                    long when = System.nanoTime() - SWTMouse.this.lastGameTimeDelta;
                    MouseWheelEvent e = SWTMouse.this.prepareMouseWheelMovedEvent(-_e.count, false, when);
                    if (e != null) {
                        SWTMouse.this.getEventQueue().enqueue(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            throw new InputSystemException(e);
        }
    }
}

