/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.managers;

import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.actions.InvokableInputAction;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.InputState;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.input.managers.InputStatesManipulator;
import org.jagatoo.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStatesManager {
    public static final int MOUSE_AXES_SUSPENDED = 1;
    public static final int MOUSE_BUTTONS_SUSPENDED = 2;
    public static final int MOUSE_WHEEL_SUSPENDED = 4;
    public static final int KEYBOARD_SUSPENDED = 8;
    public static final int CONTROLLERS_SUSPENDED = 16;
    private final InputBindingsManager<? extends InputAction> bindingsManager;
    private InputStatesManipulator manipulator = null;
    private int suspendMask = 0;
    private final int numStates;
    private final short[] states1;
    private final short[] states2;
    private short[] prevStates;
    private short[] currStates;
    private final short[] tmpPrevStates;
    private final short[] tmpCurrStates;
    private boolean swapper = false;

    public InputStatesManipulator getInputStatesManipulator() {
        if (this.manipulator == null) {
            this.manipulator = new InputStatesManipulator(this);
        }
        return this.manipulator;
    }

    @Deprecated
    public final InputStatesManipulator getKeyStatesManipulator() {
        return this.getInputStatesManipulator();
    }

    public void setSuspendMask(int suspendMask) {
        this.suspendMask = suspendMask;
    }

    public final int getSuspendMask() {
        return this.suspendMask;
    }

    public final int getNumStates() {
        return this.numStates;
    }

    public final InputState getInputState(InputAction action) {
        int ordinal = action.ordinal();
        if (this.states1[ordinal] == this.states2[ordinal]) {
            if (this.states1[ordinal] > 0) {
                return InputState.POSITIVE;
            }
            return InputState.NEGATIVE;
        }
        if (this.swapper) {
            if (this.states1[ordinal] > this.states2[ordinal]) {
                return InputState.MADE_POSITIVE;
            }
            return InputState.MADE_NEGATIVE;
        }
        if (this.states2[ordinal] > this.states1[ordinal]) {
            return InputState.MADE_POSITIVE;
        }
        return InputState.MADE_NEGATIVE;
    }

    public final int getSimpleInputState(InputAction action) {
        return this.currStates[action.ordinal()];
    }

    public final boolean hasInputStateChanged(InputAction action) {
        return this.states1[action.ordinal()] != this.states2[action.ordinal()];
    }

    private final void invokeAction(InputDevice device, DeviceComponent comp, int ordinal, InputAction action, long nanoTime) {
        if (action instanceof InvokableInputAction) {
            InvokableInputAction invAction = (InvokableInputAction)action;
            try {
                invAction.invokeAction(device, comp, this.tmpCurrStates[ordinal] - this.tmpPrevStates[ordinal], this.tmpCurrStates[ordinal], nanoTime);
            }
            catch (InputSystemException ex) {
                Log.print(InputSystem.LOG_CHANNEL, ex);
                ex.printStackTrace();
            }
        }
    }

    private final int updateState_(InputDevice device, DeviceComponent comp, int state, long nanoTime, boolean mouseAxesIgnored, boolean mouseButtonsIgnored, boolean mouseWheelIgnored, boolean keyboardIgnored, boolean controllersIgnored) {
        InputAction action = this.bindingsManager.getBoundAction(comp);
        if (action == null) {
            return -1;
        }
        int ordinal = action.ordinal();
        if (mouseAxesIgnored && comp instanceof MouseAxis) {
            this.tmpPrevStates[ordinal] = (short)state;
        } else if (mouseButtonsIgnored && comp instanceof MouseButton) {
            this.tmpPrevStates[ordinal] = (short)state;
        } else if (mouseWheelIgnored && comp instanceof MouseWheel) {
            this.tmpPrevStates[ordinal] = (short)state;
        } else if (mouseWheelIgnored && comp instanceof MouseWheel.WheelUpDownComponent) {
            this.tmpPrevStates[ordinal] = (short)state;
        } else if (keyboardIgnored && device instanceof Keyboard) {
            state = 0;
            this.tmpPrevStates[ordinal] = (short)state;
        } else if (controllersIgnored && device instanceof Controller) {
            this.tmpPrevStates[ordinal] = (short)state;
        }
        this.tmpCurrStates[ordinal] = (short)state;
        if (this.tmpCurrStates[ordinal] != this.tmpPrevStates[ordinal]) {
            this.invokeAction(device, comp, ordinal, action, nanoTime);
        }
        return ordinal;
    }

    private final void updateWheelStates(Mouse mouse, MouseWheel wheel, int state, int delta, long nanoTime, boolean mouseAxesIgnored, boolean mouseButtonsIgnored, boolean mouseWheelIgnored, boolean keyboardIgnored, boolean controllersIgnored) {
        this.updateState_(mouse, wheel, state, nanoTime, mouseAxesIgnored, mouseButtonsIgnored, mouseWheelIgnored, keyboardIgnored, controllersIgnored);
        int result = delta > 0 ? this.updateState_(mouse, wheel.getUp(), 1, nanoTime, mouseAxesIgnored, mouseButtonsIgnored, mouseWheelIgnored, keyboardIgnored, controllersIgnored) : this.updateState_(mouse, wheel.getDown(), 1, nanoTime, mouseAxesIgnored, mouseButtonsIgnored, mouseWheelIgnored, keyboardIgnored, controllersIgnored);
        if (!mouseWheelIgnored && result >= 0) {
            this.tmpPrevStates[result] = 0;
        }
    }

    final void internalUpdateState(InputDevice device, DeviceComponent comp, int state, int delta, long nanoTime) {
        boolean controllersIgnored;
        boolean mouseAxesIgnored = (this.suspendMask & 1) != 0;
        boolean mouseButtonsIgnored = (this.suspendMask & 2) != 0;
        boolean mouseWheelIgnored = (this.suspendMask & 4) != 0;
        boolean keyboardIgnored = (this.suspendMask & 8) != 0;
        boolean bl = controllersIgnored = (this.suspendMask & 0x10) != 0;
        if (comp.getType() == DeviceComponent.Type.MOUSE_WHEEL) {
            if (comp != MouseWheel.GLOBAL_WHEEL) {
                comp = MouseWheel.GLOBAL_WHEEL;
            }
            this.updateWheelStates((Mouse)device, (MouseWheel)comp, state, delta, nanoTime, mouseAxesIgnored, mouseButtonsIgnored, mouseWheelIgnored, keyboardIgnored, controllersIgnored);
        } else {
            this.updateState_(device, comp, state, nanoTime, mouseAxesIgnored, mouseButtonsIgnored, mouseWheelIgnored, keyboardIgnored, controllersIgnored);
        }
    }

    public void update(long nanoTime) {
        boolean bl = this.swapper = !this.swapper;
        if (this.swapper) {
            this.currStates = this.states1;
            this.prevStates = this.states2;
        } else {
            this.currStates = this.states2;
            this.prevStates = this.states1;
        }
        System.arraycopy(this.tmpPrevStates, 0, this.prevStates, 0, this.numStates);
        System.arraycopy(this.tmpCurrStates, 0, this.currStates, 0, this.numStates);
        System.arraycopy(this.tmpCurrStates, 0, this.tmpPrevStates, 0, this.numStates);
        if (this.manipulator != null) {
            this.manipulator.apply(this.currStates);
        }
    }

    public void getActionsByState(InputState state, List<? super InputAction> actions, boolean clearListBefore) {
        actions.clear();
        for (InputAction inputAction : this.bindingsManager.getBoundActions()) {
            InputState state2 = this.getInputState(inputAction);
            if (state2 != state) continue;
            actions.add(inputAction);
        }
    }

    public final void getActionsByState(InputState state, List<? super InputAction> actions) {
        this.getActionsByState(state, actions, true);
    }

    public int getActionsByState(InputState state, InputAction[] actions) {
        int i = 0;
        for (InputAction inputAction : this.bindingsManager.getBoundActions()) {
            InputState state2 = this.getInputState(inputAction);
            if (state2 != state) continue;
            actions[i++] = inputAction;
        }
        return i;
    }

    public InputAction[] getActionsByState(InputState state) {
        InputAction[] actions = null;
        int i = 0;
        for (InputAction inputAction : this.bindingsManager.getBoundActions()) {
            InputState state2 = this.getInputState(inputAction);
            if (state2 != state) continue;
            if (actions == null) {
                actions = new InputAction[this.numStates];
            }
            actions[i++] = inputAction;
        }
        if (i > 0 && i < this.numStates) {
            InputAction[] inputActionArray = new InputAction[i];
            System.arraycopy(actions, 0, inputActionArray, 0, i);
            return inputActionArray;
        }
        return actions;
    }

    public InputStatesManager(InputBindingsManager<? extends InputAction> bindingsManager) {
        int numActions;
        this.bindingsManager = bindingsManager;
        this.numStates = numActions = bindingsManager.getNumActions();
        this.states1 = new short[numActions];
        this.states2 = new short[numActions];
        this.tmpPrevStates = new short[numActions];
        this.tmpCurrStates = new short[numActions];
        int i = 0;
        while (i < numActions) {
            this.states1[i] = 0;
            this.states2[i] = 0;
            this.tmpPrevStates[i] = 0;
            this.tmpCurrStates[i] = 0;
            ++i;
        }
        this.prevStates = this.states1;
        this.currStates = this.states2;
        this.swapper = false;
    }
}

