/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Cursor {
    public static final Cursor DEFAULT_CURSOR = new Cursor("DEFAULT_CURSOR");
    private final BufferedImage[] images;
    private final int[] delays;
    private int width;
    private int height;
    private int hotSpotX;
    private int hotSpotY;
    private final String name;
    private boolean dirty = true;
    private Object cursorImpl = null;

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final String getName() {
        return this.name;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getHotSpotX() {
        return this.hotSpotX;
    }

    public final int getHotSpotY() {
        return this.hotSpotY;
    }

    public final int getImagesCount() {
        return this.images.length;
    }

    public final BufferedImage getImage(int index) {
        return this.images[index];
    }

    public final int getDelay(int index) {
        return this.delays[index];
    }

    public void setCursorObject(Object cursorImpl) {
        this.cursorImpl = cursorImpl;
    }

    public Object getCursorObject() {
        return this.cursorImpl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " \"" + (this.getName() == null ? "NO_NAME" : this.getName()) + "\"";
    }

    public Cursor(BufferedImage[] images, int[] delays, int hotSpotX, int hotSpotY, String name) {
        if (images.length == 0) {
            throw new IllegalArgumentException("You must provide at least one image.");
        }
        if (images.length != delays.length) {
            throw new IllegalArgumentException("The images array and the delays array must have the same length.");
        }
        if (images[0] == null) {
            throw new IllegalArgumentException("None of the images must be null.");
        }
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        int i = 0;
        while (i < images.length) {
            if (images[i] == null) {
                throw new IllegalArgumentException("None of the images must be null.");
            }
            if (images[i].getWidth() != width || images[i].getHeight() != height) {
                throw new IllegalArgumentException("All images must have the same size.");
            }
            ++i;
        }
        this.images = new BufferedImage[images.length];
        System.arraycopy(images, 0, this.images, 0, images.length);
        this.delays = new int[delays.length];
        System.arraycopy(delays, 0, this.delays, 0, delays.length);
        this.width = width;
        this.height = height;
        this.hotSpotX = hotSpotX;
        this.hotSpotY = hotSpotY;
        this.name = name;
    }

    public Cursor(BufferedImage[] images, int[] delays, int hotSpotX, int hotSpotY) {
        this(images, delays, hotSpotX, hotSpotY, null);
    }

    public Cursor(BufferedImage image, int hotSpotX, int hotSpotY, String name) {
        this(new BufferedImage[]{image}, new int[1], hotSpotX, hotSpotY, name);
    }

    public Cursor(BufferedImage image, int hotSpotX, int hotSpotY) {
        this(image, hotSpotX, hotSpotY, null);
    }

    private static BufferedImage[] createImagesArray(URL[] imageResources) throws IOException {
        BufferedImage[] images = new BufferedImage[imageResources.length];
        int i = 0;
        while (i < imageResources.length) {
            images[i] = ImageIO.read(imageResources[i]);
            ++i;
        }
        return images;
    }

    public Cursor(URL[] imageResources, int[] delays, int hotSpotX, int hotSpotY, String name) throws IOException {
        this(Cursor.createImagesArray(imageResources), delays, hotSpotX, hotSpotY, name);
    }

    public Cursor(URL[] imageResources, int[] delays, int hotSpotX, int hotSpotY) throws IOException {
        this(imageResources, delays, hotSpotX, hotSpotY, null);
    }

    public Cursor(URL imageResource, int hotSpotX, int hotSpotY, String name) throws IOException {
        this(new URL[]{imageResource}, new int[1], hotSpotX, hotSpotY, name);
    }

    public Cursor(URL imageResource, int hotSpotX, int hotSpotY) throws IOException {
        this(imageResource, hotSpotX, hotSpotY, null);
    }

    private Cursor(String name) {
        this.images = null;
        this.delays = null;
        this.name = name;
    }
}

