/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ac3d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.ac3d.AC3DAppearanceCache;
import org.jagatoo.loaders.models.ac3d.AC3DSurface;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.opengl.enums.BlendFunction;
import org.jagatoo.opengl.enums.BlendMode;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.ShadeModel;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureMode;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Matrix4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AC3DPrototypeLoader {
    private static NamedObject texAttribs = null;
    private static NamedObject coloringAttribs = null;

    private static int loadHeader(BufferedReader reader) throws IOException {
        String header = reader.readLine();
        String filetype = header.substring(0, 4);
        if (!filetype.equals("AC3D")) {
            System.out.println("File is not an AC3D file");
            System.out.println("Header read: " + header);
            throw new IOException("File is not an AC3D file");
        }
        String versionText = header.substring(4);
        int formatVersion = Integer.parseInt(versionText, 16);
        return formatVersion;
    }

    private static Object[] loadMaterial(String data, AppearanceFactory appFactory) {
        StringTokenizer tokenizer = new StringTokenizer(data, " ");
        tokenizer.nextToken();
        String name = tokenizer.nextToken();
        NamedObject material = appFactory.createMaterial(name);
        tokenizer.nextToken();
        float r = Float.parseFloat(tokenizer.nextToken());
        float g = Float.parseFloat(tokenizer.nextToken());
        float b = Float.parseFloat(tokenizer.nextToken());
        appFactory.setMaterialDiffuseColor(material, r, g, b);
        tokenizer.nextToken();
        r = Float.parseFloat(tokenizer.nextToken());
        g = Float.parseFloat(tokenizer.nextToken());
        b = Float.parseFloat(tokenizer.nextToken());
        appFactory.setMaterialAmbientColor(material, r, g, b);
        tokenizer.nextToken();
        r = Float.parseFloat(tokenizer.nextToken());
        g = Float.parseFloat(tokenizer.nextToken());
        b = Float.parseFloat(tokenizer.nextToken());
        appFactory.setMaterialEmissiveColor(material, r, g, b);
        tokenizer.nextToken();
        r = Float.parseFloat(tokenizer.nextToken());
        g = Float.parseFloat(tokenizer.nextToken());
        b = Float.parseFloat(tokenizer.nextToken());
        appFactory.setMaterialSpecularColor(material, r, g, b);
        tokenizer.nextToken();
        float shininess = Float.parseFloat(tokenizer.nextToken());
        appFactory.setMaterialShininess(material, shininess);
        tokenizer.nextToken();
        float translucency = Float.parseFloat(tokenizer.nextToken());
        return new Object[]{material, Float.valueOf(translucency)};
    }

    private static AC3DSurface loadSurface(BufferedReader reader, float texRepX, float texOffsetX, float texRepY, float texOffsetY) throws IOException {
        int material = -1;
        String line = reader.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        int flags = Integer.parseInt(tokenizer.nextToken().substring(2), 16);
        int type = flags & 0xF;
        boolean shaded = (flags >> 4 & 1) == 1;
        boolean twoSided = (flags >> 5 & 1) == 1;
        line = reader.readLine();
        tokenizer = new StringTokenizer(line, " ");
        String token = tokenizer.nextToken();
        if (token.equals("mat")) {
            material = Integer.parseInt(tokenizer.nextToken());
            line = reader.readLine();
            tokenizer = new StringTokenizer(line, " ");
            token = tokenizer.nextToken();
        }
        int numRefs = Integer.parseInt(tokenizer.nextToken());
        int[] surfVerts = new int[numRefs];
        float[] textCoords = new float[numRefs * 2];
        boolean hasTexCoords = false;
        int i = 0;
        while (i < numRefs) {
            line = reader.readLine();
            tokenizer = new StringTokenizer(line, " ");
            token = tokenizer.nextToken();
            surfVerts[i] = Integer.parseInt(token);
            float s = Float.parseFloat(tokenizer.nextToken()) * texRepX + texOffsetX;
            float t = Float.parseFloat(tokenizer.nextToken()) * texRepY + texOffsetY;
            if (s != 0.0f || t != 0.0f) {
                hasTexCoords = true;
            }
            textCoords[i * 2 + 0] = s;
            textCoords[i * 2 + 1] = t;
            ++i;
        }
        return new AC3DSurface(type, twoSided, shaded, material, surfVerts, (float[])(hasTexCoords ? textCoords : null));
    }

    private static NamedObject getAppearance(AC3DSurface surface, String textureName, AppearanceFactory appFactory, URL baseURL, ArrayList<NamedObject> materials, ArrayList<Float> translucencies, AC3DAppearanceCache appCache) {
        NamedObject transAttribs;
        AbstractTexture texture = null;
        if (textureName != null && !textureName.equals("")) {
            texture = appFactory.loadOrGetTexture(textureName, baseURL, true, true, true, true, true);
        }
        boolean hasMaterial = surface.getMaterialIndex() >= 0 && surface.getMaterialIndex() < materials.size();
        float translucency = 0.0f;
        if (hasMaterial) {
            translucency = translucencies.get(surface.getMaterialIndex()).floatValue();
        }
        boolean isTransparent = translucency > 0.0f || texture != null && texture.getFormat() == TextureFormat.RGBA;
        String transAttribsCacheKey = String.valueOf(String.valueOf(isTransparent)) + String.valueOf(translucency);
        String polyAttribsCacheKey = String.valueOf(String.valueOf(surface.isTwoSided())) + "-" + String.valueOf(surface.isLine());
        String appCacheKey = String.valueOf(textureName) + "-" + surface.getMaterialIndex() + "-" + transAttribsCacheKey + "-" + polyAttribsCacheKey;
        NamedObject appearance = appCache.appearanceCache.get(appCacheKey);
        if (appearance != null) {
            return appearance;
        }
        appearance = appFactory.createAppearance("", 0);
        appFactory.applyTexture(texture, 0, appearance);
        if (hasMaterial) {
            appFactory.applyMaterial(materials.get(surface.getMaterialIndex()), appearance);
        }
        if ((transAttribs = appCache.transAttribsCache.get(transAttribsCacheKey)) == null) {
            if (isTransparent) {
                transAttribs = appFactory.createTransparencyAttributes("");
                appFactory.setTransparencyAttribsBlendMode(transAttribs, BlendMode.BLENDED);
                appFactory.setTransparencyAttribsTransparency(transAttribs, translucency);
                appFactory.setTransparencyAttribsSourceBlendFunc(transAttribs, BlendFunction.SRC_ALPHA);
                appFactory.setTransparencyAttribsDestBlendFunc(transAttribs, BlendFunction.ONE_MINUS_SRC_ALPHA);
            } else {
                transAttribs = appFactory.createTransparencyAttributes("");
                appFactory.setTransparencyAttribsBlendMode(transAttribs, BlendMode.NONE);
            }
            appCache.transAttribsCache.put(transAttribsCacheKey, transAttribs);
        }
        appFactory.applyTransparancyAttributes(transAttribs, appearance);
        NamedObject polyAttributes = appCache.polyAttribsCache.get(polyAttribsCacheKey);
        if (polyAttributes == null) {
            polyAttributes = appFactory.createPolygonAttributes("");
            if (surface.isTwoSided()) {
                appFactory.setPolygonAttribsFaceCullMode(polyAttributes, FaceCullMode.NONE);
                appFactory.setPolygonAttribsBackfaceNormalFlip(polyAttributes, true);
            } else {
                appFactory.setPolygonAttribsFaceCullMode(polyAttributes, FaceCullMode.BACK);
                appFactory.setPolygonAttribsBackfaceNormalFlip(polyAttributes, false);
            }
            if (surface.isLine()) {
                appFactory.setPolygonAttribsDrawMode(polyAttributes, DrawMode.LINE);
            } else {
                appFactory.setPolygonAttribsDrawMode(polyAttributes, DrawMode.FILL);
            }
            appCache.polyAttribsCache.put(polyAttribsCacheKey, polyAttributes);
        }
        appFactory.applyPolygonAttributes(polyAttributes, appearance);
        if (texAttribs == null) {
            texAttribs = appFactory.createTextureAttributes("");
            appFactory.setTextureAttribsTextureMode(texAttribs, TextureMode.MODULATE);
        }
        appFactory.applyTextureAttributes(texAttribs, 0, appearance);
        if (coloringAttribs == null) {
            coloringAttribs = appFactory.createColoringAttributes("");
            appFactory.setColoringAttribsShadeModel(coloringAttribs, ShadeModel.NICEST);
        }
        appFactory.applyColoringAttributes(coloringAttribs, appearance);
        appCache.appearanceCache.put(appCacheKey, appearance);
        return appearance;
    }

    private static void transformVertexCoords(float[] vcs, Matrix4f t) {
        int n = vcs.length / 3;
        int i = 0;
        while (i < n) {
            float x = t.m00() * vcs[i * 3 + 0] + t.m01() * vcs[i * 3 + 1] + t.m02() * vcs[i * 3 + 2] + t.m03();
            float y = t.m10() * vcs[i * 3 + 0] + t.m11() * vcs[i * 3 + 1] + t.m12() * vcs[i * 3 + 2] + t.m13();
            float z = t.m20() * vcs[i * 3 + 0] + t.m21() * vcs[i * 3 + 1] + t.m22() * vcs[i * 3 + 2] + t.m23();
            vcs[i * 3 + 0] = x;
            vcs[i * 3 + 1] = y;
            vcs[i * 3 + 2] = z;
            ++i;
        }
    }

    private static void loadObject(BufferedReader reader, URL baseURL, ArrayList<NamedObject> materials, ArrayList<Float> translucencies, AppearanceFactory appFactory, AC3DAppearanceCache appCache, GeometryFactory geomFactory, NodeFactory nodeFactory, boolean keepNestedTransforms, Matrix4f parentTransform, NamedObject parentGroup, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        String name = null;
        String textureName = null;
        float[] vertexCoords = null;
        float textureRepeatX = 1.0f;
        float textureRepeatY = 1.0f;
        float textureOffsetX = 0.0f;
        float textureOffsetY = 0.0f;
        ArrayList<AC3DSurface> tempSurfaces = new ArrayList<AC3DSurface>();
        TreeSet<Integer> surfMatIndices = new TreeSet<Integer>();
        NamedObject childrenGroup = null;
        boolean isGroup = false;
        Matrix4f objectTransform = new Matrix4f(parentTransform);
        String line = reader.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        tokenizer.nextToken();
        String token = tokenizer.nextToken();
        if (token.equals("group")) {
            isGroup = true;
        } else if (!token.equals("poly")) {
            throw new IncorrectFormatException("Object type \"" + token + "\" is not valid");
        }
        block0: while (true) {
            int i;
            if ((token = (tokenizer = new StringTokenizer(line = reader.readLine())).nextToken()).equals("name")) {
                name = tokenizer.nextToken();
                name = name.startsWith("\"") ? (name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.substring(1, name.length())) : (name.endsWith("\"") ? name.substring(0, name.length() - 1) : name.substring(0, name.length()));
                if (!isGroup) continue;
                if (keepNestedTransforms) {
                    childrenGroup = nodeFactory.createTransformGroup(name, BoundsType.SPHERE);
                    nodeFactory.addNodeToGroup(childrenGroup, parentGroup);
                    siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.NESTED_TRANSFORM, name, childrenGroup);
                    continue;
                }
                childrenGroup = parentGroup;
                continue;
            }
            if (token.equals("data")) {
                line = reader.readLine();
                continue;
            }
            if (token.equals("texture")) {
                tokenizer.nextToken("\"");
                textureName = tokenizer.nextToken("\"");
                continue;
            }
            if (token.equals("texoff")) {
                textureOffsetX = Float.parseFloat(tokenizer.nextToken());
                textureOffsetY = Float.parseFloat(tokenizer.nextToken());
                continue;
            }
            if (token.equals("texrep")) {
                textureRepeatX = Float.parseFloat(tokenizer.nextToken());
                textureRepeatY = Float.parseFloat(tokenizer.nextToken());
                continue;
            }
            if (token.equals("rot")) {
                objectTransform.m00(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m01(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m02(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m10(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m11(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m12(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m20(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m21(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m22(Float.parseFloat(tokenizer.nextToken()));
                continue;
            }
            if (token.equals("loc")) {
                objectTransform.m03(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m13(Float.parseFloat(tokenizer.nextToken()));
                objectTransform.m23(Float.parseFloat(tokenizer.nextToken()));
                continue;
            }
            if (token.equals("url")) {
                System.out.println("url tag unsupported");
                continue;
            }
            if (token.equals("numvert")) {
                int numvert = Integer.parseInt(tokenizer.nextToken());
                vertexCoords = new float[numvert * 3];
                i = 0;
                while (true) {
                    if (i >= numvert) continue block0;
                    line = reader.readLine();
                    tokenizer = new StringTokenizer(line, " ");
                    vertexCoords[i * 3 + 0] = Float.parseFloat(tokenizer.nextToken());
                    vertexCoords[i * 3 + 1] = Float.parseFloat(tokenizer.nextToken());
                    vertexCoords[i * 3 + 2] = Float.parseFloat(tokenizer.nextToken());
                    ++i;
                }
            }
            if (token.equals("numsurf")) {
                int numsurf = Integer.parseInt(tokenizer.nextToken());
                i = 0;
                while (true) {
                    if (i >= numsurf) continue block0;
                    AC3DSurface surface = AC3DPrototypeLoader.loadSurface(reader, textureRepeatX, textureOffsetX, textureRepeatY, textureOffsetY);
                    if (surface.getMaterialIndex() >= 0 && surface.getMaterialIndex() < materials.size()) {
                        surfMatIndices.add(surface.getMaterialIndex());
                    } else {
                        surfMatIndices.add(-1);
                    }
                    if (surface.isLine() || surface.getVertexReferenceCount() >= 3) {
                        tempSurfaces.add(surface);
                    } else {
                        --numsurf;
                        --i;
                    }
                    ++i;
                }
            }
            if (token.equals("kids")) break;
        }
        if (childrenGroup != null) {
            if (keepNestedTransforms) {
                nodeFactory.setTransformGroupTransform(childrenGroup, objectTransform);
            } else {
                objectTransform.mul(parentTransform);
                AC3DPrototypeLoader.transformVertexCoords(vertexCoords, objectTransform);
            }
        }
        ArrayList<AC3DSurface> uniSurfs = new ArrayList<AC3DSurface>();
        int uniIdx = -1;
        for (Integer surfMatIndex : surfMatIndices) {
            uniSurfs.clear();
            ++uniIdx;
            int numVertices = 0;
            int i = 0;
            while (i < tempSurfaces.size()) {
                AC3DSurface surface = (AC3DSurface)tempSurfaces.get(i);
                if (surface.getMaterialIndex() >= 0 && surface.getMaterialIndex() < materials.size()) {
                    if (surface.getMaterialIndex() == surfMatIndex.intValue()) {
                        uniSurfs.add(surface);
                        numVertices += surface.getVertexReferenceCount();
                    }
                } else if (surfMatIndex == -1) {
                    uniSurfs.add(surface);
                    numVertices += surface.getVertexReferenceCount();
                }
                ++i;
            }
            GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.TRIANGLE_ARRAY;
            NamedObject geom = geomFactory.createGeometry(String.valueOf(name) + "_" + uniIdx, geomType, 3, numVertices, 0, null);
            int vertexIndex = 0;
            int i2 = 0;
            while (i2 < uniSurfs.size()) {
                AC3DSurface surface = (AC3DSurface)uniSurfs.get(i2);
                int j = 0;
                while (j < surface.getVertexReferenceCount()) {
                    int vertexRef = surface.getVertexReferences()[j];
                    geomFactory.setCoordinate(geom, geomType, vertexIndex, vertexCoords[vertexRef * 3 + 0], vertexCoords[vertexRef * 3 + 1], vertexCoords[vertexRef * 3 + 2]);
                    if (surface.hasTextureCoordinates()) {
                        geomFactory.setTexCoords(geom, geomType, 0, 2, vertexIndex, surface.getTextureCoordinates(), vertexRef * 2, 1);
                    }
                    ++vertexIndex;
                    ++j;
                }
                ++i2;
            }
            NamedObject appearance = AC3DPrototypeLoader.getAppearance((AC3DSurface)uniSurfs.get(0), textureName, appFactory, baseURL, materials, translucencies, appCache);
            NamedObject shape = nodeFactory.createShape(String.valueOf(name) + "_" + uniIdx, geom, appearance, BoundsType.SPHERE);
            nodeFactory.addNodeToGroup(shape, parentGroup);
            siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, shape.getName(), shape);
        }
        if (token.equals("kids")) {
            int numKids = Integer.parseInt(tokenizer.nextToken());
            if (numKids > 0) {
                if (!isGroup) {
                    throw new IncorrectFormatException("Detected a number of kids (" + numKids + "), but no group.");
                }
                AC3DPrototypeLoader.loadObjects(reader, numKids, baseURL, materials, translucencies, appFactory, appCache, geomFactory, nodeFactory, keepNestedTransforms, objectTransform, childrenGroup, siHandler);
            }
        } else {
            throw new ParsingException("\"" + token.toString() + "\"" + " found where only a 'kids' should be");
        }
    }

    private static void loadObjects(BufferedReader reader, int numKids, URL baseURL, ArrayList<NamedObject> materials, ArrayList<Float> translucencies, AppearanceFactory appFactory, AC3DAppearanceCache appCache, GeometryFactory geomFactory, NodeFactory nodeFactory, boolean keepNestedTransforms, Matrix4f parentTransform, NamedObject parentGroup, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        int i = 0;
        while (i < numKids) {
            AC3DPrototypeLoader.loadObject(reader, baseURL, materials, translucencies, appFactory, appCache, geomFactory, nodeFactory, keepNestedTransforms, parentTransform, parentGroup, siHandler);
            ++i;
        }
    }

    public static void load(InputStream in, URL baseURL, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, boolean keepNestedTransforms, NamedObject rootGroup, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        AC3DPrototypeLoader.loadHeader(reader);
        ArrayList<NamedObject> materials = new ArrayList<NamedObject>();
        ArrayList<Float> translucencies = new ArrayList<Float>();
        AC3DAppearanceCache appCache = new AC3DAppearanceCache();
        Matrix4f rootTransform = new Matrix4f();
        rootTransform.setIdentity();
        while ((line = reader.readLine()) != null) {
            String token = new StringTokenizer(line, " ").nextToken();
            if (token.equals("MATERIAL")) {
                Object[] mat = AC3DPrototypeLoader.loadMaterial(line, appFactory);
                materials.add((NamedObject)mat[0]);
                translucencies.add((Float)mat[1]);
                continue;
            }
            if (!token.equals("OBJECT")) continue;
            line = reader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            token = tokenizer.nextToken();
            if (!token.equals("kids")) {
                throw new ParsingException("expected \"kids\" line, but found \"" + line + "\".");
            }
            int numKids = Integer.parseInt(tokenizer.nextToken());
            AC3DPrototypeLoader.loadObjects(reader, numKids, baseURL, materials, translucencies, appFactory, appCache, geomFactory, nodeFactory, keepNestedTransforms, rootTransform, rootGroup, siHandler);
        }
    }
}

