/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jagatoo.loaders.models.ase.AseFileLine;
import org.jagatoo.loaders.models.ase.AseGeom;
import org.jagatoo.loaders.models.ase.AseGraph;
import org.jagatoo.loaders.models.ase.AseGroup;
import org.jagatoo.loaders.models.ase.AseMaterial;
import org.jagatoo.loaders.models.ase.AseNode;
import org.jagatoo.loaders.models.ase.AseReader;
import org.jagatoo.loaders.models.ase.AseTransform;
import org.jagatoo.logging.JAGTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AseFile
extends AseNode {
    public float version;
    public String comment = "";
    public AseGraph aseGraph = new AseGraph();
    public Map<String, AseNode> objects = new HashMap<String, AseNode>();
    public Map<String, AseNode> allTopLevelObjects = new HashMap<String, AseNode>();
    public List<AseMaterial> materials = new ArrayList<AseMaterial>();
    public int materialCount;
    private static final String fabricatedGroupNodeSuffix = "_GROUP_";

    private static AseGroup groupNodeForGeometry(Map<String, AseNode> objects, Map<String, AseNode> allTopLevelObjects, AseGeom geom) {
        if (geom instanceof AseGroup) {
            return (AseGroup)geom;
        }
        String fabricatedGroupName = String.valueOf(geom.name) + fabricatedGroupNodeSuffix;
        AseGroup group = (AseGroup)allTopLevelObjects.get(fabricatedGroupName);
        if (group != null) {
            return group;
        }
        group = new AseGroup();
        group.name = fabricatedGroupName;
        group.objects.put(geom.name, geom);
        AseTransform tmpXform = geom.transform;
        geom.transform = group.transform;
        group.transform = tmpXform;
        if (objects.remove(geom.name) == null) {
            JAGTLog.exception("Warning: node named \"" + geom.name + "\" not in top-level objects map");
        }
        objects.put(group.name, group);
        allTopLevelObjects.put(group.name, group);
        return group;
    }

    public static void updateHierarchyFromNodeParent(Map<String, AseNode> objects, Map<String, AseNode> allTopLevelObjects, AseGeom geom) {
        String parentName = geom.parentName;
        if (parentName != null && !parentName.equals("")) {
            geom = AseFile.groupNodeForGeometry(objects, allTopLevelObjects, geom);
            AseNode parentNode = allTopLevelObjects.get(parentName);
            if (parentNode == null) {
                JAGTLog.exception("Warning: unable to find parent node named \"" + geom.parentName + "\"");
                return;
            }
            if (!(parentNode instanceof AseGeom)) {
                Class<?> parentClass = parentNode.getClass();
                JAGTLog.exception("Warning: unknown / unsupported parent node type \"" + parentClass.getName() + "\"");
            }
            AseGroup parentGroup = AseFile.groupNodeForGeometry(objects, allTopLevelObjects, (AseGeom)parentNode);
            objects.remove(geom.name);
            parentGroup.objects.put(geom.name, geom);
        }
    }

    @Override
    public void parse(AseReader in) {
        try {
            try {
                AseFileLine line;
                while ((line = in.readAseLine()) != null) {
                    if (this.parseProperty(in, line)) continue;
                    switch (line.getType()) {
                        case GEOMETRY_OBJECT: {
                            JAGTLog.debug("Geom Object Starting");
                            AseGeom a = new AseGeom();
                            a.parse(in);
                            this.objects.put(a.name, a);
                            this.allTopLevelObjects.put(a.name, a);
                            AseFile.updateHierarchyFromNodeParent(this.objects, this.allTopLevelObjects, a);
                            JAGTLog.debug("Geom Object " + a.name + " parsed");
                            break;
                        }
                        case GROUP: {
                            AseGroup g = new AseGroup();
                            g.parse(in);
                            this.objects.put(g.name, g);
                            this.allTopLevelObjects.put(g.name, g);
                            AseFile.updateHierarchyFromNodeParent(this.objects, this.allTopLevelObjects, g);
                            JAGTLog.debug("Geom Object " + g.name + " parsed");
                            break;
                        }
                        case MATERIAL_LIST: {
                            JAGTLog.debug("Parsing material list");
                            break;
                        }
                        case MATERIAL: {
                            int n = Integer.parseInt(line.getParameter(0));
                            if (n != this.materials.size()) {
                                throw new Error("Material index does not match material list");
                            }
                            AseMaterial m = new AseMaterial();
                            m.parse(in);
                            JAGTLog.debug("   Parsed material " + m.name);
                            this.materials.add(m);
                            break;
                        }
                        default: {
                            this.trashBlock(in);
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    in.close();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public AseFile() {
        this.properties.put("*3DSMAX_ASCIIEXPORT", "version");
        this.properties.put("*COMMENT", "comment");
        this.properties.put("*SCENE", "aseGraph");
        this.properties.put("*MATERIAL_COUNT", "materialCount");
    }
}

