/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.bsp;

import java.util.BitSet;
import org.jagatoo.loaders.models.bsp.BSPScenePrototype;
import org.jagatoo.loaders.models.bsp.BSPVisibilityUpdater;
import org.jagatoo.loaders.models.bsp.lumps.BSPLeaf;
import org.jagatoo.loaders.models.bsp.lumps.BSPNode;
import org.jagatoo.loaders.models.bsp.lumps.BSPPlane;
import org.jagatoo.loaders.models.bsp.lumps.BSPVisData;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.FloatUtils;

public class BSPClusterManager
implements BSPVisibilityUpdater {
    private final BSPVisData bspVisData;
    private final boolean hasVisBitset;
    protected final BitSet shapeBitset;
    private final int[][][] clusterLeafs;
    private final int[] leafToCluster;
    private final float[] planes;
    private final int[] nodes;
    private boolean usePVS = true;
    private boolean lastUsePVS = true;
    private int lastCluster = -2;

    public final BitSet getBitSet() {
        return this.shapeBitset;
    }

    private int getCluster(Tuple3f camPos) {
        int index = 0;
        while (index >= 0) {
            int node2 = index * 3;
            int planeIndex = this.nodes[node2 + 0] * 4;
            float nx = this.planes[planeIndex + 0];
            float ny = this.planes[planeIndex + 1];
            float nz = this.planes[planeIndex + 2];
            float d = this.planes[planeIndex + 3];
            float dot = FloatUtils.dot(nx, ny, nz, camPos.getX(), camPos.getY(), camPos.getZ());
            float distance = dot - d;
            index = distance > 1.0E-4f ? this.nodes[node2 + 1] : this.nodes[node2 + 2];
        }
        return this.leafToCluster[-(index + 1)];
    }

    private final boolean isClusterVisible(int camCluster, int testCluster) {
        int i = camCluster * this.bspVisData.bytesPerCluster + testCluster / 8;
        return (this.bspVisData.pBitsets[i] & 1 << (testCluster & 7)) != 0;
    }

    public void setPVSUsage(boolean enabled) {
        this.usePVS = enabled;
    }

    public boolean isPVSUsed() {
        return this.usePVS;
    }

    public boolean updateVisibility(Matrix4f cameraTransform) {
        Point3f camPos = Point3f.fromPool();
        cameraTransform.get(camPos);
        boolean usePVSChanged = this.usePVS ^ this.lastUsePVS;
        this.lastUsePVS = this.usePVS;
        if (!this.usePVS) {
            this.shapeBitset.set(0, this.shapeBitset.size() - 1);
            Point3f.toPool(camPos);
            return true;
        }
        int camCluster = this.getCluster(camPos);
        if (this.lastCluster == camCluster && !usePVSChanged) {
            Point3f.toPool(camPos);
            return false;
        }
        this.lastCluster = camCluster;
        boolean allClustersVisible = !this.hasVisBitset || camCluster < 0;
        this.shapeBitset.clear();
        int i = 0;
        while (i < this.bspVisData.numOfClusters) {
            int[][] clusterLeafs_i = this.clusterLeafs[i];
            if (clusterLeafs_i != null && (allClustersVisible || this.isClusterVisible(camCluster, i))) {
                int j = 0;
                while (j < clusterLeafs_i.length) {
                    int[] clusterLeafs_i_j = clusterLeafs_i[j];
                    if (clusterLeafs_i_j.length > 0) {
                        int k = 0;
                        while (k < clusterLeafs_i_j.length) {
                            int clusterLeaf = clusterLeafs_i_j[k];
                            if (!this.shapeBitset.get(clusterLeaf)) {
                                this.shapeBitset.set(clusterLeaf);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Point3f.toPool(camPos);
        return true;
    }

    public BSPClusterManager(BSPVisData bspVisData, int[][][] clusterLeafs, int[] leafToCluster, float[] planes, int[] nodes, BitSet shapeBitset) {
        this.bspVisData = bspVisData;
        this.hasVisBitset = bspVisData.pBitsets != null;
        this.clusterLeafs = clusterLeafs;
        this.leafToCluster = leafToCluster;
        this.planes = planes;
        this.nodes = nodes;
        this.shapeBitset = shapeBitset;
    }

    public BSPClusterManager(BSPClusterManager template) {
        this.bspVisData = template.bspVisData;
        this.hasVisBitset = template.hasVisBitset;
        this.clusterLeafs = template.clusterLeafs;
        this.leafToCluster = template.leafToCluster;
        this.planes = template.planes;
        this.nodes = template.nodes;
        this.shapeBitset = template.shapeBitset;
    }

    private static int[] convertNodes(BSPNode[] bspNodes) {
        int[] nodes = new int[bspNodes.length * 3];
        int i = 0;
        while (i < bspNodes.length) {
            int j = i * 3;
            nodes[j + 0] = bspNodes[i].plane;
            nodes[j + 1] = bspNodes[i].front;
            nodes[j + 2] = bspNodes[i].back;
            ++i;
        }
        return nodes;
    }

    private static int[] convertLeaf(BSPLeaf leaf, int[] leafFaces, int[][][] clusterLeafs, int[] clusterLeaf) {
        if (leaf.numOfLeafFaces == 0) {
            return new int[0];
        }
        int[] leafFaces2 = new int[leaf.numOfLeafFaces];
        int i = 0;
        while (i < leaf.numOfLeafFaces) {
            leafFaces2[i] = leafFaces[i + leaf.leafFace];
            ++i;
        }
        int n = leaf.cluster;
        clusterLeaf[n] = clusterLeaf[n] + 1;
        if (clusterLeafs[leaf.cluster] == null) {
            clusterLeafs[leaf.cluster] = new int[1][];
        } else {
            int[][] tmp = new int[clusterLeafs[leaf.cluster].length + 1][];
            System.arraycopy(clusterLeafs[leaf.cluster], 0, tmp, 0, clusterLeafs[leaf.cluster].length);
            clusterLeafs[leaf.cluster] = tmp;
        }
        clusterLeafs[leaf.cluster][clusterLeafs[leaf.cluster].length - 1] = leafFaces2;
        return leafFaces2;
    }

    private static float[] convertPlanes(BSPPlane[] bspPlanes) {
        float[] planes = new float[bspPlanes.length * 4];
        int i = 0;
        while (i < bspPlanes.length) {
            int j = i * 4;
            planes[j + 0] = bspPlanes[i].normal.getX();
            planes[j + 1] = bspPlanes[i].normal.getZ();
            planes[j + 2] = -bspPlanes[i].normal.getY();
            planes[j + 3] = bspPlanes[i].d;
            ++i;
        }
        return planes;
    }

    public static BSPClusterManager create(BSPScenePrototype prototype, BitSet faceBitset) {
        int[] clusterLeaf = new int[prototype.leafs.length];
        int[][][] clusterLeafs = new int[prototype.visData.numOfClusters][][];
        int[][] leafs = new int[prototype.leafs.length][];
        int[] leafToCluster = new int[prototype.leafs.length];
        int i = 0;
        while (i < prototype.leafs.length) {
            leafs[i] = BSPClusterManager.convertLeaf(prototype.leafs[i], prototype.leafFaces, clusterLeafs, clusterLeaf);
            leafToCluster[i] = prototype.leafs[i].cluster;
            ++i;
        }
        JAGTLog.debug("Converting nodes...");
        int[] nodes = BSPClusterManager.convertNodes(prototype.nodes);
        float[] planes = BSPClusterManager.convertPlanes(prototype.planes);
        int numLeaves = 0;
        int i2 = 0;
        while (i2 < clusterLeaf.length) {
            numLeaves += clusterLeaf[i2];
            ++i2;
        }
        JAGTLog.debug("total referenced leaves = ", numLeaves);
        JAGTLog.debug("total leaves = ", prototype.leafs.length);
        JAGTLog.debug("total faces = ", prototype.geometries[0].length);
        return new BSPClusterManager(prototype.visData, clusterLeafs, leafToCluster, planes, nodes, faceBitset);
    }
}

