/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.buffer;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.vecmath2.Quaternion4f;

public class Quat4fBuffer {
    FloatBuffer floatBuffer;

    public Quat4fBuffer(int length) {
        this.floatBuffer = BufferUtils.createFloatBuffer(length * 4);
    }

    public void put(int n, float x, float y, float z, float w) {
        this.floatBuffer.put(4 * n + 0, x);
        this.floatBuffer.put(4 * n + 1, y);
        this.floatBuffer.put(4 * n + 2, z);
        this.floatBuffer.put(4 * n + 3, w);
    }

    public void put(int n, Quaternion4f v) {
        this.floatBuffer.put(4 * n + 0, v.getA());
        this.floatBuffer.put(4 * n + 1, v.getB());
        this.floatBuffer.put(4 * n + 2, v.getC());
        this.floatBuffer.put(4 * n + 3, v.getD());
    }

    public void putX(int n, float x) {
        this.floatBuffer.put(4 * n + 0, x);
    }

    public void putY(int n, float y) {
        this.floatBuffer.put(4 * n + 1, y);
    }

    public void putZ(int n, float z) {
        this.floatBuffer.put(4 * n + 2, z);
    }

    public void putW(int n, float w) {
        this.floatBuffer.put(4 * n + 3, w);
    }

    public Quaternion4f get(int n) {
        return new Quaternion4f(this.floatBuffer.get(4 * n + 0), this.floatBuffer.get(4 * n + 1), this.floatBuffer.get(4 * n + 2), this.floatBuffer.get(4 * n + 3));
    }

    public float getX(int n) {
        return this.floatBuffer.get(4 * n + 0);
    }

    public float getY(int n) {
        return this.floatBuffer.get(4 * n + 1);
    }

    public float getZ(int n) {
        return this.floatBuffer.get(4 * n + 2);
    }

    public float getW(int n) {
        return this.floatBuffer.get(4 * n + 3);
    }

    public Buffer getBuffer() {
        return this.floatBuffer;
    }
}

