/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.ArrayList;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalCoreBone {
    private static Quaternion4f qq = new Quaternion4f();
    private static Quaternion4f qc = new Quaternion4f();
    protected String name;
    protected CalCoreSkeleton coreSkeleton;
    int id;
    protected int parentId;
    protected ArrayList<Integer> listChildId = new ArrayList();
    protected Vector3f translation = new Vector3f();
    protected Quaternion4f rotation = new Quaternion4f();
    protected Vector3f translationAbsolute = new Vector3f();
    protected Quaternion4f rotationAbsolute = new Quaternion4f();
    protected Vector3f translationBoneSpace = new Vector3f();
    protected Quaternion4f rotationBoneSpace = new Quaternion4f();
    protected Matrix3f stateTransform = new Matrix3f();
    protected Object userData;

    public CalCoreBone(String name) {
        this.name = name;
        this.coreSkeleton = null;
        this.parentId = -1;
        this.userData = null;
    }

    public void addChildId(int childId) {
        this.listChildId.add(new Integer(childId));
    }

    public void calculateState() {
        if (this.parentId == -1) {
            this.translationAbsolute.set((TupleNf)this.translation);
            this.rotationAbsolute.set((TupleNf)this.rotation);
        } else {
            CalCoreBone parent = this.coreSkeleton.getCoreBone(this.parentId);
            this.translationAbsolute.set((TupleNf)this.translation);
            CalCoreBone.transform(this.translationAbsolute, parent.getRotationAbsolute());
            this.translationAbsolute.add(parent.getTranslationAbsolute());
            this.rotationAbsolute.set((TupleNf)this.rotation);
            this.rotationAbsolute.mul(parent.getRotationAbsolute());
        }
        for (int childId : this.listChildId) {
            this.coreSkeleton.getCoreBone(childId).calculateState();
        }
    }

    public static void transform(Vector3f v, Quaternion4f q) {
        qq.set(-q.getA(), -q.getB(), -q.getC(), q.getD());
        CalCoreBone.mul(qq, v);
        qq.mul(q);
        v.setX(qq.getA());
        v.setY(qq.getB());
        v.setZ(qq.getC());
    }

    public static void transformInv(Vector3f v, Quaternion4f q) {
        qq.set((TupleNf)q);
        qc.set(-q.getA(), -q.getB(), -q.getC(), q.getD());
        CalCoreBone.mul(qq, v);
        qq.mul(qc);
        v.setX(qq.getA());
        v.setY(qq.getB());
        v.setZ(qq.getC());
    }

    public static void mul(Quaternion4f q, Vector3f v) {
        float qx = q.getA();
        float qy = q.getB();
        float qz = q.getC();
        float qw = q.getD();
        q.setA(qw * v.getX() + qy * v.getZ() - qz * v.getY());
        q.setB(qw * v.getY() - qx * v.getZ() + qz * v.getX());
        q.setC(qw * v.getZ() + qx * v.getY() - qy * v.getX());
        q.setD(-qx * v.getX() - qy * v.getY() - qz * v.getZ());
    }

    public ArrayList<Integer> getListChildId() {
        return this.listChildId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public Quaternion4f getRotation() {
        return this.rotation;
    }

    public Quaternion4f getRotationAbsolute() {
        return this.rotationAbsolute;
    }

    public Quaternion4f getRotationBoneSpace() {
        return this.rotationBoneSpace;
    }

    public Vector3f getTranslation() {
        return this.translation;
    }

    public Vector3f getTranslationAbsolute() {
        return this.translationAbsolute;
    }

    public Vector3f getTranslationBoneSpace() {
        return this.translationBoneSpace;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setCoreSkeleton(CalCoreSkeleton coreSkeleton) {
        this.coreSkeleton = coreSkeleton;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public void setRotation(Quaternion4f rotation) {
        this.rotation.set((TupleNf)rotation);
    }

    public void setRotationBoneSpace(Quaternion4f rotation) {
        this.rotationBoneSpace.set((TupleNf)rotation);
    }

    public void setTranslation(Vector3f translation) {
        this.translation.set((TupleNf)translation);
    }

    public void setTranslationBoneSpace(Vector3f translation) {
        this.translationBoneSpace.set((TupleNf)translation);
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

