/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalCoreBone;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalCoreSkeleton {
    protected String name;
    protected Vector<CalCoreBone> vectorCoreBone = new Vector();
    protected Map<String, CalCoreBone> coreBonesByName = new HashMap<String, CalCoreBone>();
    protected List<Integer> listRootCoreBoneId = new ArrayList<Integer>();

    public int addCoreBone(CalCoreBone coreBone) {
        int boneId;
        coreBone.setCoreSkeleton(this);
        coreBone.id = boneId = this.vectorCoreBone.size();
        this.vectorCoreBone.add(coreBone);
        this.coreBonesByName.put(coreBone.getName(), coreBone);
        if (coreBone.getParentId() == -1) {
            this.listRootCoreBoneId.add(new Integer(boneId));
        }
        return boneId;
    }

    public void calculateState() {
        for (int rootCoreBoneId : this.listRootCoreBoneId) {
            this.vectorCoreBone.get(rootCoreBoneId).calculateState();
        }
    }

    public void calculateBoneSpaces() {
        for (CalCoreBone coreBone : this.vectorCoreBone) {
            Quaternion4f absRot = coreBone.getRotationAbsolute();
            Vector3f absDisp = coreBone.getTranslationAbsolute();
            Vector3f boneDisp = new Vector3f(absDisp);
            boneDisp.negate();
            Quaternion4f invRot = new Quaternion4f(absRot);
            invRot.invert();
            CalCoreBone.transform(boneDisp, invRot);
            coreBone.setRotationBoneSpace(invRot);
            coreBone.setTranslationBoneSpace(boneDisp);
        }
    }

    public CalCoreBone getCoreBone(int coreBoneId) {
        return this.vectorCoreBone.elementAt(coreBoneId);
    }

    public int getCoreBoneId(String strName) {
        int boneId = 0;
        while (boneId < this.vectorCoreBone.size()) {
            if (this.vectorCoreBone.get(boneId).getName().equals(strName)) {
                return boneId;
            }
            ++boneId;
        }
        return -1;
    }

    public CalCoreBone getCoreBone(String name) {
        return this.coreBonesByName.get(name);
    }

    public List<Integer> getListRootCoreBoneId() {
        return this.listRootCoreBoneId;
    }

    public Vector<CalCoreBone> getCoreBones() {
        return this.vectorCoreBone;
    }

    public void reconnectChildren() {
        for (CalCoreBone child : this.vectorCoreBone) {
            if (child.parentId == -1) continue;
            CalCoreBone parent = this.getCoreBone(child.parentId);
            parent.addChildId(child.id);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toStringAsTree() {
        StringBuffer buffer = new StringBuffer();
        for (int root : this.listRootCoreBoneId) {
            this.toStringAsTree(buffer, 0, this.vectorCoreBone.get(root));
        }
        return buffer.toString();
    }

    void toStringAsTree(StringBuffer buffer, int depth, CalCoreBone bone) {
        int n = 0;
        while (n < depth) {
            buffer.append("  ");
            ++n;
        }
        buffer.append(bone.getName());
        buffer.append("\n");
        for (int child : bone.getListChildId()) {
            this.toStringAsTree(buffer, depth + 1, this.vectorCoreBone.get(child));
        }
    }
}

