/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.buffer.ScalarfBuffer;
import org.jagatoo.loaders.models.cal3d.buffer.TexCoord2fBuffer;
import org.jagatoo.loaders.models.cal3d.buffer.Vector3fBuffer;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubMorphTarget;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalCoreSubmesh {
    protected VertexInfo[] vectorVertexInfo;
    protected Vector3fBuffer vertexPositions;
    protected Vector3fBuffer vertexNormals;
    protected boolean[] tangentsEnabled;
    protected Vector3fBuffer[] vertexTangents;
    protected ScalarfBuffer[] vertexTangentCrossFactors;
    protected TexCoord2fBuffer[] textureCoordinateBuffers;
    protected float[] vectorPhysicalProperty;
    protected Face[] vectorFace;
    protected Spring[] vectorSpring;
    protected Vector<CalCoreSubMorphTarget> coreSubMorphTargets;
    protected int coreMaterialThreadId = 0;
    protected int lodCount = 0;

    public int getCoreMaterialThreadId() {
        return this.coreMaterialThreadId;
    }

    public int getFaceCount() {
        return this.vectorFace.length;
    }

    public int getLodCount() {
        return this.lodCount;
    }

    public int getSpringCount() {
        return this.vectorSpring == null ? 0 : this.vectorSpring.length;
    }

    public Face[] getVectorFace() {
        return this.vectorFace;
    }

    public float[] getVectorPhysicalProperty() {
        return this.vectorPhysicalProperty;
    }

    public Spring[] getVectorSpring() {
        return this.vectorSpring;
    }

    public TexCoord2fBuffer[] getTextureCoordinates() {
        return this.textureCoordinateBuffers;
    }

    public VertexInfo[] getVectorVertexInfo() {
        return this.vectorVertexInfo;
    }

    public int getVertexCount() {
        return this.vectorVertexInfo.length;
    }

    public void reserve(int vertexCount, int textureCoordinateCount, int faceCount, int springCount) {
        this.vectorVertexInfo = new VertexInfo[vertexCount];
        this.vertexPositions = new Vector3fBuffer(vertexCount);
        this.vertexNormals = new Vector3fBuffer(vertexCount);
        this.textureCoordinateBuffers = new TexCoord2fBuffer[textureCoordinateCount];
        int textureCoordinateId = 0;
        while (textureCoordinateId < textureCoordinateCount) {
            this.textureCoordinateBuffers[textureCoordinateId] = new TexCoord2fBuffer(vertexCount);
            ++textureCoordinateId;
        }
        this.tangentsEnabled = new boolean[textureCoordinateCount];
        this.vertexTangents = new Vector3fBuffer[textureCoordinateCount];
        this.vertexTangentCrossFactors = new ScalarfBuffer[textureCoordinateCount];
        this.vectorFace = new Face[faceCount];
        if (springCount > 0) {
            this.vectorSpring = new Spring[springCount];
            this.vectorPhysicalProperty = new float[vertexCount];
        }
    }

    public void setCoreMaterialThreadId(int coreMaterialThreadId) {
        this.coreMaterialThreadId = coreMaterialThreadId;
    }

    public void setFace(int faceId, Face face) {
        this.vectorFace[faceId] = face;
    }

    public void setLodCount(int lodCount) {
        this.lodCount = lodCount;
    }

    public void setPhysicalProperty(int vertexId, float physicalProperty) {
        this.vectorPhysicalProperty[vertexId] = physicalProperty;
    }

    public void setSpring(int springId, Spring spring) {
        this.vectorSpring[springId] = spring;
    }

    public void setTextureCoordinate(int vertexId, int textureCoordinateId, Vector2f textureCoordinate) {
        this.textureCoordinateBuffers[textureCoordinateId].put(vertexId, textureCoordinate);
    }

    public void setVertex(int vertexId, VertexInfo vertex, Vector3f position, Vector3f normal) {
        this.vectorVertexInfo[vertexId] = vertex;
        this.vertexPositions.put(vertexId, position);
        this.vertexNormals.put(vertexId, normal);
    }

    public void setTangentSpace(int vertexId, int textureCoordinateId, Vector3f tangent, float crossFactor) {
        if (!this.tangentsEnabled[textureCoordinateId]) {
            throw new IllegalArgumentException("Tangents have not been enabled for texture coordinate id");
        }
        this.vertexTangents[textureCoordinateId].put(vertexId, tangent);
        this.vertexTangentCrossFactors[textureCoordinateId].put(vertexId, crossFactor);
    }

    public Vector3fBuffer getVertexNormals() {
        return this.vertexNormals;
    }

    public void getVertexNormal(int vertexId, Vector3f normal) {
        this.vertexNormals.get(vertexId, normal);
    }

    public Vector3fBuffer getVertexPositions() {
        return this.vertexPositions;
    }

    public void getVertexPosition(int vertexId, Vector3f position) {
        this.vertexPositions.get(vertexId, position);
    }

    public Vector3fBuffer getVertexTangents(int mapId) {
        return this.vertexTangents[mapId];
    }

    public ScalarfBuffer getVertexTangentCrossFactors(int mapId) {
        return this.vertexTangentCrossFactors[mapId];
    }

    public boolean isTangentsEnabled(int mapId) {
        if (this.tangentsEnabled == null || mapId < 0 || mapId >= this.tangentsEnabled.length) {
            return false;
        }
        return this.tangentsEnabled[mapId];
    }

    public void setTangentsEnabled(int mapId, boolean enabled) {
        if (this.tangentsEnabled == null || mapId < 0 || mapId >= this.tangentsEnabled.length) {
            throw new IllegalArgumentException("Texture map id to enable tangents does not exist");
        }
        this.tangentsEnabled[mapId] = enabled;
        if (enabled) {
            this.vertexTangents[mapId] = new Vector3fBuffer(this.getVertexCount());
            this.vertexTangentCrossFactors[mapId] = new ScalarfBuffer(this.getVertexCount());
            int n = 0;
            while (n < this.getVertexCount()) {
                this.vertexTangents[mapId].put(n, 0.0f, 0.0f, 0.0f);
                this.vertexTangentCrossFactors[mapId].put(n, 1.0f);
                ++n;
            }
            Face[] faceArray = this.vectorFace;
            int n2 = this.vectorFace.length;
            int n3 = 0;
            while (n3 < n2) {
                Face face = faceArray[n3];
                this.updateTangentVector(face.vertexId[0], face.vertexId[1], face.vertexId[2], mapId);
                this.updateTangentVector(face.vertexId[1], face.vertexId[2], face.vertexId[0], mapId);
                this.updateTangentVector(face.vertexId[2], face.vertexId[0], face.vertexId[1], mapId);
                ++n3;
            }
            Vector3f tangent = new Vector3f();
            int n4 = 0;
            while (n4 < this.getVertexCount()) {
                this.vertexTangents[mapId].get(n4, tangent);
                tangent.normalize();
                this.vertexTangents[mapId].put(n4, tangent);
                ++n4;
            }
        } else {
            this.vertexTangents[mapId] = null;
            this.vertexTangentCrossFactors[mapId] = null;
        }
    }

    public void updateTangentVector(int v0, int v1, int v2, int mapId) {
        TexCoord2fBuffer vtex = this.textureCoordinateBuffers[mapId];
        float vtex0u = vtex.getX(v0);
        float vtex0v = vtex.getY(v0);
        float vtex1u = vtex.getX(v1);
        float vtex1v = vtex.getY(v1);
        float vtex2u = vtex.getX(v2);
        float vtex2v = vtex.getY(v2);
        float du1 = vtex1u - vtex0u;
        float dv1 = vtex1v - vtex0v;
        float du2 = vtex2u - vtex0u;
        float dv2 = vtex2v - vtex0v;
        float prod1 = du1 * dv2 - dv1 * du2;
        float prod2 = du2 * dv1 - dv2 * du1;
        if ((double)Math.abs(prod1) < 1.0E-6 || (double)Math.abs(prod2) < 1.0E-6) {
            return;
        }
        float x = dv2 / prod1;
        float y = dv1 / prod2;
        Vector3f vec0 = new Vector3f();
        Vector3f vec1 = new Vector3f();
        Vector3f vec2 = new Vector3f();
        this.vertexPositions.get(v0, vec0);
        this.vertexPositions.get(v1, vec1);
        this.vertexPositions.get(v2, vec2);
        vec1.sub(vec0);
        vec1.scale(x);
        vec2.sub(vec0);
        vec2.scale(y);
        Vector3f tangent = new Vector3f();
        tangent.add(vec1, vec2);
        Vector3f norm0 = new Vector3f();
        this.vertexNormals.get(v0, norm0);
        float component = tangent.dot(norm0);
        norm0.scale(component);
        tangent.sub(norm0);
        tangent.normalize();
        this.vertexTangents[mapId].add(v0, tangent);
    }

    public int addCoreSubMorphTarget(CalCoreSubMorphTarget subMorphTarget) {
        if (this.coreSubMorphTargets == null) {
            this.coreSubMorphTargets = new Vector();
        }
        int subMorphTargetId = this.coreSubMorphTargets.size();
        this.coreSubMorphTargets.add(subMorphTarget);
        return subMorphTargetId;
    }

    public CalCoreSubMorphTarget getCoreSubMorphTarget(int id) {
        return this.coreSubMorphTargets.get(id);
    }

    public Vector<CalCoreSubMorphTarget> getCoreSubMorphTargets() {
        return this.coreSubMorphTargets;
    }

    public int getCoreSubMorphTargetCount() {
        return this.coreSubMorphTargets == null ? 0 : this.coreSubMorphTargets.size();
    }

    public void scale(float factor) {
        this.vertexPositions.scale(factor, factor, factor);
        if (this.vectorSpring != null && (double)Math.abs(factor - 1.0f) > 0.1) {
            this.vectorSpring = null;
            this.vectorPhysicalProperty = null;
        }
    }

    public static class Face {
        public int[] vertexId = new int[3];
    }

    static class PhysicalProperty {
        public float weight;

        PhysicalProperty() {
        }
    }

    static class Spring {
        int vertexId0;
        int vertexId1;
        float springCoefficient;
        float idleLength;

        Spring() {
        }
    }

    static class VertexInfo {
        public int[] influenceBoneIds;
        public float[] influenceWeights;
        public int collapseId;
        public int faceCollapseCount;

        VertexInfo() {
        }
    }
}

