/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.core;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jagatoo.loaders.models.cal3d.core.CalCoreKeyframe;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalCoreTrack {
    protected int coreBoneId;
    protected SortedSet<CalCoreKeyframe> coreKeyframes = new TreeSet<Object>(new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Float) {
                if (o2 instanceof Float) {
                    return Float.compare(((Float)o1).floatValue(), ((Float)o2).floatValue());
                }
                return Float.compare(((Float)o1).floatValue(), ((CalCoreKeyframe)o2).time);
            }
            if (o2 instanceof Float) {
                return Float.compare(((CalCoreKeyframe)o1).time, ((Float)o2).floatValue());
            }
            return Float.compare(((CalCoreKeyframe)o1).time, ((CalCoreKeyframe)o2).time);
        }

        public boolean equals(Object o1, Object o2) {
            return this.compare(o1, o2) == 0;
        }
    });

    public CalCoreTrack() {
        this.coreBoneId = -1;
    }

    public CalCoreTrack(int coreBoneId) {
        this.coreBoneId = coreBoneId;
    }

    public void addCoreKeyframe(CalCoreKeyframe coreKeyframe) {
        this.coreKeyframes.add(coreKeyframe);
    }

    public int getCoreBoneId() {
        return this.coreBoneId;
    }

    public SortedSet<CalCoreKeyframe> getCoreKeyFrames() {
        return this.coreKeyframes;
    }

    public void getState(float time, Vector3f translation, Quaternion4f rotation) {
        SortedSet<CalCoreKeyframe> setCoreKeyframeBefore = this.coreKeyframes.headSet((CalCoreKeyframe)((Object)new Float(time)));
        SortedSet<CalCoreKeyframe> setCoreKeyframeAfter = this.coreKeyframes.tailSet((CalCoreKeyframe)((Object)new Float(time)));
        if (setCoreKeyframeAfter.isEmpty() && !setCoreKeyframeBefore.isEmpty()) {
            CalCoreKeyframe coreKeyframeBefore = setCoreKeyframeBefore.last();
            rotation.set((TupleNf)coreKeyframeBefore.getRotation());
            translation.set((TupleNf)coreKeyframeBefore.getTranslation());
            return;
        }
        if (setCoreKeyframeBefore.isEmpty() && !setCoreKeyframeAfter.isEmpty()) {
            CalCoreKeyframe coreKeyframeAfter = setCoreKeyframeAfter.first();
            rotation.set((TupleNf)coreKeyframeAfter.getRotation());
            translation.set((TupleNf)coreKeyframeAfter.getTranslation());
            return;
        }
        try {
            CalCoreKeyframe coreKeyframeBefore = setCoreKeyframeBefore.last();
            CalCoreKeyframe coreKeyframeAfter = setCoreKeyframeAfter.first();
            float blendFactor = (time - coreKeyframeBefore.getTime()) / (coreKeyframeAfter.getTime() - coreKeyframeBefore.getTime());
            translation.set((TupleNf)coreKeyframeBefore.getTranslation());
            translation.interpolate(coreKeyframeAfter.getTranslation(), blendFactor);
            rotation.set((TupleNf)coreKeyframeBefore.getRotation());
            rotation.interpolate(coreKeyframeAfter.getRotation(), blendFactor);
        }
        catch (NoSuchElementException e) {
            System.out.println("empty cal core track");
        }
    }

    public void setCoreBoneId(int coreBoneId) {
        if (coreBoneId < 0) {
            throw new IllegalArgumentException();
        }
        this.coreBoneId = coreBoneId;
    }

    public void scale(float factor) {
        for (CalCoreKeyframe keyFrame : this.coreKeyframes) {
            keyFrame.getTranslation().scale(factor);
        }
    }
}

