/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.cal3d.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMesh;
import org.jagatoo.loaders.models.cal3d.core.CalCoreModel;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSkeleton;
import org.jagatoo.loaders.models.cal3d.core.CalLoader;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.loader.KCal3dDefinition;
import org.jagatoo.logging.JAGTLog;

public class KCal3dLoader {
    private static Map<String, CalCoreModel> coreModelCache = new HashMap<String, CalCoreModel>();
    private static Map<String, CalCoreMaterial> coreMaterialCache = new HashMap<String, CalCoreMaterial>();

    public static KCal3dDefinition.Cal3dModelDef loadCfg(InputStream in, URL baseURL) {
        KCal3dDefinition.Cal3dModelDef data = new KCal3dDefinition.Cal3dModelDef();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            data.baseURL = baseURL;
            JAGTLog.debug("Path = " + data.baseURL);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.equals("")) continue;
                if (line.startsWith("data.path=")) {
                    String path = line.substring(line.lastIndexOf("=") + 1);
                    data.baseURL = new URL(data.baseURL, path);
                    JAGTLog.debug("[KCal3dLoader] data.path = " + data.baseURL);
                    continue;
                }
                if (line.startsWith("skeleton=")) {
                    String skeFile = line.substring(line.lastIndexOf("=") + 1);
                    data.skeleton = new URL(data.baseURL, skeFile);
                    JAGTLog.debug("[KCal3dLoader] Set skeleton to " + data.skeleton);
                    continue;
                }
                if (line.startsWith("animation=")) {
                    String animFile = line.substring(line.lastIndexOf("=") + 1);
                    URL animURL = new URL(data.baseURL, animFile);
                    String name = animFile.substring(0, animFile.lastIndexOf("."));
                    name = name.replace('\\', '/');
                    name = name.substring(name.lastIndexOf("/") + 1);
                    KCal3dDefinition.Cal3dAnimDef anim = new KCal3dDefinition.Cal3dAnimDef(name, animURL);
                    data.animations.add(anim);
                    JAGTLog.debug("[KCal3dLoader] Added anim " + animURL);
                    continue;
                }
                if (line.startsWith("mesh=")) {
                    String meshFile = line.substring(line.lastIndexOf("=") + 1);
                    URL meshURL = new URL(data.baseURL, meshFile);
                    KCal3dDefinition.Cal3dSubMeshDef subMesh = new KCal3dDefinition.Cal3dSubMeshDef(meshURL);
                    data.meshes.add(subMesh);
                    JAGTLog.debug("[KCal3dLoader] Added mesh " + meshURL);
                    continue;
                }
                if (line.startsWith("material=")) {
                    String matFile = line.substring(line.lastIndexOf("=") + 1);
                    data.material = new URL(data.baseURL, matFile);
                    JAGTLog.debug("[KCal3dLoader] Set material to " + data.material);
                    continue;
                }
                JAGTLog.debug("[KCal3dLoader] Unsupported line : " + line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static CalModel getCalModel(KCal3dDefinition.Cal3dModelDef modelDef, String name, URL baseURL) {
        try {
            CalCoreModel core = null;
            if (name != null && coreModelCache.containsKey(name)) {
                core = coreModelCache.get(name);
            } else {
                core = KCal3dLoader.loadCoreModel(modelDef, modelDef.skeleton, name);
                if (name != null) {
                    coreModelCache.put(name, core);
                }
            }
            CalModel model = new CalModel(core);
            for (String s : core.getCoreMeshIds()) {
                model.attachMesh(s);
            }
            model.setLodLevel(1.0f);
            Vector<CalCoreMaterial> materials = new Vector<CalCoreMaterial>();
            CalCoreMaterial mat = null;
            if (modelDef.material != null && coreMaterialCache.containsKey(modelDef.material.toExternalForm())) {
                mat = coreMaterialCache.get(modelDef.material.toExternalForm());
            } else {
                mat = CalLoader.loadCoreMaterial(modelDef.material);
                if (modelDef.material != null) {
                    coreMaterialCache.put(modelDef.material.toExternalForm(), mat);
                }
            }
            mat.setBaseURL(modelDef.baseURL);
            materials.add(mat);
            model.setMaterialSet(materials);
            model.update(0.0f);
            return model;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static CalCoreModel loadCoreModel(KCal3dDefinition.Cal3dModelDef modelDef, URL modelResource, String name) {
        try {
            CalCoreSkeleton skeleton = CalLoader.loadCoreSkeleton(modelResource);
            CalCoreModel coreModel = new CalCoreModel(name, skeleton);
            if (modelDef.mesh != null && !modelDef.mesh.toExternalForm().equals("")) {
                CalCoreMesh coreMesh = CalLoader.loadCoreMesh(modelDef.mesh);
                coreMesh.skin = modelDef.skin;
                if (modelDef.material != null && !modelDef.material.toExternalForm().equals("")) {
                    CalCoreMaterial calmat = CalLoader.loadCoreMaterial(modelDef.material);
                    coreMesh.material = modelDef.material;
                    coreModel.addCoreMaterial(modelDef.material.toExternalForm(), calmat);
                }
                coreModel.addCoreMesh(modelDef.mesh.toExternalForm(), coreMesh);
            }
            for (KCal3dDefinition.Cal3dSubMeshDef subMesh : modelDef.meshes) {
                CalCoreMesh coreMesh = CalLoader.loadCoreMesh(subMesh.mesh);
                coreMesh.skin = subMesh.skin;
                if (subMesh.material != null && !subMesh.material.equals("")) {
                    CalCoreMaterial calmat = CalLoader.loadCoreMaterial(modelDef.material);
                    calmat.setBaseURL(modelDef.baseURL);
                    coreMesh.material = modelDef.material;
                    coreModel.addCoreMaterial(modelDef.material.toExternalForm(), calmat);
                }
                coreModel.addCoreMesh(subMesh.mesh.toExternalForm(), coreMesh);
            }
            for (KCal3dDefinition.Cal3dAnimDef anim : modelDef.animations) {
                CalCoreAnimation coreAnimation = CalLoader.loadCoreAnimation(anim.anim, anim.name);
                coreModel.addCoreAnimation(anim.name, coreAnimation);
            }
            return coreModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

