/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jagatoo.loaders.models.collada.datastructs.AssetFolder;
import org.jagatoo.loaders.models.collada.datastructs.controllers.Controller;
import org.jagatoo.loaders.models.collada.datastructs.controllers.SkeletalController;

public class ColladaProtoypeModel {
    private AssetFolder colladaFile;
    private final HashMap<String, SkeletalController> skelControllers = new HashMap();

    public void initAnimation(String animationName, boolean loop) {
        Iterator<SkeletalController> iterator = this.skelControllers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().play(animationName, loop);
        }
    }

    public void animate(long time) {
        for (SkeletalController curr : this.skelControllers.values()) {
            this.colladaFile.getLibraryGeometries().getGeometries().put(curr.getSourceMeshId(), curr.updateDestinationGeometry(time));
        }
    }

    public ColladaProtoypeModel(AssetFolder colladaFile) {
        this.colladaFile = colladaFile;
        for (Map.Entry<String, Controller> entry : colladaFile.getLibraryControllers().getControllers().entrySet()) {
            if (!(entry.getValue() instanceof SkeletalController)) continue;
            this.skelControllers.put(entry.getKey(), (SkeletalController)entry.getValue());
        }
    }
}

