/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.datastructs.animation;

import java.util.List;
import org.jagatoo.loaders.models.collada.Rotations;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameQuat4f;
import org.jagatoo.loaders.models.collada.datastructs.animation.KeyFrameTuple3f;
import org.openmali.FastMath;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyFrame {
    public long time;

    public static KeyFrame buildPoint3fKeyFrame(float time, float[] values, int valueIndex) {
        KeyFrameTuple3f frame = new KeyFrameTuple3f();
        frame.time = (long)(time * 1000.0f);
        frame.setValue(new Tuple3f(values[valueIndex], values[valueIndex + 1], values[valueIndex + 2]));
        return frame;
    }

    public static KeyFrame buildQuaternion4fKeyFrame(float time, float angle, Axis axis) {
        KeyFrameQuat4f frame = new KeyFrameQuat4f();
        frame.time = (long)(time * 1000.0f);
        float radians = FastMath.toRad(angle);
        Tuple3f euler = new Tuple3f(0.0f, 0.0f, 0.0f);
        switch (axis) {
            case X: {
                euler.set(radians, 0.0f, 0.0f);
                break;
            }
            case Y: {
                euler.set(0.0f, radians, 0.0f);
                break;
            }
            case Z: {
                euler.set(0.0f, 0.0f, radians);
            }
        }
        frame.setValue(Rotations.toQuaternion(euler));
        return frame;
    }

    public static int searchNextFrame(List<? extends KeyFrame> frames, long currentTime) {
        int frame = 0;
        while (frame < frames.size() && frames.get((int)frame).time < currentTime) {
            ++frame;
        }
        return frame;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X,
        Y,
        Z;

    }
}

