/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFUtils;
import org.jagatoo.loaders.models.collada.stax.XMLParam;
import org.jagatoo.logging.JAGTLog;

public class XMLAccessor {
    public int count = -1;
    public String source = null;
    public int stride = 1;
    public ArrayList<XMLParam> params = new ArrayList();

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.source == null) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing source.");
        }
        if (this.count == -1) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing count.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("source")) {
                this.source = XMLIDREFUtils.parse(parser.getAttributeValue(i));
            } else if (attr.getLocalPart().equals("count")) {
                this.count = Integer.parseInt(parser.getAttributeValue(i).trim());
            } else if (attr.getLocalPart().equals("stride")) {
                this.stride = Integer.parseInt(parser.getAttributeValue(i).trim());
            } else {
                Location loc = parser.getLocation();
                JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", "Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals("param")) {
                        XMLParam param = new XMLParam();
                        param.parse(parser);
                        break;
                    }
                    Location loc = parser.getLocation();
                    JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", "Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("accessor")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

