/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLEffect;
import org.jagatoo.logging.JAGTLog;

public class XMLLibraryEffects {
    public ArrayList<XMLEffect> effects = new ArrayList();

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.effects.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing effects.");
        }
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("effect")) {
                        XMLEffect effect = new XMLEffect();
                        effect.parse(parser);
                        this.effects.add(effect);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 10: {
                    JAGTLog.exception(this.getClass().getSimpleName(), ": No Attribute tag support.");
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("library_effects")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

