/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLVisualScene;
import org.jagatoo.logging.JAGTLog;

public class XMLLibraryVisualScenes {
    private ArrayList<XMLVisualScene> scenesList = new ArrayList();
    public HashMap<String, XMLVisualScene> scenes = null;

    public void readVisualScenes() {
        this.scenes = new HashMap();
        for (XMLVisualScene scene : this.scenesList) {
            this.scenes.put(scene.id, scene);
        }
        this.scenesList = null;
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.scenesList.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing geometry.");
        }
        this.readVisualScenes();
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("visual_scene")) {
                        XMLVisualScene scene = new XMLVisualScene();
                        scene.parse(parser);
                        this.scenesList.add(scene);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("library_visual_scenes")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

