/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLAsset;
import org.jagatoo.loaders.models.collada.stax.XMLNode;
import org.jagatoo.logging.JAGTLog;

public class XMLVisualScene {
    public String id = null;
    public String name = null;
    public XMLAsset asset = null;
    private ArrayList<XMLNode> nodesList = new ArrayList();
    public HashMap<String, XMLNode> nodes = null;

    public void readNodes() {
        this.nodes = new HashMap();
        for (XMLNode node2 : this.nodesList) {
            this.nodes.put(node2.id, node2);
            if (node2.type != null) continue;
            node2.type = XMLNode.Type.NODE;
        }
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        this.doParsing(parser);
        Location loc = parser.getLocation();
        if (this.nodesList.isEmpty()) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing nodes.");
        }
        this.readNodes();
    }

    private void doParsing(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("asset")) {
                        this.asset = new XMLAsset();
                        this.asset.parse(parser);
                        break;
                    }
                    if (localName.equals("node")) {
                        XMLNode n = new XMLNode();
                        n.parse(parser);
                        this.nodesList.add(n);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("visual_scene")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }
}

