/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md2;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.md2.MD2Header;
import org.jagatoo.loaders.models.md2.MD2Normals;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.logging.JAGTLog;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.spatial.bounds.BoundsType;

public class MD2File {
    private final LittleEndianDataInputStream in;
    private final MD2Header header;
    private final HashMap<String, NamedObject> skinsCache = new HashMap();

    static final String fixPath(String path) {
        if (path.indexOf(92) >= 0) {
            path = path.replace('\\', '/');
        }
        if (path.indexOf(32) >= 0) {
            path = path.replace(" ", "%20");
        }
        return path;
    }

    private AbstractTexture loadTexture(String texName, URL baseURL, AppearanceFactory appFactory) {
        String texBaseName;
        AbstractTexture texture = appFactory.loadOrGetTexture(texName, baseURL, true, true, true, true, true);
        if (!appFactory.isFallbackTexture(texture)) {
            return texture;
        }
        int lastSlashPos = texName.lastIndexOf(47);
        if (lastSlashPos >= 0 && !appFactory.isFallbackTexture(texture = appFactory.loadOrGetTexture(texBaseName = texName.substring(lastSlashPos + 1), baseURL, true, true, true, true, true))) {
            return texture;
        }
        JAGTLog.printlnEx("Couldn't find texture resource \"", texName, "\"!");
        return texture;
    }

    private NamedObject createSkin(String skinName, URL baseURL, AppearanceFactory appFactory) throws IncorrectFormatException, ParsingException {
        NamedObject skin = this.skinsCache.get(skinName);
        if (skin == null) {
            AbstractTexture texture = skinName == null || skinName.length() == 0 ? appFactory.getFallbackTexture() : this.loadTexture(skinName, baseURL, appFactory);
            skin = appFactory.createStandardAppearance("", texture, 0);
            this.skinsCache.put(skinName, skin);
        }
        return skin;
    }

    private NamedObject[] readSkins(int skinsOffset, int numSkins, URL baseURL, AppearanceFactory appFactory) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 skins...");
        this.in.skipBytes(skinsOffset - this.in.getPointer());
        NamedObject[] skins = new NamedObject[numSkins];
        int i = 0;
        while (i < numSkins) {
            String skinName = MD2File.fixPath(this.in.readCString(64, true));
            skins[i] = this.createSkin(skinName, baseURL, appFactory);
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return skins;
    }

    private float[] readTextureCoordinates(int textureCoordsOffset, int numTexCoords, int skinWidth, int skinHeight) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 texture-coordinates...");
        this.in.skipBytes(textureCoordsOffset - this.in.getPointer());
        this.in.skipBytes(numTexCoords * 4);
        float[] data = null;
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return data;
    }

    private int[][] readTriangles(int trianglesOffset, int numTriangles) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 triangles...");
        this.in.skipBytes(trianglesOffset - this.in.getPointer());
        this.in.skipBytes(numTriangles * 12);
        int[][] data = null;
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return data;
    }

    private Object[][] readFrames(int framesOffset, int numFrames, int numVertices, boolean convertZup2Yup, float scale) throws IOException, IncorrectFormatException, ParsingException {
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 frames...");
        this.in.skipBytes(framesOffset - this.in.getPointer());
        Object[][] frames = new Object[numFrames][];
        int i = 0;
        while (i < numFrames) {
            float scaleX = this.in.readFloat();
            float scaleY = this.in.readFloat();
            float scaleZ = this.in.readFloat();
            float translateX = this.in.readFloat();
            float translateY = this.in.readFloat();
            float translateZ = this.in.readFloat();
            String name = this.in.readCString(16, true);
            float[] coords = new float[3 * numVertices];
            short[] normalIndices = new short[numVertices];
            int j = 0;
            while (j < numVertices) {
                int x = this.in.readUnsignedByte();
                int y = this.in.readUnsignedByte();
                int z = this.in.readUnsignedByte();
                if (convertZup2Yup) {
                    coords[j * 3 + 0] = (translateX + (float)x * scaleX) * scale;
                    coords[j * 3 + 1] = (translateZ + (float)z * scaleZ) * scale;
                    coords[j * 3 + 2] = -(translateY + (float)y * scaleY) * scale;
                } else {
                    coords[j * 3 + 0] = (translateX + (float)x * scaleX) * scale;
                    coords[j * 3 + 1] = (translateY + (float)y * scaleY) * scale;
                    coords[j * 3 + 2] = (translateZ + (float)z * scaleZ) * scale;
                }
                normalIndices[j] = (short)this.in.readUnsignedByte();
                ++j;
            }
            frames[i] = new Object[]{name, coords, normalIndices};
            ++i;
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
        return frames;
    }

    private static final String getAnimName(String frameName) {
        int i = frameName.length() - 1;
        while (frameName.charAt(i) >= '0' && frameName.charAt(i) <= '9') {
            --i;
        }
        return frameName.substring(0, i + 1);
    }

    private void readGLCommands(int commandsOffset, Object[][] framesData, GeometryFactory geomFactory, boolean convertZup2Yup, AnimationFactory animFactory, AppearanceFactory appFactory, URL baseURL, NodeFactory nodeFactory, NamedObject rootGroup, NamedObject[] skins, String skin, SpecialItemsHandler siHandler) throws IOException, IncorrectFormatException, ParsingException {
        int indicator;
        long t0 = System.currentTimeMillis();
        JAGTLog.debug("Loading MD2 GL-commands...");
        this.in.skipBytes(commandsOffset - this.in.getPointer());
        int numSets = 0;
        int stripCount = 0;
        int stripVertexCount = 0;
        int fanCount = 0;
        int fanVertexCount = 0;
        ArrayList<GeometryFactory.GeometryType> geomTypes = new ArrayList<GeometryFactory.GeometryType>();
        ArrayList<float[]> texCoords = new ArrayList<float[]>();
        ArrayList<int[]> vertexIndices = new ArrayList<int[]>();
        while ((indicator = this.in.readInt()) != 0) {
            int num = Math.abs(indicator);
            if (indicator < 0) {
                geomTypes.add(GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY);
                fanVertexCount += num;
                ++fanCount;
            } else {
                geomTypes.add(GeometryFactory.GeometryType.TRIANGLE_STRIP_ARRAY);
                stripVertexCount += num;
                ++stripCount;
            }
            float[] st = new float[num * 2];
            int[] idxs = new int[num];
            int j = 0;
            while (j < num) {
                st[j * 2 + 0] = this.in.readFloat();
                st[j * 2 + 1] = 1.0f - this.in.readFloat();
                idxs[j] = this.in.readInt();
                ++j;
            }
            texCoords.add(st);
            vertexIndices.add(idxs);
            ++numSets;
        }
        int[] fanCounts = new int[fanCount];
        int fanIndex = 0;
        int[] stripCounts = new int[stripCount];
        int stripIndex = 0;
        int i = 0;
        while (i < numSets) {
            GeometryFactory.GeometryType geomType = (GeometryFactory.GeometryType)((Object)geomTypes.get(i));
            int numVertices_ = ((int[])vertexIndices.get(i)).length;
            if (geomType == GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY) {
                fanCounts[fanIndex++] = numVertices_;
            } else {
                stripCounts[stripIndex++] = numVertices_;
            }
            ++i;
        }
        NamedObject fanArray = geomFactory.createGeometry("MD2-TriangleFanArray", GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY, 3, fanVertexCount, 0, fanCounts);
        NamedObject stripArray = geomFactory.createGeometry("MD2-TriangleStripArray", GeometryFactory.GeometryType.TRIANGLE_STRIP_ARRAY, 3, stripVertexCount, 0, stripCounts);
        NamedObject fanShape = null;
        NamedObject stripShape = null;
        ArrayList<Object[]> frames = new ArrayList<Object[]>();
        String lastAnimName = null;
        int f = 0;
        while (f < framesData.length) {
            String name = (String)framesData[f][0];
            float[] coords = (float[])framesData[f][1];
            short[] normalIndices = (short[])framesData[f][2];
            String animName = MD2File.getAnimName(name);
            if (lastAnimName != null && !lastAnimName.equals(animName)) {
                Object[] fanFrames = (Object[])Array.newInstance(((Object[])frames.get(0))[0].getClass(), frames.size());
                Object[] stripFrames = (Object[])Array.newInstance(((Object[])frames.get(0))[1].getClass(), frames.size());
                int i2 = 0;
                while (i2 < frames.size()) {
                    Object[] o = (Object[])frames.get(i2);
                    fanFrames[i2] = o[0];
                    stripFrames[i2] = o[1];
                    ++i2;
                }
                Object fanAnimController = animFactory.createMeshDeformationKeyFrameController(fanFrames, fanShape);
                Object stripAnimController = animFactory.createMeshDeformationKeyFrameController(stripFrames, stripShape);
                Object[] animControllers = (Object[])Array.newInstance(fanAnimController.getClass(), 2);
                animControllers[0] = fanAnimController;
                animControllers[1] = stripAnimController;
                Object animation = animFactory.createAnimation(lastAnimName, frames.size(), 9.0f, animControllers, null);
                siHandler.addAnimation(animation);
                frames.clear();
            }
            lastAnimName = animName;
            float[] frameFanCoords = new float[fanVertexCount * 3];
            float[] frameStripCoords = new float[stripVertexCount * 3];
            float[] frameFanNormals = new float[fanVertexCount * 3];
            float[] frameStripNormals = new float[stripVertexCount * 3];
            stripIndex = 0;
            fanIndex = 0;
            int i3 = 0;
            while (i3 < numSets) {
                short normalIndex;
                int vertexIndex;
                int j;
                GeometryFactory.GeometryType geomType = (GeometryFactory.GeometryType)((Object)geomTypes.get(i3));
                float[] st = (float[])texCoords.get(i3);
                int[] vertexIndices_ = (int[])vertexIndices.get(i3);
                int numVertices = vertexIndices_.length;
                if (geomType == GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY) {
                    j = 0;
                    while (j < numVertices) {
                        vertexIndex = vertexIndices_[j];
                        normalIndex = normalIndices[j];
                        if (f == 0) {
                            geomFactory.setTexCoords(fanArray, geomType, 0, 2, fanIndex, st, j * 2, 1);
                        }
                        System.arraycopy(coords, vertexIndex * 3, frameFanCoords, fanIndex * 3, 3);
                        if (convertZup2Yup) {
                            System.arraycopy(MD2Normals.dataYup, normalIndex * 3, frameFanNormals, fanIndex * 3, 3);
                        } else {
                            System.arraycopy(MD2Normals.dataZup, normalIndex * 3, frameFanNormals, fanIndex * 3, 3);
                        }
                        ++fanIndex;
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < numVertices) {
                        vertexIndex = vertexIndices_[j];
                        normalIndex = normalIndices[j];
                        if (f == 0) {
                            geomFactory.setTexCoords(stripArray, geomType, 0, 2, stripIndex, st, j * 2, 1);
                        }
                        System.arraycopy(coords, vertexIndex * 3, frameStripCoords, stripIndex * 3, 3);
                        if (convertZup2Yup) {
                            System.arraycopy(MD2Normals.dataYup, normalIndex * 3, frameStripNormals, stripIndex * 3, 3);
                        } else {
                            System.arraycopy(MD2Normals.dataZup, normalIndex * 3, frameStripNormals, stripIndex * 3, 3);
                        }
                        ++stripIndex;
                        ++j;
                    }
                }
                ++i3;
            }
            if (f == 0) {
                geomFactory.setCoordinates(fanArray, GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY, 0, frameFanCoords, 0, fanIndex);
                geomFactory.setNormals(fanArray, GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY, 0, frameFanNormals, 0, fanIndex);
                geomFactory.setCoordinates(stripArray, GeometryFactory.GeometryType.TRIANGLE_STRIP_ARRAY, 0, frameStripCoords, 0, stripIndex);
                geomFactory.setNormals(stripArray, GeometryFactory.GeometryType.TRIANGLE_STRIP_ARRAY, 0, frameStripNormals, 0, stripIndex);
                geomFactory.finalizeGeometry(fanArray, GeometryFactory.GeometryType.TRIANGLE_FAN_ARRAY, 0, fanVertexCount, 0, 0);
                geomFactory.finalizeGeometry(stripArray, GeometryFactory.GeometryType.TRIANGLE_STRIP_ARRAY, 0, stripVertexCount, 0, 0);
                NamedObject appearance = skin != null || skins == null || skins.length == 0 ? this.createSkin(skin, baseURL, appFactory) : skins[0];
                fanShape = nodeFactory.createShape("MD2-TriangleFanArray", fanArray, appearance, BoundsType.SPHERE);
                nodeFactory.addNodeToGroup(fanShape, rootGroup);
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, fanShape.getName(), fanShape);
                stripShape = nodeFactory.createShape("MD2-TriangleStripArray", stripArray, appearance, BoundsType.SPHERE);
                nodeFactory.addNodeToGroup(stripShape, rootGroup);
                siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, stripShape.getName(), stripShape);
            }
            Object fanFrame = animFactory.createMeshDeformationKeyFrame(frameFanCoords, frameFanNormals);
            Object stripFrame = animFactory.createMeshDeformationKeyFrame(frameStripCoords, frameStripNormals);
            frames.add(new Object[]{fanFrame, stripFrame});
            ++f;
        }
        if (framesData.length > 1 && lastAnimName != null && frames.size() > 0) {
            Object[] fanFrames = (Object[])Array.newInstance(((Object[])frames.get(0))[0].getClass(), frames.size());
            Object[] stripFrames = (Object[])Array.newInstance(((Object[])frames.get(0))[1].getClass(), frames.size());
            int i4 = 0;
            while (i4 < frames.size()) {
                Object[] o = (Object[])frames.get(i4);
                fanFrames[i4] = o[0];
                stripFrames[i4] = o[1];
                ++i4;
            }
            Object fanAnimController = animFactory.createMeshDeformationKeyFrameController(fanFrames, fanShape);
            Object stripAnimController = animFactory.createMeshDeformationKeyFrameController(stripFrames, stripShape);
            Object[] animControllers = (Object[])Array.newInstance(fanAnimController.getClass(), 2);
            animControllers[0] = fanAnimController;
            animControllers[1] = stripAnimController;
            Object animation = animFactory.createAnimation(lastAnimName, frames.size(), 9.0f, animControllers, null);
            siHandler.addAnimation(animation);
            frames.clear();
        }
        JAGTLog.debug("done. (", Float.valueOf((float)(System.currentTimeMillis() - t0) / 1000.0f), " seconds)");
    }

    private MD2File(InputStream in, URL baseURL, AppearanceFactory appFactory, String skin, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        this.in = new LittleEndianDataInputStream(in);
        try {
            this.header = MD2Header.readHeader(this.in);
            NamedObject[] skins = this.readSkins(this.header.offsetSkins, this.header.numSkins, baseURL, appFactory);
            this.readTextureCoordinates(this.header.offsetTexCoords, this.header.numTexCoords, this.header.skinWidth, this.header.skinHeight);
            this.readTriangles(this.header.offsetTriangles, this.header.numTriangles);
            Object[][] frames = this.readFrames(this.header.offsetFrames, this.header.numFrames, this.header.numVertices, convertZup2Yup, scale);
            this.readGLCommands(this.header.offsetGlCommands, frames, geomFactory, convertZup2Yup, animFactory, appFactory, baseURL, nodeFactory, rootGroup, skins, skin, siHandler);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static final void load(InputStream in, URL baseURL, AppearanceFactory appFactory, String skin, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        new MD2File(in, baseURL, appFactory, skin, geomFactory, convertZup2Yup, scale, nodeFactory, animFactory, siHandler, rootGroup);
    }
}

