/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md3;

import java.io.IOException;
import org.jagatoo.loaders.models.md3.MD3File;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.streams.LittleEndianDataInputStream;

public class MD3Header {
    public static final int MAGIC_NUMBER = 860898377;
    public final int version;
    public final String name;
    public final int flags;
    public final int numFrames;
    public final int numTags;
    public final int numSurfaces;
    public final int numSkins;
    public final int frameOffset;
    public final int tagOffset;
    public final int surfaceOffset;
    public final int fileOffset;

    private MD3Header(LittleEndianDataInputStream in) throws IOException, IncorrectFormatException {
        int ident = in.readInt();
        if (ident != 860898377) {
            throw new IncorrectFormatException("This is not an MD3 file!");
        }
        this.version = in.readInt();
        if (this.version != 15) {
            throw new IncorrectFormatException("Unsupported MD3 version " + this.version + ". Currently ony version 15 is supported.");
        }
        this.name = MD3File.fixPath(in.readCString(64, true));
        this.flags = in.readInt();
        this.numFrames = in.readInt();
        this.numTags = in.readInt();
        this.numSurfaces = in.readInt();
        this.numSkins = in.readInt();
        this.frameOffset = in.readInt();
        this.tagOffset = in.readInt();
        this.surfaceOffset = in.readInt();
        this.fileOffset = in.readInt();
    }

    public static final MD3Header readHeader(LittleEndianDataInputStream in) throws IOException, IncorrectFormatException {
        return new MD3Header(in);
    }
}

