/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.jagatoo.util.strings.SimpleStringTokenizer;
import org.jagatoo.util.strings.StringUtils;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.FloatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MD5MeshReader {
    private static final GeometryFactory.GeometryType GEOM_TYPE = GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY;
    private final HashMap<String, NamedObject> shaderCache = new HashMap();
    private MD5Bone[] skeleton;
    private MD5Mesh[] meshes;

    private MD5Bone parseBone(SimpleStringTokenizer st, boolean convertZup2Yup) {
        String boneName = StringUtils.unquoteString(st.getLastToken());
        st.skipToken();
        st.skipToken();
        Vector3f translation = new Vector3f();
        translation.setX(Float.parseFloat(st.nextToken()));
        translation.setY(Float.parseFloat(st.nextToken()));
        translation.setZ(Float.parseFloat(st.nextToken()));
        st.skipToken();
        st.skipToken();
        float q1 = Float.parseFloat(st.nextToken());
        float q2 = Float.parseFloat(st.nextToken());
        float q3 = Float.parseFloat(st.nextToken());
        Quaternion4f rotation = new Quaternion4f(q1, q2, q3, 0.0f).computeD();
        return new MD5Bone(boneName, translation, rotation);
    }

    private NamedObject createShader(String shaderName, AppearanceFactory appFactory, URL baseURL) {
        NamedObject shader = this.shaderCache.get(shaderName = shaderName.startsWith(":\\", 1) ? "file://" + shaderName.replace('\\', '/') : shaderName.replace('\\', '/'));
        if (shader != null) {
            return shader;
        }
        shader = appFactory.createStandardAppearance(shaderName, shaderName, baseURL, 0);
        this.shaderCache.put(shaderName, shader);
        return shader;
    }

    private MD5Mesh compileMesh(String meshName, NamedObject shader, ArrayList<String> vertDefs, ArrayList<String> triDefs, ArrayList<String> weightDefs, GeometryFactory geomFactory, float scale, AnimationFactory animFactory) {
        MD5Mesh result = new MD5Mesh();
        result.name = meshName;
        result.shader = shader;
        result.numVertices = vertDefs.size();
        result.numTriangles = triDefs.size();
        result.geom = geomFactory.createGeometry(meshName, GEOM_TYPE, 3, vertDefs.size(), triDefs.size() * 3, null);
        result.boneWeightBones = new int[weightDefs.size()];
        result.boneWeightWeights = new float[weightDefs.size()];
        result.boneWeightOffsets = new Vector3f[weightDefs.size()];
        SimpleStringTokenizer st = new SimpleStringTokenizer("");
        int i = 0;
        while (i < weightDefs.size()) {
            st.setString(weightDefs.get(i));
            st.skipToken();
            int bone = Integer.parseInt(st.nextToken());
            float weight = Float.parseFloat(st.nextToken());
            st.skipToken();
            Vector3f offset = new Vector3f();
            offset.setX(Float.parseFloat(st.nextToken()));
            offset.setY(Float.parseFloat(st.nextToken()));
            offset.setZ(Float.parseFloat(st.nextToken()));
            result.boneWeightBones[i] = bone;
            result.boneWeightWeights[i] = weight * scale;
            result.boneWeightOffsets[i] = offset;
            ++i;
        }
        result.firstWeights = new int[vertDefs.size()];
        result.weightCounts = new int[vertDefs.size()];
        Object[][] boneWeights = null;
        int i2 = 0;
        while (i2 < vertDefs.size()) {
            st.setString(vertDefs.get(i2));
            st.skipToken();
            st.skipToken();
            float s = Float.parseFloat(st.nextToken());
            float t = 1.0f - Float.parseFloat(st.nextToken());
            geomFactory.setTexCoord(result.geom, GEOM_TYPE, 0, i2, s, t);
            st.skipToken();
            int firstWeight = Integer.parseInt(st.nextToken());
            int weightCount = Integer.parseInt(st.nextToken());
            result.firstWeights[i2] = firstWeight;
            result.weightCounts[i2] = weightCount;
            if (boneWeights != null) {
                boneWeights[i2] = null;
            }
            int w = 0;
            while (w < weightCount) {
                Object bw = animFactory.createBoneWeight(result.boneWeightBones[firstWeight + w], result.boneWeightWeights[firstWeight + w], result.boneWeightOffsets[firstWeight + w]);
                if (boneWeights == null) {
                    Object[] bws = (Object[])Array.newInstance(bw.getClass(), weightCount);
                    boneWeights = (Object[][])Array.newInstance(bws.getClass(), result.numVertices);
                    boneWeights[i2] = bws;
                } else if (boneWeights[i2] == null) {
                    boneWeights[i2] = (Object[])Array.newInstance(bw.getClass(), weightCount);
                }
                boneWeights[i2][w] = bw;
                ++w;
            }
            ++i2;
        }
        result.boneWeights = boneWeights;
        int[] triangles = new int[result.numTriangles * 3];
        int i3 = 0;
        while (i3 < triDefs.size()) {
            st.setString(triDefs.get(i3));
            st.skipToken();
            triangles[i3 * 3 + 0] = Integer.parseInt(st.nextToken());
            triangles[i3 * 3 + 1] = Integer.parseInt(st.nextToken());
            triangles[i3 * 3 + 2] = Integer.parseInt(st.nextToken());
            ++i3;
        }
        result.triangles = triangles;
        geomFactory.setIndex(result.geom, GEOM_TYPE, 0, triangles, 0, triangles.length);
        return result;
    }

    private void readMeshFile(InputStream in, URL baseURL, String skin, AppearanceFactory appFactory, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, AnimationFactory animFactory) throws IOException {
        String line;
        int numJoints = 0;
        int numMeshes = 0;
        MD5Bone[] skeleton = null;
        ArrayList<MD5Mesh> meshes = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        SimpleStringTokenizer st = new SimpleStringTokenizer("");
        String token = null;
        while ((line = br.readLine()) != null) {
            st.setString(line);
            token = st.nextToken();
            if (token == null) continue;
            if (token.equals("MD5Version")) {
                int version = Integer.parseInt(st.nextToken());
                if (version == 10) continue;
                br.close();
                throw new IncorrectFormatException("MD5 version " + version + " is not supported. Expected 10.");
            }
            if (token.equals("numJoints")) {
                numJoints = Integer.parseInt(st.nextToken());
                continue;
            }
            if (token.equals("numMeshes")) {
                numMeshes = Integer.parseInt(st.nextToken());
                meshes = new ArrayList<MD5Mesh>(numMeshes);
                continue;
            }
            if (token.equals("joints")) {
                ArrayList<MD5Bone> bones = new ArrayList<MD5Bone>(numJoints);
                while ((line = br.readLine()) != null) {
                    st.setString(line);
                    token = st.nextToken();
                    if (token == null) continue;
                    if (token.equals("}")) break;
                    bones.add(this.parseBone(st, convertZup2Yup));
                }
                skeleton = bones.toArray(new MD5Bone[bones.size()]);
                continue;
            }
            if (!token.equals("mesh")) continue;
            String meshName = "";
            NamedObject shader = null;
            int numVertices = 0;
            int numTriangles = 0;
            int numWeights = 0;
            ArrayList<String> vertDefs = null;
            ArrayList<String> triDefs = null;
            ArrayList<String> weightDefs = null;
            meshName = st.nextToken();
            if (meshName.equals("{")) {
                meshName = "";
            }
            while ((line = br.readLine()) != null) {
                st.setString(line);
                token = st.nextToken();
                if (token == null) continue;
                if (token.equals("numverts")) {
                    numVertices = Integer.parseInt(st.getRest());
                    vertDefs = new ArrayList<String>(numVertices);
                    continue;
                }
                if (token.equals("vert")) {
                    vertDefs.add(st.getRest());
                    continue;
                }
                if (token.equals("numtris")) {
                    numTriangles = Integer.parseInt(st.getRest());
                    triDefs = new ArrayList<String>(numTriangles);
                    continue;
                }
                if (token.equals("tri")) {
                    triDefs.add(st.getRest());
                    continue;
                }
                if (token.equals("numweights")) {
                    numWeights = Integer.parseInt(st.getRest());
                    weightDefs = new ArrayList<String>(numWeights);
                    continue;
                }
                if (token.equals("weight")) {
                    weightDefs.add(st.getRest());
                    continue;
                }
                if (token.equals("shader")) {
                    String shaderName = st.getUnquotedRest();
                    if (skin != null) continue;
                    shader = this.createShader(shaderName, appFactory, baseURL);
                    continue;
                }
                if (token.equals("}")) break;
            }
            meshes.add(this.compileMesh(meshName, shader, vertDefs, triDefs, weightDefs, geomFactory, scale, animFactory));
        }
        br.close();
        this.skeleton = skeleton;
        this.meshes = meshes.toArray(new MD5Mesh[meshes.size()]);
    }

    private static void computeNormals(float[] coords, int[] triangles, NamedObject geom, GeometryFactory geomFactory) {
        Vector3f tmp = new Vector3f();
        int numTriangles = triangles.length / 3;
        int i = 0;
        while (i < numTriangles) {
            int i3 = i * 3;
            float coordAx = coords[triangles[i3 + 0] * 3 + 0];
            float coordAy = coords[triangles[i3 + 0] * 3 + 1];
            float coordAz = coords[triangles[i3 + 0] * 3 + 2];
            float coordBx = coords[triangles[i3 + 1] * 3 + 0];
            float coordBy = coords[triangles[i3 + 1] * 3 + 1];
            float coordBz = coords[triangles[i3 + 1] * 3 + 2];
            float coordCx = coords[triangles[i3 + 2] * 3 + 0];
            float coordCy = coords[triangles[i3 + 2] * 3 + 1];
            float coordCz = coords[triangles[i3 + 2] * 3 + 2];
            float vecACx = coordCx - coordAx;
            float vecACy = coordCy - coordAy;
            float vecACz = coordCz - coordAz;
            float vecABx = coordBx - coordAx;
            float vecABy = coordBy - coordAy;
            float vecABz = coordBz - coordAz;
            FloatUtils.cross(vecACx, vecACy, vecACz, vecABx, vecABy, vecABz, tmp);
            tmp.normalize();
            geomFactory.setNormal(geom, GEOM_TYPE, triangles[i3 + 0], tmp.getX(), tmp.getY(), tmp.getZ());
            geomFactory.setNormal(geom, GEOM_TYPE, triangles[i3 + 1], tmp.getX(), tmp.getY(), tmp.getZ());
            geomFactory.setNormal(geom, GEOM_TYPE, triangles[i3 + 2], tmp.getX(), tmp.getY(), tmp.getZ());
            ++i;
        }
    }

    private static void computeTriMesh(MD5Mesh mesh, MD5Bone[] bones, GeometryFactory geomFactory) {
        float[] coords = new float[mesh.numVertices * 3];
        Point3f tmp = new Point3f();
        int i = 0;
        while (i < mesh.numVertices) {
            coords[i * 3 + 0] = 0.0f;
            coords[i * 3 + 1] = 0.0f;
            coords[i * 3 + 2] = 0.0f;
            int j = 0;
            while (j < mesh.weightCounts[i]) {
                int weightIndex = mesh.firstWeights[i] + j;
                MD5Bone bone = bones[mesh.boneWeightBones[weightIndex]];
                bone.rotation.transform(mesh.boneWeightOffsets[weightIndex], tmp);
                float weight = mesh.boneWeightWeights[weightIndex];
                tmp.add(bone.translation);
                tmp.mul(weight);
                Quaternion4f.Z_UP_TO_Y_UP.transform(tmp);
                int n = i * 3 + 0;
                coords[n] = coords[n] + tmp.getX();
                int n2 = i * 3 + 1;
                coords[n2] = coords[n2] + tmp.getY();
                int n3 = i * 3 + 2;
                coords[n3] = coords[n3] + tmp.getZ();
                ++j;
            }
            ++i;
        }
        geomFactory.setCoordinates(mesh.geom, GEOM_TYPE, 0, coords, 0, mesh.numVertices);
        MD5MeshReader.computeNormals(coords, mesh.triangles, mesh.geom, geomFactory);
        geomFactory.finalizeGeometry(mesh.geom, GEOM_TYPE, 0, mesh.numVertices, 0, mesh.triangles.length);
    }

    public static Object[][][] load(InputStream in, URL baseURL, AppearanceFactory appFactory, String skin, GeometryFactory geomFactory, boolean convertZup2Yup, float scale, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, NamedObject rootGroup) throws IOException, IncorrectFormatException, ParsingException {
        MD5MeshReader reader = new MD5MeshReader();
        reader.readMeshFile(in, baseURL, skin, appFactory, geomFactory, convertZup2Yup, scale, animFactory);
        Object[][][] weights = new Object[reader.meshes.length][][];
        int m = 0;
        while (m < reader.meshes.length) {
            MD5Mesh mesh = reader.meshes[m];
            MD5MeshReader.computeTriMesh(mesh, reader.skeleton, geomFactory);
            NamedObject shader = mesh.shader;
            if (skin != null) {
                shader = reader.createShader(skin, appFactory, baseURL);
            }
            NamedObject shape = nodeFactory.createShape(mesh.geom.getName(), mesh.geom, shader, BoundsType.SPHERE);
            siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, shape.getName(), shape);
            nodeFactory.addNodeToGroup(shape, rootGroup);
            weights[m] = mesh.boneWeights;
            ++m;
        }
        return weights;
    }

    private class MD5Bone {
        public final String name;
        public final Vector3f translation;
        public final Quaternion4f rotation;

        public MD5Bone(String name, Vector3f translation, Quaternion4f rotation) {
            this.name = name;
            this.translation = translation;
            this.rotation = rotation;
        }
    }

    private class MD5Mesh {
        public String name;
        public NamedObject shader;
        public int numVertices;
        public int numTriangles;
        public int[] boneWeightBones = null;
        public float[] boneWeightWeights = null;
        public Vector3f[] boneWeightOffsets = null;
        public int[] firstWeights = null;
        public int[] weightCounts = null;
        public Object[][] boneWeights = null;
        public int[] triangles = null;
        public NamedObject geom = null;

        private MD5Mesh() {
        }
    }
}

