/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ms3d.utils;

import java.io.IOException;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;

public class BinaryUtils {
    public static String readString(LittleEndianDataInputStream in, int length) throws IOException {
        byte[] array = new byte[length];
        in.read(array, 0, length);
        int len = length;
        int i = 0;
        while (i < length) {
            if (array[i] == 0) {
                len = i;
                break;
            }
            ++i;
        }
        if (len == 0) {
            return null;
        }
        return new String(array, 0, len);
    }

    public static int[] readIntArray(LittleEndianDataInputStream in, int length) throws IOException {
        byte[] array = new byte[length];
        in.read(array, 0, length);
        int[] arrayInt = new int[length];
        int i = 0;
        while (i < array.length) {
            arrayInt[i] = array[i];
            ++i;
        }
        return arrayInt;
    }

    public static Point3f readPoint3f(LittleEndianDataInputStream in) throws IOException {
        return new Point3f(in.readFloat(), in.readFloat(), in.readFloat());
    }

    public static Colorf readColorf(LittleEndianDataInputStream in) throws IOException {
        return new Colorf(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }
}

