/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.obj;

import java.util.List;
import org.jagatoo.loaders.models.obj.OBJFaceList;
import org.jagatoo.loaders.models.obj.OBJMaterial;
import org.jagatoo.util.arrays.ArrayVector;
import org.jagatoo.util.geometry.Polygon;

public class OBJFace {
    private OBJFaceList faceList;
    private int[] vData;
    private int[] tData;
    private int[] nData;
    private int i;
    private OBJMaterial mat;
    private Polygon poly = new Polygon();

    public OBJMaterial getMaterial() {
        return this.mat;
    }

    public int getCount() {
        return (this.vData.length - 2) * 3;
    }

    private int findIndex(float[] vt) {
        int i = 0;
        while (i < this.vData.length) {
            if (this.faceList.getVertexList().get(this.vData[i]) == vt) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void configure(float[][] dataVerts, float[][] dataNormals, float[][] dataTexs, int index) {
        float[] v1 = new float[3];
        float[] v2 = new float[3];
        float[] faceNormal = new float[3];
        ArrayVector.sub(this.faceList.getVertexList().get(this.vData[1]), this.faceList.getVertexList().get(this.vData[0]), v1);
        ArrayVector.sub(this.faceList.getVertexList().get(this.vData[2]), this.faceList.getVertexList().get(this.vData[0]), v2);
        ArrayVector.cross(v1, v2, faceNormal);
        ArrayVector.normalize(faceNormal);
        ArrayVector.negate(faceNormal);
        int i = 0;
        while (i < this.vData.length) {
            this.poly.add(this.faceList.getVertexList().get(this.vData[i]));
            ++i;
        }
        List<Polygon> list = this.poly.getAsTriangles();
        int i2 = 0;
        while (i2 < list.size()) {
            Polygon tri = list.get(i2);
            int v = 0;
            while (v < 3) {
                int ptIndex = index + i2 * 3 + v;
                int vIndex = this.findIndex(tri.getVertices().get(v));
                dataVerts[ptIndex] = this.faceList.getVertexList().get(this.vData[vIndex]);
                dataNormals[ptIndex] = this.nData[i2] != -1 && this.faceList.normalsSupported() ? this.faceList.getNormalList().get(this.nData[vIndex]) : faceNormal;
                if (this.tData[i2] != -1 && this.faceList.texturesSupported()) {
                    dataTexs[ptIndex] = this.faceList.getTexList().get(this.tData[vIndex]);
                }
                ++v;
            }
            ++i2;
        }
    }

    protected void add(int v, int n, int t) {
        this.vData[this.i] = v;
        this.nData[this.i] = n;
        this.tData[this.i] = t;
        ++this.i;
    }

    public OBJFace(OBJFaceList faceList, int count, OBJMaterial mat) {
        this.faceList = faceList;
        this.vData = new int[count];
        this.nData = new int[count];
        this.tData = new int[count];
        this.mat = mat;
    }
}

