/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.ChunkProcessor;
import org.jagatoo.loaders.models.tds.internal.Face;
import org.jagatoo.loaders.models.tds.internal.ModelContext;

public class FaceArrayProcessor
extends ChunkProcessor {
    public static final boolean CREATE_INDEXED_GEOMETRY = true;

    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        context.numberOfFaces = file.readUnsignedShort();
        context.faces = new Face[context.numberOfFaces];
        context.geometry = geomFactory.createGeometry("", GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY, 3, context.vertexCoords.length, context.numberOfFaces * 3, null);
        nodeFactory.applyGeometryToShape(context.geometry, context.shape);
        context.totalFaces += context.numberOfFaces;
        int i = 0;
        while (i < context.numberOfFaces) {
            int a = file.readUnsignedShort();
            int b = file.readUnsignedShort();
            int c = file.readUnsignedShort();
            file.readUnsignedShort();
            context.faces[i] = new Face(file, a, b, c);
            ++i;
        }
    }
}

