/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.internal;

import java.lang.reflect.Array;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models.tds.internal.PosTransform;
import org.jagatoo.loaders.models.tds.internal.RotTransform;
import org.jagatoo.loaders.models.tds.internal.ScaleTransform;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;

public class KeyFrameFactory {
    public static Object[] createKeyFrames(Matrix4f masterTransform, int framesCount, PosTransform posTransform, RotTransform rotTransform, ScaleTransform scaleTransform, AnimationFactory animFactory) {
        Object[] frames = null;
        Vector3f translation = new Vector3f();
        Quaternion4f rotation = new Quaternion4f();
        Tuple3f scale = new Tuple3f();
        int i = 0;
        while (i <= framesCount) {
            float frameTime = (float)i / (float)framesCount;
            if (posTransform != null && posTransform.frames.size() > 0) {
                posTransform.getTranslationAtTime(frameTime, translation);
            } else {
                translation.setZero();
            }
            if (rotTransform != null && rotTransform.frames.size() > 0) {
                rotTransform.getRotationAtTime(frameTime, rotation);
            } else {
                rotation.setIdentity();
            }
            if (scaleTransform != null && scaleTransform.frames.size() > 0) {
                scaleTransform.getScaleAtTime(frameTime, scale);
            } else {
                scale.set(1.0f, 1.0f, 1.0f);
            }
            Object frame = animFactory.createMeshTransformKeyFrame(frameTime, translation, rotation, scale);
            if (frames == null) {
                frames = (Object[])Array.newInstance(frame.getClass(), framesCount + 1);
            }
            frames[i] = frame;
            if (masterTransform != null) {
                animFactory.transformMeshTransformKeyFrame(masterTransform, frame);
            }
            ++i;
        }
        return frames;
    }
}

