/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureFormatLoader;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;

public class TextureFormatLoaderDDS
implements TextureFormatLoader {
    private static final int HEADER_FIELD_HEIGHT = 2;
    private static final int HEADER_FIELD_WIDTH = 3;
    private static final int HEADER_FIELD_MIPMAP_COUNT = 6;
    private static final int HEADER_FIELD_PIXEL_FORMAT_FOUR_CC = 20;
    private static final int HEADER_FIELD_PIXEL_FORMAT_RGB_BIT_COUNT = 21;
    private static final int HEADER_FIELD_PIXEL_FORMAT_R_BIT_MASK = 22;
    private static final int HEADER_FIELD_PIXEL_FORMAT_G_BIT_MASK = 23;
    private static final int HEADER_FIELD_PIXEL_FORMAT_B_BIT_MASK = 24;
    private static final int HEADER_FIELD_PIXEL_FORMAT_RGB_ALPHA_BIT_MASK = 25;
    protected byte[] tmpReadBuffer = new byte[64];
    protected static final byte[] tab2 = new byte[4];
    protected static final byte[] tab3 = new byte[8];
    protected static final byte[] tab4 = new byte[16];
    protected static final byte[] tab5 = new byte[32];
    protected static final byte[] tab6 = new byte[64];

    static {
        int i = 0;
        while (i < 4) {
            TextureFormatLoaderDDS.tab2[i] = (byte)(i * 255 / 3);
            ++i;
        }
        i = 0;
        while (i < 8) {
            TextureFormatLoaderDDS.tab3[i] = (byte)(i * 255 / 7);
            ++i;
        }
        i = 0;
        while (i < 16) {
            TextureFormatLoaderDDS.tab4[i] = (byte)(i * 255 / 15);
            ++i;
        }
        i = 0;
        while (i < 32) {
            TextureFormatLoaderDDS.tab5[i] = (byte)(i * 255 / 31);
            ++i;
        }
        i = 0;
        while (i < 64) {
            TextureFormatLoaderDDS.tab6[i] = (byte)(i * 255 / 63);
            ++i;
        }
    }

    public AbstractTexture loadTexture(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean loadMipmaps, boolean allowStreching, TextureFactory texFactory) throws IOException {
        int mipmapCount;
        TextureImageFormat texImgFormat;
        boolean readAlpha;
        if (in.available() < 8) {
            return null;
        }
        if (this.readInt(in) != 542327876) {
            return null;
        }
        int headerByteSize = this.readInt(in);
        if (headerByteSize != 124) {
            return null;
        }
        int headerIntSize = headerByteSize / 4;
        int[] header = new int[headerIntSize];
        header[0] = headerByteSize;
        int i = 1;
        while (i < headerIntSize) {
            header[i] = this.readInt(in);
            ++i;
        }
        LinePostProcessing lpp = null;
        TextureImageInternalFormat internalFormat = TextureImageInternalFormat.RGBA;
        int blockSize = 0;
        int ddsPixelSize = 0;
        int icPixelSize = 0;
        block0 : switch (header[20]) {
            case 827611204: {
                readAlpha = acceptAlpha;
                texImgFormat = TextureImageFormat.RGBA_DXT1;
                blockSize = 8;
                break;
            }
            case 861165636: {
                readAlpha = acceptAlpha;
                texImgFormat = TextureImageFormat.RGBA_DXT3;
                blockSize = 16;
                break;
            }
            case 877942852: 
            case 894720068: {
                readAlpha = acceptAlpha;
                texImgFormat = TextureImageFormat.RGBA_DXT5;
                blockSize = 16;
                break;
            }
            case 0: {
                switch (header[21]) {
                    case 8: {
                        ddsPixelSize = 1;
                        if (header[22] == 224 && header[23] == 28 && header[24] == 3 && header[25] == 0) {
                            readAlpha = false;
                            texImgFormat = TextureImageFormat.RGB;
                            internalFormat = TextureImageInternalFormat.R3_G3_B2;
                            icPixelSize = 3;
                            lpp = LinePostProcessing_R3G3B2.instance;
                            break block0;
                        }
                        throw new IOException("Unsupported 8 bit color format: red = " + Integer.toHexString(header[22]) + ", green" + Integer.toHexString(header[23]) + ", blue = " + Integer.toHexString(header[24]) + ", alpha = " + Integer.toHexString(header[25]));
                    }
                    case 16: {
                        ddsPixelSize = 2;
                        if (header[22] == 3840 && header[23] == 240 && header[24] == 15 && header[25] == 0) {
                            readAlpha = false;
                            texImgFormat = TextureImageFormat.RGB;
                            internalFormat = TextureImageInternalFormat.RGB4;
                            icPixelSize = 3;
                            lpp = LinePostProcessing_X4R4G4B4.instance;
                            break block0;
                        }
                        if (header[22] == 63488 && header[23] == 2016 && header[24] == 31 && header[25] == 0) {
                            readAlpha = false;
                            texImgFormat = TextureImageFormat.RGB;
                            internalFormat = TextureImageInternalFormat.RGB5;
                            icPixelSize = 3;
                            lpp = LinePostProcessing_R5G6B5.instance;
                            break block0;
                        }
                        if (header[22] == 31744 && header[23] == 992 && header[24] == 31 && header[25] == 0) {
                            readAlpha = false;
                            texImgFormat = TextureImageFormat.RGB;
                            internalFormat = TextureImageInternalFormat.RGB5;
                            icPixelSize = 3;
                            lpp = LinePostProcessing_X1R5G5B5.instance;
                            break block0;
                        }
                        if (header[22] == 31744 && header[23] == 992 && header[24] == 31 && header[25] == 32768) {
                            readAlpha = false;
                            texImgFormat = TextureImageFormat.RGBA;
                            internalFormat = TextureImageInternalFormat.RGB5_A1;
                            icPixelSize = 4;
                            lpp = LinePostProcessing_A1R5G5B5.instance;
                            break block0;
                        }
                        if (header[22] == 3840 && header[23] == 240 && header[24] == 15 && header[25] == 61440) {
                            readAlpha = acceptAlpha;
                            texImgFormat = TextureImageFormat.RGBA;
                            internalFormat = TextureImageInternalFormat.RGBA4;
                            icPixelSize = 4;
                            lpp = LinePostProcessing_A4R4G4B4.instance;
                            break block0;
                        }
                        throw new IOException("Unsupported 16 bit color format: red = " + Integer.toHexString(header[22]) + ", green = " + Integer.toHexString(header[23]) + ", blue = " + Integer.toHexString(header[24]) + ", alpha = " + Integer.toHexString(header[25]));
                    }
                }
                throw new IOException("Unsupported color depth: " + header[21]);
            }
            default: {
                throw new IOException("Unknown compression format: " + Integer.toHexString(header[20]));
            }
        }
        AbstractTexture tex = texFactory.createTexture(readAlpha);
        int width = header[3];
        int height = header[2];
        int n = mipmapCount = loadMipmaps ? header[6] : 1;
        if (blockSize > 0) {
            int size = (width + 3) / 4 * ((height + 3) / 4) * blockSize;
            byte[] tmp = new byte[size];
            int i2 = 0;
            while (i2 < mipmapCount) {
                this.readFully(in, tmp, 0, size);
                AbstractTextureImage ti = texFactory.createTextureImage(width, height, width, height, -1, size, internalFormat, texImgFormat);
                ByteBuffer bb = ti.getDataBuffer();
                bb.limit(bb.capacity());
                bb.put(tmp, 0, size);
                bb.flip();
                tex.setImage(i2, ti);
                width = width + 1 >> 1;
                height = height + 1 >> 1;
                size = (width + 3) / 4 * ((height + 3) / 4) * blockSize;
                ++i2;
            }
        } else {
            int ddsLineSize = width * ddsPixelSize;
            int icLineSize = width * icPixelSize;
            byte[] tmpBuf = new byte[icLineSize * height + 4];
            byte[] ddsBuf = lpp != null ? new byte[ddsLineSize + 4] : null;
            int i3 = 0;
            while (i3 < mipmapCount) {
                int ddsLinePitch = ddsLineSize;
                if (lpp != null) {
                    int y = 0;
                    int off = 0;
                    while (y < height) {
                        this.readFully(in, ddsBuf, 0, ddsLinePitch);
                        lpp.postProcess(tmpBuf, off, ddsBuf, 0, width);
                        off += icLineSize;
                        ++y;
                    }
                } else if (icLineSize == ddsLinePitch) {
                    this.readFully(in, tmpBuf, 0, icLineSize * height);
                } else {
                    int y = 0;
                    int off = 0;
                    while (y < height) {
                        this.readFully(in, tmpBuf, off, ddsLinePitch);
                        off += icLineSize;
                        ++y;
                    }
                }
                AbstractTextureImage ti = texFactory.createTextureImage(width, height, width, height, readAlpha ? 4 : 3, internalFormat, texImgFormat);
                ByteBuffer bb = ti.getDataBuffer();
                bb.limit(bb.capacity());
                bb.put(tmpBuf);
                bb.flip();
                tex.setImage(i3, ti);
                width = Math.max(1, width >> 1);
                height = Math.max(1, height >> 1);
                ddsLineSize = width * ddsPixelSize;
                icLineSize = width * icPixelSize;
                ++i3;
            }
        }
        return tex;
    }

    private void readFully(BufferedInputStream in, byte[] data, int off, int len) throws IOException {
        while (len > 0) {
            int read = in.read(data, off, len);
            if (read <= 0) {
                throw new EOFException();
            }
            off += read;
            len -= read;
        }
    }

    private int readInt(BufferedInputStream in) throws IOException {
        byte[] tmp = this.tmpReadBuffer;
        this.readFully(in, tmp, 0, 4);
        return (tmp[3] & 0xFF) << 24 | (tmp[2] & 0xFF) << 16 | (tmp[1] & 0xFF) << 8 | tmp[0] & 0xFF;
    }

    private static interface LinePostProcessing {
        public void postProcess(byte[] var1, int var2, byte[] var3, int var4, int var5);
    }

    private static class LinePostProcessing_A1R5G5B5
    implements LinePostProcessing {
        public static final LinePostProcessing_A1R5G5B5 instance = new LinePostProcessing_A1R5G5B5();

        private LinePostProcessing_A1R5G5B5() {
        }

        public void postProcess(byte[] dst, int dstOff, byte[] src, int srcOff, int width) {
            int x = 0;
            while (x < width) {
                int v = src[srcOff] & 0xFF | (src[srcOff + 1] & 0xFF) << 8;
                dst[dstOff++] = tab5[v >> 10 & 0x1F];
                dst[dstOff++] = tab5[v >> 5 & 0x1F];
                dst[dstOff++] = tab5[v & 0x1F];
                dst[dstOff++] = (byte)((short)v >>> 15);
                ++x;
                srcOff += 2;
            }
        }
    }

    private static class LinePostProcessing_A4R4G4B4
    implements LinePostProcessing {
        public static final LinePostProcessing_A4R4G4B4 instance = new LinePostProcessing_A4R4G4B4();

        private LinePostProcessing_A4R4G4B4() {
        }

        public void postProcess(byte[] dst, int dstOff, byte[] src, int srcOff, int width) {
            int x = 0;
            while (x < width) {
                int v = src[srcOff] & 0xFF | (src[srcOff + 1] & 0xFF) << 8;
                dst[dstOff++] = tab4[v >> 8 & 0xF];
                dst[dstOff++] = tab4[v >> 4 & 0xF];
                dst[dstOff++] = tab4[v & 0xF];
                dst[dstOff++] = tab4[v >> 12 & 0xF];
                ++x;
                srcOff += 2;
            }
        }
    }

    private static class LinePostProcessing_R3G3B2
    implements LinePostProcessing {
        public static final LinePostProcessing_R3G3B2 instance = new LinePostProcessing_R3G3B2();

        private LinePostProcessing_R3G3B2() {
        }

        public void postProcess(byte[] dst, int dstOff, byte[] src, int srcOff, int width) {
            int x = 0;
            while (x < width) {
                int v = src[srcOff++] & 0xFF;
                dst[dstOff++] = tab3[v >> 5 & 7];
                dst[dstOff++] = tab3[v >> 2 & 7];
                dst[dstOff++] = tab2[v & 3];
                ++x;
            }
        }
    }

    private static class LinePostProcessing_R5G6B5
    implements LinePostProcessing {
        public static final LinePostProcessing_R5G6B5 instance = new LinePostProcessing_R5G6B5();

        private LinePostProcessing_R5G6B5() {
        }

        public void postProcess(byte[] dst, int dstOff, byte[] src, int srcOff, int width) {
            int x = 0;
            while (x < width) {
                int v = src[srcOff] & 0xFF | (src[srcOff + 1] & 0xFF) << 8;
                dst[dstOff++] = tab5[v >> 11 & 0x1F];
                dst[dstOff++] = tab6[v >> 5 & 0x3F];
                dst[dstOff++] = tab5[v & 0x1F];
                ++x;
                srcOff += 2;
            }
        }
    }

    private static class LinePostProcessing_X1R5G5B5
    implements LinePostProcessing {
        public static final LinePostProcessing_X1R5G5B5 instance = new LinePostProcessing_X1R5G5B5();

        private LinePostProcessing_X1R5G5B5() {
        }

        public void postProcess(byte[] dst, int dstOff, byte[] src, int srcOff, int width) {
            int x = 0;
            while (x < width) {
                int v = src[srcOff] & 0xFF | (src[srcOff + 1] & 0xFF) << 8;
                dst[dstOff++] = tab5[v >> 10 & 0x1F];
                dst[dstOff++] = tab5[v >> 5 & 0x1F];
                dst[dstOff++] = tab5[v & 0x1F];
                ++x;
                srcOff += 2;
            }
        }
    }

    private static class LinePostProcessing_X4R4G4B4
    implements LinePostProcessing {
        public static final LinePostProcessing_X4R4G4B4 instance = new LinePostProcessing_X4R4G4B4();

        private LinePostProcessing_X4R4G4B4() {
        }

        public void postProcess(byte[] dst, int dstOff, byte[] src, int srcOff, int width) {
            int x = 0;
            while (x < width) {
                int v = src[srcOff] & 0xFF | (src[srcOff + 1] & 0xFF) << 8;
                dst[dstOff++] = tab4[v >> 8 & 0xF];
                dst[dstOff++] = tab4[v >> 4 & 0xF];
                dst[dstOff++] = tab4[v & 0xF];
                ++x;
                srcOff += 2;
            }
        }
    }
}

