/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.opengl.enums;

import org.jagatoo.opengl.enums.TextureImageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TextureFormat {
    RGB(false),
    RGBA(true),
    LUMINANCE(false),
    DEPTH(false);

    private final boolean hasAlpha;

    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    public static final TextureFormat getFormat(TextureImageFormat tiFormat) {
        switch (tiFormat) {
            case RGB: {
                return RGB;
            }
            case DEPTH: {
                return DEPTH;
            }
            case LUMINANCE: {
                return LUMINANCE;
            }
        }
        return RGBA;
    }

    public final TextureImageFormat getDefaultTextureImageFormat() {
        switch (this) {
            case DEPTH: {
                return TextureImageFormat.DEPTH;
            }
            case LUMINANCE: {
                return TextureImageFormat.LUMINANCE;
            }
            case RGB: {
                return TextureImageFormat.RGB;
            }
            case RGBA: {
                return TextureImageFormat.RGBA;
            }
        }
        throw new Error("Unsupported Format for conversion: " + (Object)((Object)this));
    }

    private TextureFormat(boolean hasAlpha) {
        this.hasAlpha = hasAlpha;
    }
}

