/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.arrays;

public final class ArrayVector {
    public static final void sub(float[] a, float[] b, float[] o) {
        int i = 0;
        while (i < o.length) {
            o[i] = a[i] - b[i];
            ++i;
        }
    }

    public static final void add(float[] a, float[] b, float[] o) {
        int i = 0;
        while (i < o.length) {
            o[i] = a[i] + b[i];
            ++i;
        }
    }

    public static final float lengthSquared(float[] vector) {
        float result = 0.0f;
        int i = 0;
        while (i < vector.length) {
            result += vector[i] * vector[i];
            ++i;
        }
        return result;
    }

    public static final float length(float[] vector) {
        return (float)Math.sqrt(ArrayVector.lengthSquared(vector));
    }

    public static final float distanceSquared(float[] p1, float[] p2) {
        float result = 0.0f;
        int i = 0;
        while (i < p1.length) {
            result += (p1[i] - p2[i]) * (p1[i] - p2[i]);
            ++i;
        }
        return result;
    }

    public static final float distance(float[] p1, float[] p2) {
        return (float)Math.sqrt(ArrayVector.distanceSquared(p1, p2));
    }

    public static final void cross(float[] v1, float[] v2, float[] o) {
        int i = 0;
        while (i < o.length) {
            o[i] = v1[(i + 1) % v1.length] * v2[(i + 2) % v2.length] - v1[(i + 2) % v1.length] * v2[(i + 1) % v2.length];
            ++i;
        }
    }

    public static final float dot(float[] v1, float[] v2) {
        float result = 0.0f;
        int i = 0;
        while (i < v1.length) {
            result += v1[i] * v2[i];
            ++i;
        }
        return result;
    }

    public static final void set(float[] src, float[] trg) {
        int i = 0;
        while (i < src.length) {
            trg[i] = src[i];
            ++i;
        }
    }

    public static final float[] clone(float[] v) {
        float[] result = new float[v.length];
        ArrayVector.set(v, result);
        return result;
    }

    public static final void normalize(float[] v1) {
        float l = ArrayVector.length(v1);
        int i = 0;
        while (i < v1.length) {
            int n = i++;
            v1[n] = v1[n] / l;
        }
    }

    public static final void scale(float factor, float[] vector) {
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] * factor;
        }
    }

    public static final void negate(float[] v1) {
        ArrayVector.scale(-1.0f, v1);
    }

    public static final void absolute(float[] v1) {
        int i = 0;
        while (i < v1.length) {
            v1[i] = Math.abs(v1[i]);
            ++i;
        }
    }

    public static final float angle(float[] v1, float[] v2) {
        float[] tmp = new float[v1.length];
        ArrayVector.cross(v1, v2, tmp);
        float sum = 0.0f;
        int i = 0;
        while (i < v1.length) {
            sum += tmp[i] * tmp[i];
            ++i;
        }
        double tmp2 = Math.sqrt(sum);
        return (float)Math.abs(Math.atan2(tmp2, ArrayVector.dot(v1, v2)));
    }

    public static final void clampMin(float min, float[] v) {
        int i = 0;
        while (i < v.length) {
            if (v[i] < min) {
                v[i] = min;
            }
            ++i;
        }
    }

    public static final void clampMin(float min, float[] src, float[] trg) {
        ArrayVector.set(src, trg);
        ArrayVector.clampMin(min, trg);
    }

    public static final void clampMax(float max, float[] v) {
        int i = 0;
        while (i < v.length) {
            if (v[i] > max) {
                v[i] = max;
            }
            ++i;
        }
    }

    public static final void clampMax(float max, float[] src, float[] trg) {
        ArrayVector.set(src, trg);
        ArrayVector.clampMax(max, trg);
    }

    public static final void clamp(float min, float max, float[] v) {
        ArrayVector.clampMin(min, v);
        ArrayVector.clampMax(max, v);
    }

    public static final void clamp(float min, float max, float[] src, float[] trg) {
        ArrayVector.set(src, trg);
        ArrayVector.clamp(min, max, trg);
    }

    public static void round(float[] v, int decPlaces) {
        float pow = (float)Math.pow(10.0, decPlaces);
        int i = 0;
        while (i < v.length) {
            v[i] = (float)((int)(v[i] * pow)) / pow;
            ++i;
        }
    }

    public static final void interpolate(float[] v1, float[] v2, float alpha) {
        float beta = 1.0f - alpha;
        int i = 0;
        while (i < v1.length) {
            v1[i] = beta * v1[i] + alpha * v2[i];
            ++i;
        }
    }

    public static final void interpolate(float[] v1, float[] v2, float alpha, float[] o) {
        ArrayVector.set(v1, o);
        ArrayVector.interpolate(o, v2, alpha);
    }

    public static final String toString(float[] vector) {
        StringBuffer s = new StringBuffer("[ ");
        int i = 0;
        while (i < vector.length) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(vector[i]);
            ++i;
        }
        s.append(" ]");
        return s.toString();
    }
}

