/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.classes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jagatoo.util.classes.ClassSearchCriterium;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSearcher {
    private static void findClassNamesFromFolder(String baseFolder, File folder, String[] packagePrefixes, ClassSearchCriterium crit, List<Class<?>> classes) {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ClassSearcher.findClassNamesFromFolder(baseFolder, file, packagePrefixes, crit, classes);
            } else if (file.getAbsolutePath().endsWith(".class")) {
                int lastIndex = Math.max(0, file.getAbsolutePath().lastIndexOf(baseFolder)) + baseFolder.length();
                String className = file.getAbsolutePath().substring(lastIndex).replace('\\', '/').replace('/', '.');
                className = className.substring(0, className.length() - 6);
                String[] stringArray = packagePrefixes;
                int n3 = packagePrefixes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pkgName = stringArray[n4];
                    if (className.startsWith(String.valueOf(pkgName) + ".")) {
                        try {
                            Class<?> clazz = Class.forName(className, false, ClassSearcher.class.getClassLoader());
                            if (!crit.check(clazz)) break;
                            classes.add(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static void findClassNamesFromFolder(String folderName, String[] packagePrefixes, ClassSearchCriterium crit, List<Class<?>> classes) {
        ClassSearcher.findClassNamesFromFolder(String.valueOf(folderName) + File.separator, new File(folderName), packagePrefixes, crit, classes);
    }

    private static void findClassNamesFromJar(String jarFilename, String[] packagePrefixes, ClassSearchCriterium crit, List<Class<?>> classes) {
        if (!new File(jarFilename).exists()) {
            System.err.println("Couldn't find jar file " + jarFilename);
            return;
        }
        try {
            JarFile jar = new JarFile(jarFilename);
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                int i = 0;
                while (i < packagePrefixes.length) {
                    if (jarEntry.getName().startsWith(String.valueOf(packagePrefixes[i]) + "/") && jarEntry.getName().endsWith(".class")) {
                        String className = jarEntry.getName().replace('/', '.');
                        className = className.substring(0, className.length() - 6);
                        try {
                            Class<?> clazz = Class.forName(className, false, ClassSearcher.class.getClassLoader());
                            if (crit.check(clazz)) {
                                classes.add(clazz);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Class<?>> findClasses(ClassSearchCriterium crit, String ... packagePrefixes) {
        String[] classPath;
        String[] packagePrifixes_slash = new String[packagePrefixes.length];
        int i = 0;
        while (i < packagePrefixes.length) {
            packagePrifixes_slash[i] = packagePrefixes[i].replace('.', '/');
            ++i;
        }
        ArrayList classes = new ArrayList();
        String[] stringArray = classPath = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            if (cp.endsWith(".jar")) {
                ClassSearcher.findClassNamesFromJar(cp, packagePrifixes_slash, crit, classes);
            } else {
                ClassSearcher.findClassNamesFromFolder(cp, packagePrefixes, crit, classes);
            }
            ++n2;
        }
        Collections.sort(classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return 0;
            }
        });
        return classes;
    }

    private ClassSearcher() {
    }
}

