/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.ini;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.jagatoo.util.errorhandling.ParsingException;

public abstract class AbstractIniParser {
    protected boolean onCommentParsed(int lineNr, String group, String comment) throws ParsingException {
        return true;
    }

    protected boolean onGroupParsed(int lineNr, String group) throws ParsingException {
        return true;
    }

    protected abstract boolean onSettingParsed(int var1, String var2, String var3, String var4, String var5) throws ParsingException;

    protected void onParsingFinished() {
    }

    protected boolean parseLine(int lineNr, String currentGroup, String line) throws IOException, ParsingException {
        if (line.length() == 0) {
            return true;
        }
        if (line.startsWith("#")) {
            return this.onCommentParsed(lineNr, currentGroup, line.substring(1).trim());
        }
        if (line.startsWith("//")) {
            return this.onCommentParsed(lineNr, currentGroup, line.substring(2).trim());
        }
        if (line.startsWith("[")) {
            throw new ParsingException("This method cannot parse groups.");
        }
        int idx = line.indexOf("=");
        if (idx < 0) {
            throw new ParsingException("Illegal line #" + lineNr + ": " + line);
        }
        String key = line.substring(0, idx).trim();
        String value = line.substring(idx + 1).trim();
        boolean proceedParse = true;
        if (value.startsWith("\"")) {
            int lastChar = 0;
            int i = 1;
            while (i < value.length()) {
                char ch = value.charAt(i);
                if (ch == '\"' && lastChar != 92) {
                    idx = value.indexOf("//", i + 1);
                    proceedParse = idx >= 0 ? this.onSettingParsed(lineNr, currentGroup, key, value.substring(1, i), value.substring(idx + 2, value.length()).trim()) : this.onSettingParsed(lineNr, currentGroup, key, value.substring(1, i), null);
                    lastChar = ch;
                    break;
                }
                lastChar = ch;
                ++i;
            }
            if (lastChar != 34) {
                throw new ParsingException("Illegal line #" + lineNr + ": " + line);
            }
        } else {
            idx = value.indexOf("//");
            proceedParse = idx >= 0 ? this.onSettingParsed(lineNr, currentGroup, key, value.substring(0, idx).trim(), value.substring(idx + 2, value.length()).trim()) : this.onSettingParsed(lineNr, currentGroup, key, value, null);
        }
        return proceedParse;
    }

    protected void parseImpl(BufferedReader reader) throws IOException, ParsingException {
        String currentGroup = null;
        String line = null;
        int lineNr = 0;
        boolean proceedParse = true;
        while (proceedParse && (line = reader.readLine()) != null) {
            line = line.trim();
            ++lineNr;
            if (line.length() == 0) continue;
            if (line.startsWith("[")) {
                if (line.endsWith("]")) {
                    currentGroup = line.substring(1, line.length() - 1).trim();
                    proceedParse = this.onGroupParsed(lineNr, currentGroup);
                    continue;
                }
                int idx = line.indexOf("]");
                if (idx < 0) {
                    throw new ParsingException("Illegal line #" + lineNr + ": " + line);
                }
                currentGroup = line.substring(1, idx).trim();
                proceedParse = this.onGroupParsed(lineNr, currentGroup);
                continue;
            }
            proceedParse = this.parseLine(lineNr, currentGroup, line);
        }
        this.onParsingFinished();
    }

    public final void parse(Reader reader) throws IOException, ParsingException {
        if (reader instanceof BufferedReader) {
            this.parseImpl((BufferedReader)reader);
        } else {
            this.parseImpl(new BufferedReader(reader));
        }
    }

    public final void parse(InputStream in) throws IOException, ParsingException {
        this.parseImpl(new BufferedReader(new InputStreamReader(in)));
    }

    public final void parse(URL url) throws IOException, ParsingException {
        this.parse(url.openStream());
    }

    public final void parse(File file) throws IOException, ParsingException {
        this.parse(file.toURI().toURL());
    }

    public final void parse(String filename) throws IOException, ParsingException {
        this.parse(new File(filename));
    }
}

