/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.streams;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jagatoo.util.streams.StreamUtils;

public class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    private final DataInputStream din;
    private int pointer = 0;

    public final int getPointer() {
        return this.pointer;
    }

    public int read() throws IOException {
        int i = super.read();
        ++this.pointer;
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.pointer += result;
        }
        return result;
    }

    public void readFully(byte[] b) throws IOException {
        this.din.readFully(b);
        this.pointer += b.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.din.readFully(b, off, len);
        this.pointer += len;
    }

    public long skip(long n) throws IOException {
        long result = super.skip(n);
        if (result > 0L) {
            this.pointer += (int)result;
        }
        return result;
    }

    public int skipBytes(int n) throws IOException {
        int result = this.din.skipBytes(n);
        if (result > 0) {
            this.pointer += n;
        }
        return result;
    }

    public boolean readBoolean() throws IOException {
        boolean result = this.din.readBoolean();
        ++this.pointer;
        return result;
    }

    public byte readByte() throws IOException {
        byte result = this.din.readByte();
        ++this.pointer;
        return result;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.din.readUnsignedByte();
        ++this.pointer;
        return result;
    }

    public short readShort() throws IOException {
        int low = this.din.read();
        int high = this.din.read();
        this.pointer += 2;
        return (short)(high << 8 | low & 0xFF);
    }

    public int readUnsignedShort() throws IOException {
        int low = this.din.read();
        int high = this.din.read();
        this.pointer += 2;
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    public char readChar() throws IOException {
        char result = this.din.readChar();
        this.pointer += 2;
        return result;
    }

    public int readInt() throws IOException {
        int i3 = this.din.read();
        int i2 = this.din.read();
        int i1 = this.din.read();
        int i0 = this.din.read();
        this.pointer += 4;
        return (i0 & 0xFF) << 24 | (i1 & 0xFF) << 16 | (i2 & 0xFF) << 8 | i3 & 0xFF;
    }

    public long readLong() throws IOException {
        int i7 = this.din.read();
        int i6 = this.din.read();
        int i5 = this.din.read();
        int i4 = this.din.read();
        int i3 = this.din.read();
        int i2 = this.din.read();
        int i1 = this.din.read();
        int i0 = this.din.read();
        this.pointer += 8;
        return (long)(i0 & 0xFF) << 56 | (long)(i1 & 0xFF) << 48 | (long)(i2 & 0xFF) << 40 | (long)(i3 & 0xFF) << 32 | (long)(i4 & 0xFF) << 24 | (long)(i5 & 0xFF) << 16 | (long)(i6 & 0xFF) << 8 | (long)(i7 & 0xFF);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        String result = this.din.readLine();
        this.pointer += result.length() + 1;
        return result;
    }

    public String readUTF() throws IOException {
        return this.din.readUTF();
    }

    public final String readCString(int maxLength, boolean alwaysReadMaxLength) throws IOException {
        String result = StreamUtils.readCString(this, maxLength, alwaysReadMaxLength);
        return result;
    }

    public LittleEndianDataInputStream(InputStream in) {
        super(in);
        this.din = new DataInputStream(in);
    }
}

