/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.streams;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jagatoo.util.arrays.ArrayUtils;

public class StreamUtils {
    public static final void skipBytes(InputStream in, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long skipped = in.skip(toSkip);
            if (skipped > 0L) {
                toSkip -= skipped;
                continue;
            }
            if (skipped >= 0L) continue;
            toSkip = 0L;
        }
    }

    public static final void skipBytes(BufferedInputStream in, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long skipped = in.skip(toSkip);
            if (skipped > 0L) {
                toSkip -= skipped;
                continue;
            }
            if (skipped >= 0L) continue;
            toSkip = 0L;
        }
    }

    public static final byte readByte(InputStream in) throws IOException {
        return (byte)in.read();
    }

    public static final byte readByte(BufferedInputStream in) throws IOException {
        return (byte)in.read();
    }

    public static final short readUnsignedByte(InputStream in) throws IOException {
        int b = in.read();
        return (short)(b & 0xFF);
    }

    public static final short readUnsignedByte(BufferedInputStream in) throws IOException {
        int b = in.read();
        return (short)(b & 0xFF);
    }

    public static final short readShort(InputStream in) throws IOException {
        int s1 = (in.read() & 0xFF) << 8;
        int s2 = in.read() & 0xFF;
        return (short)(s1 | s2);
    }

    public static final short readShort(BufferedInputStream in) throws IOException {
        int s1 = (in.read() & 0xFF) << 8;
        int s2 = in.read() & 0xFF;
        return (short)(s1 | s2);
    }

    public static final int readUnsignedShort(InputStream in) throws IOException {
        int high = in.read();
        int low = in.read();
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    public static final int readUnsignedShort(BufferedInputStream in) throws IOException {
        int high = in.read();
        int low = in.read();
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    public static final short readSwappedShort(InputStream in) throws IOException {
        int s2 = in.read() & 0xFF;
        int s1 = (in.read() & 0xFF) << 8;
        return (short)(s1 | s2);
    }

    public static final short readSwappedShort(BufferedInputStream in) throws IOException {
        int s2 = in.read() & 0xFF;
        int s1 = (in.read() & 0xFF) << 8;
        return (short)(s1 | s2);
    }

    public static final int readSwappedUnsignedShort(InputStream in) throws IOException {
        int low = in.read();
        int high = in.read();
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    public static final int readSwappedUnsignedShort(BufferedInputStream in) throws IOException {
        int low = in.read();
        int high = in.read();
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    public static final int readInt(InputStream in) throws IOException {
        int i4 = (in.read() & 0xFF) << 24;
        int i3 = (in.read() & 0xFF) << 16;
        int i2 = (in.read() & 0xFF) << 8;
        int i1 = in.read() & 0xFF;
        return i4 | i3 | i2 | i1;
    }

    public static final int readInt(BufferedInputStream in) throws IOException {
        int i4 = (in.read() & 0xFF) << 24;
        int i3 = (in.read() & 0xFF) << 16;
        int i2 = (in.read() & 0xFF) << 8;
        int i1 = in.read() & 0xFF;
        return i4 | i3 | i2 | i1;
    }

    public static final int readSwappedInt(InputStream in) throws IOException {
        int i4 = in.read() & 0xFF;
        int i3 = (in.read() & 0xFF) << 8;
        int i2 = (in.read() & 0xFF) << 16;
        int i1 = (in.read() & 0xFF) << 24;
        return i4 | i3 | i2 | i1;
    }

    public static final int readSwappedInt(BufferedInputStream in) throws IOException {
        int i1 = in.read() & 0xFF;
        int i2 = (in.read() & 0xFF) << 8;
        int i3 = (in.read() & 0xFF) << 16;
        int i4 = (in.read() & 0xFF) << 24;
        return i4 | i3 | i2 | i1;
    }

    public static final void readBytes(InputStream in, int bytesToRead, byte[] buffer, int bufferOffset) throws IOException {
        int read;
        int bytesRead = 0;
        do {
            read = in.read(buffer, bufferOffset + bytesRead, bytesToRead);
            bytesRead += read;
        } while ((bytesToRead -= read) > 0 && read > 0);
    }

    public static final void readBytes(BufferedInputStream in, int bytesToRead, byte[] buffer, int bufferOffset) throws IOException {
        int read;
        int bytesRead = 0;
        do {
            read = in.read(buffer, bufferOffset + bytesRead, bytesToRead);
            bytesRead += read;
        } while ((bytesToRead -= read) > 0 && read > 0);
    }

    public static final String readCString(InputStream in, int maxLength, boolean alwaysReadMaxLength) throws IOException {
        byte[] bytes = new byte[maxLength];
        if (alwaysReadMaxLength) {
            int toRead = maxLength;
            while (toRead > 0) {
                int read = in.read(bytes, maxLength - toRead, toRead);
                toRead -= read;
            }
            int nullIndex = ArrayUtils.indexOf(bytes, (byte)0);
            if (nullIndex == -1) {
                return new String(bytes);
            }
            return new String(bytes, 0, nullIndex);
        }
        int i = 0;
        while (i < maxLength) {
            int ib = in.read();
            if (ib == -1) {
                return null;
            }
            byte b = (byte)ib;
            if (b == 0) {
                return new String(bytes, 0, i);
            }
            bytes[i] = b;
            ++i;
        }
        return new String(bytes);
    }

    public static final byte[] buildByteArray(InputStream in, int initialSize) throws IOException {
        int n;
        int a = in.available();
        byte[] buffer = new byte[Math.min(a, initialSize)];
        int offset = 0;
        while ((n = in.read(buffer, offset, a)) > 0) {
            if (n <= 0) break;
            a = in.available();
            if ((offset += n) + a <= buffer.length) continue;
            byte[] newBuffer = new byte[Math.max(buffer.length << 1, offset + a)];
            System.arraycopy(buffer, 0, newBuffer, 0, offset);
            buffer = newBuffer;
        }
        if (buffer.length == offset) {
            return buffer;
        }
        byte[] copy = new byte[offset];
        System.arraycopy(buffer, 0, copy, 0, offset);
        return copy;
    }

    public static final byte[] buildByteArray(InputStream in) throws IOException {
        return StreamUtils.buildByteArray(in, in.available());
    }
}

