/*
 * Decompiled with CFR 0.152.
 */
package org.openmali;

import java.util.Random;

public class FastMath {
    public static final float PI = (float)Math.PI;
    public static final float PI_HALF = 1.5707964f;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float INV_PI = 0.31830987f;
    public static final float INV_TWO_PI = 0.15915494f;
    public static final float E = (float)Math.E;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float RAD_TO_DEG = 57.295776f;
    private static final Random random = new Random(System.nanoTime());
    public static final double LOG10_TO_LOG2d = 3.3219280948873626;
    public static final float LOG10_TO_LOG2 = 3.321928f;
    protected static int precision = 0x100000;
    private static float[] sinTable = null;
    private static float[] cosTable = null;
    private static float[] tanTable = null;

    public static final void setPrecision(int precision) {
        if (FastMath.precision != precision) {
            sinTable = null;
            cosTable = null;
            tanTable = null;
        }
        FastMath.precision = precision;
    }

    public static final int getPrecision() {
        return precision;
    }

    private static final int radToIndex(float radians) {
        return (int)(radians / ((float)Math.PI * 2) * (float)precision) & precision - 1;
    }

    public static final float sin(float x) {
        if (sinTable == null) {
            sinTable = new float[precision];
            float rad_slice = (float)Math.PI * 2 / (float)precision;
            int i = 0;
            while (i < precision) {
                FastMath.sinTable[i] = (float)Math.sin((float)i * rad_slice);
                ++i;
            }
        }
        return sinTable[FastMath.radToIndex(x)];
    }

    public static final float asin(float x) {
        return (float)Math.asin(x);
    }

    public static final float sinh(float x) {
        return (float)Math.sinh(x);
    }

    public static final float cos(float x) {
        if (cosTable == null) {
            cosTable = new float[precision];
            float rad_slice = (float)Math.PI * 2 / (float)precision;
            int i = 0;
            while (i < precision) {
                FastMath.cosTable[i] = (float)Math.cos((float)i * rad_slice);
                ++i;
            }
        }
        return cosTable[FastMath.radToIndex(x)];
    }

    public static final float acos(float x) {
        return (float)Math.acos(x);
    }

    public static final float cosh(float x) {
        return (float)Math.cosh(x);
    }

    public static final float tan(float x) {
        if (tanTable == null) {
            tanTable = new float[precision];
            float rad_slice = (float)Math.PI * 2 / (float)precision;
            int i = 0;
            while (i < precision) {
                FastMath.tanTable[i] = (float)Math.tan((float)i * rad_slice);
                ++i;
            }
        }
        return tanTable[FastMath.radToIndex(x)];
    }

    public static final float atan(float x) {
        return (float)Math.atan(x);
    }

    public static final float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static final float tanh(float x) {
        return (float)Math.tanh(x);
    }

    public static final float cbrt(float x) {
        return (float)Math.cbrt(x);
    }

    public static final float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    public static final float invSqrt(float x) {
        return 1.0f / (float)Math.sqrt(x);
    }

    public static final float ceil(float x) {
        return (float)Math.ceil(x);
    }

    public static final float floor(float x) {
        return (float)Math.floor(x);
    }

    public static final float log(float x) {
        return (float)Math.log(x);
    }

    public static final float log10(float x) {
        return (float)Math.log10(x);
    }

    public static final float log1p(float x) {
        return (float)Math.log1p(x);
    }

    public static final float log2(float x) {
        return (float)(Math.log(x) * 3.3219280948873626);
    }

    public static final float toDeg(float x) {
        return (float)Math.toDegrees(x);
    }

    public static final float toRad(float x) {
        return (float)Math.toRadians(x);
    }

    public static final float pow(float base, float exp) {
        return (float)Math.pow(base, exp);
    }

    public static final float pow2(float base) {
        return FastMath.pow(base, 2.0f);
    }

    public static final float pow3(float base) {
        return FastMath.pow(base, 3.0f);
    }

    public static final int pow(int base, int exp) {
        return (int)Math.pow(base, exp);
    }

    public static final boolean epsilonEquals(float v1, float v2, float epsilon) {
        return Math.abs(v1 - v2) < epsilon;
    }

    public static final float hypot(float a, float b) {
        if (Math.abs(a) > Math.abs(b)) {
            float r = b / a;
            r = Math.abs(a) * FastMath.sqrt(1.0f + r * r);
            return r;
        }
        if (b != 0.0f) {
            float r = a / b;
            r = Math.abs(b) * FastMath.sqrt(1.0f + r * r);
            return r;
        }
        return 0.0f;
    }

    public static final FRExpResultf frexp(float value, FRExpResultf result) {
        int i = 0;
        if (value != 0.0f) {
            int sign = 1;
            if (value < 0.0f) {
                sign = -1;
                value = -value;
            }
            while (value < 0.5f) {
                value *= 2.0f;
                --i;
            }
            while (value >= 1.0f) {
                value *= 0.5f;
                ++i;
            }
            value *= (float)sign;
        }
        result.mantissa = value;
        result.exponent = i;
        return result;
    }

    public static final FRExpResultf frexp(float value) {
        return FastMath.frexp(value, new FRExpResultf());
    }

    public static final Random getRandom() {
        return random;
    }

    public static final float randomFloat() {
        return random.nextFloat();
    }

    public static final float randomFloat(float max) {
        return random.nextFloat() * max;
    }

    public static final float randomFloat(float min, float max) {
        return min + random.nextFloat() * (max - min);
    }

    public static final int randomInt() {
        return random.nextInt();
    }

    public static final int randomInt(int max) {
        return random.nextInt(max);
    }

    public static final int randomInt(int min, int max) {
        return min + random.nextInt(max - min);
    }

    public static final long randomLong() {
        return random.nextLong();
    }

    public static final long randomLong(long max) {
        return random.nextLong() * (max / Long.MAX_VALUE);
    }

    public static final long randomLong(long min, long max) {
        return min + FastMath.randomLong(max - min);
    }

    public static class FRExpResultf {
        public float mantissa;
        public int exponent;
    }
}

