/*
 * Decompiled with CFR 0.152.
 */
package org.openmali;

import java.util.Random;

public class FastMathd {
    public static final double PI = Math.PI;
    public static final double PI_HALF = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;
    public static final double INV_PI = 0.3183098861837907;
    public static final double INV_TWO_PI = 0.15915494309189535;
    public static final double E = Math.E;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final Random random = new Random(System.nanoTime());
    public static final double LOG10_TO_LOG2d = 3.3219280948873626;
    public static final double LOG10_TO_LOG2 = 3.3219280948873626;
    private static int precision = 0x100000;
    private static double[] sinTable = null;
    private static double[] cosTable = null;
    private static double[] tanTable = null;

    public static final void setPrecision(int precision) {
        if (FastMathd.precision != precision) {
            sinTable = null;
            cosTable = null;
            tanTable = null;
        }
        FastMathd.precision = precision;
    }

    public static final int getPrecision() {
        return precision;
    }

    private static final int radToIndex(double radians) {
        return (int)(radians / (Math.PI * 2) * (double)precision) & precision - 1;
    }

    public static final double sin(double x) {
        if (sinTable == null) {
            sinTable = new double[precision];
            double rad_slice = Math.PI * 2 / (double)precision;
            int i = 0;
            while (i < precision) {
                FastMathd.sinTable[i] = Math.sin((double)i * rad_slice);
                ++i;
            }
        }
        return sinTable[FastMathd.radToIndex(x)];
    }

    public static final double asin(double x) {
        return Math.asin(x);
    }

    public static final double sinh(double x) {
        return Math.sinh(x);
    }

    public static final double cos(double x) {
        if (cosTable == null) {
            cosTable = new double[precision];
            double rad_slice = Math.PI * 2 / (double)precision;
            int i = 0;
            while (i < precision) {
                FastMathd.cosTable[i] = Math.cos((double)i * rad_slice);
                ++i;
            }
        }
        return cosTable[FastMathd.radToIndex(x)];
    }

    public static final double acos(double x) {
        return Math.acos(x);
    }

    public static final double cosh(double x) {
        return Math.cosh(x);
    }

    public static final double tan(double x) {
        if (tanTable == null) {
            tanTable = new double[precision];
            double rad_slice = Math.PI * 2 / (double)precision;
            int i = 0;
            while (i < precision) {
                FastMathd.tanTable[i] = Math.tan((double)i * rad_slice);
                ++i;
            }
        }
        return tanTable[FastMathd.radToIndex(x)];
    }

    public static final double atan(double x) {
        return Math.atan(x);
    }

    public static final double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static final double tanh(double x) {
        return Math.tanh(x);
    }

    public static final double cbrt(double x) {
        return Math.cbrt(x);
    }

    public static final double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static final double invSqrt(double x) {
        return 1.0 / Math.sqrt(x);
    }

    public static final double ceil(double x) {
        return Math.ceil(x);
    }

    public static final double floor(double x) {
        return Math.floor(x);
    }

    public static final double log(double x) {
        return Math.log(x);
    }

    public static final double log10(double x) {
        return Math.log10(x);
    }

    public static final double log1p(double x) {
        return Math.log1p(x);
    }

    public static final double log2(double x) {
        return Math.log(x) * 3.3219280948873626;
    }

    public static final double toDeg(double x) {
        return Math.toDegrees(x);
    }

    public static final double toRad(double x) {
        return Math.toRadians(x);
    }

    public static final double pow(double base, double exp) {
        return Math.pow(base, exp);
    }

    public static final double pow2(double base) {
        return FastMathd.pow(base, 2.0);
    }

    public static final double pow3(double base) {
        return FastMathd.pow(base, 3.0);
    }

    public static final boolean epsilonEquals(double v1, double v2, double epsilon) {
        return Math.abs(v1 - v2) < epsilon;
    }

    public static final double hypot(double a, double b) {
        if (Math.abs(a) > Math.abs(b)) {
            double r = b / a;
            r = Math.abs(a) * FastMathd.sqrt(1.0 + r * r);
            return r;
        }
        if (b != 0.0) {
            double r = a / b;
            r = Math.abs(b) * FastMathd.sqrt(1.0 + r * r);
            return r;
        }
        return 0.0;
    }

    public static final FRExpResultd frexp(double value, FRExpResultd result) {
        int i = 0;
        if (value != 0.0) {
            int sign = 1;
            if (value < 0.0) {
                sign = -1;
                value = -value;
            }
            while (value < 0.5) {
                value *= 2.0;
                --i;
            }
            while (value >= 1.0) {
                value *= 0.5;
                ++i;
            }
            value *= (double)sign;
        }
        result.mantissa = value;
        result.exponent = i;
        return result;
    }

    public static final FRExpResultd frexp(double value) {
        return FastMathd.frexp(value, new FRExpResultd());
    }

    public static final Random getRandom() {
        return random;
    }

    public static final double randomDouble() {
        return random.nextDouble();
    }

    public static final double randomDouble(float max) {
        return random.nextDouble() * (double)max;
    }

    public static final double randomDouble(float min, float max) {
        return (double)min + random.nextDouble() * (double)(max - min);
    }

    public static final int randomInt() {
        return random.nextInt();
    }

    public static final int randomInt(int max) {
        return random.nextInt(max);
    }

    public static final int randomInt(int min, int max) {
        return min + random.nextInt(max - min);
    }

    public static final long randomLong() {
        return random.nextLong();
    }

    public static final long randomLong(long max) {
        return random.nextLong() * (max / Long.MAX_VALUE);
    }

    public static final long randomLong(long min, long max) {
        return min + FastMathd.randomLong(max - min);
    }

    public static class FRExpResultd {
        public double mantissa;
        public int exponent;
    }
}

