/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.number.matrix;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import org.openmali.FastMath;
import org.openmali.number.Parser;
import org.openmali.number.Radical1;
import org.openmali.number.matrix.Matrix3rad;
import org.openmali.number.matrix.MatrixMxNrad;
import org.openmali.number.matrix.Tuple3rad;
import org.openmali.vecmath2.Matrix4f;

public class Matrix4rad
extends MatrixMxNrad
implements Externalizable {
    private static final Radical1 l1 = new Radical1();
    private static final Radical1 l2 = new Radical1();
    private static final Radical1 l3 = new Radical1();
    private static final Radical1 l4 = new Radical1();
    private static final Radical1 l5 = new Radical1();
    private static final Radical1 l6 = new Radical1();
    private static final Radical1 l7 = new Radical1();
    private static final Radical1 l8 = new Radical1();
    private static final Radical1 l9 = new Radical1();
    private static final Radical1 l10 = new Radical1();
    private static final Radical1 l11 = new Radical1();
    private static final Radical1 l12 = new Radical1();
    private static final Radical1 l13 = new Radical1();
    private static final Radical1 l14 = new Radical1();
    private static final Radical1 l15 = new Radical1();
    private static final Radical1 l16 = new Radical1();
    private static final Radical1 op1 = new Radical1();
    private static final Radical1 op2 = new Radical1();
    private static final Radical1 op3 = new Radical1();
    private static final Radical1 op4 = new Radical1();
    private static final Radical1 op5 = new Radical1();
    private static final Radical1 op6 = new Radical1();
    public static final Matrix4rad IDENTITY = Matrix4rad.newReadOnly();

    public Radical1 m00(Radical1 passback) {
        return this.get(0, 0, passback);
    }

    public final Radical1 m01(Radical1 passback) {
        return this.get(0, 1, passback);
    }

    public final Radical1 m02(Radical1 passback) {
        return this.get(0, 2, passback);
    }

    public final Radical1 m03(Radical1 passback) {
        return this.get(0, 3, passback);
    }

    public final Radical1 m10(Radical1 passback) {
        return this.get(1, 0, passback);
    }

    public final Radical1 m11(Radical1 passback) {
        return this.get(1, 1, passback);
    }

    public final Radical1 m12(Radical1 passback) {
        return this.get(1, 2, passback);
    }

    public final Radical1 m13(Radical1 passback) {
        return this.get(1, 3, passback);
    }

    public final Radical1 m20(Radical1 passback) {
        return this.get(2, 0, passback);
    }

    public final Radical1 m21(Radical1 passback) {
        return this.get(2, 1, passback);
    }

    public final Radical1 m22(Radical1 passback) {
        return this.get(2, 2, passback);
    }

    public final Radical1 m23(Radical1 passback) {
        return this.get(2, 3, passback);
    }

    public final Radical1 m30(Radical1 passback) {
        return this.get(3, 0, passback);
    }

    public final Radical1 m31(Radical1 passback) {
        return this.get(3, 1, passback);
    }

    public final Radical1 m32(Radical1 passback) {
        return this.get(3, 2, passback);
    }

    public final Radical1 m33(Radical1 passback) {
        return this.get(3, 3, passback);
    }

    public Radical1 m00R() {
        return this.getReference(0, 0);
    }

    public final Radical1 m01R() {
        return this.getReference(0, 1);
    }

    public final Radical1 m02R() {
        return this.getReference(0, 2);
    }

    public final Radical1 m03R() {
        return this.getReference(0, 3);
    }

    public final Radical1 m10R() {
        return this.getReference(1, 0);
    }

    public final Radical1 m11R() {
        return this.getReference(1, 1);
    }

    public final Radical1 m12R() {
        return this.getReference(1, 2);
    }

    public final Radical1 m13R() {
        return this.getReference(1, 3);
    }

    public final Radical1 m20R() {
        return this.getReference(2, 0);
    }

    public final Radical1 m21R() {
        return this.getReference(2, 1);
    }

    public final Radical1 m22R() {
        return this.getReference(2, 2);
    }

    public final Radical1 m23R() {
        return this.getReference(2, 3);
    }

    public final Radical1 m30R() {
        return this.getReference(3, 0);
    }

    public final Radical1 m31R() {
        return this.getReference(3, 1);
    }

    public final Radical1 m32R() {
        return this.getReference(3, 2);
    }

    public final Radical1 m33R() {
        return this.getReference(3, 3);
    }

    public void setRotation(Matrix3rad rot) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.set(i, j, rot.getReference(i, j));
                ++j;
            }
            ++i;
        }
    }

    public Matrix3rad getRotation(Matrix3rad passback) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.get(i, j, passback.getReference(i, j));
                ++j;
            }
            ++i;
        }
        return passback;
    }

    public void setTranslation(Tuple3rad d) {
        int i = 0;
        while (i < 3) {
            this.set(i, 3, d.getReference(i));
            ++i;
        }
    }

    public Tuple3rad getTranslation(Tuple3rad passback) {
        int i = 0;
        while (i < 3) {
            this.get(i, 3, passback.getReference(i));
            ++i;
        }
        return passback;
    }

    public static Matrix4rad mul(Matrix4rad op1, Matrix4rad op2, Matrix4rad result) {
        result.mul(op1, op2);
        return result;
    }

    public boolean epsilonEquals(Matrix4f other, float e) {
        Radical1 passback = new Radical1();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                if (!FastMath.epsilonEquals(other.get(i, j), this.get(i, j, passback).floatValue(), e)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Matrix4rad clone() {
        Radical1 tmp = new Radical1();
        Matrix4rad result = new Matrix4rad();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                result.set(i, j, this.get(i, j, tmp));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public final Radical1 determinant() {
        l1.setZero();
        l2.setZero();
        l3.setZero();
        l4.setZero();
        l5.setZero();
        l6.setZero();
        Radical1.mul(Radical1.sub(Radical1.mul(this.m00R(), this.m11R(), op1), Radical1.mul(this.m01R(), this.m10R(), op2), op3), Radical1.sub(Radical1.mul(this.m22R(), this.m33R(), op4), Radical1.mul(this.m23R(), this.m32R(), op5), op6), l1);
        Radical1.mul(Radical1.sub(Radical1.mul(this.m00R(), this.m12R(), op1), Radical1.mul(this.m02R(), this.m10R(), op2), op3), Radical1.sub(Radical1.mul(this.m21R(), this.m33R(), op4), Radical1.mul(this.m23R(), this.m31R(), op5), op6), l2);
        Radical1.mul(Radical1.sub(Radical1.mul(this.m00R(), this.m13R(), op1), Radical1.mul(this.m03R(), this.m10R(), op2), op3), Radical1.sub(Radical1.mul(this.m21R(), this.m32R(), op4), Radical1.mul(this.m22R(), this.m31R(), op5), op6), l3);
        Radical1.mul(Radical1.sub(Radical1.mul(this.m01R(), this.m12R(), op1), Radical1.mul(this.m02R(), this.m11R(), op2), op3), Radical1.sub(Radical1.mul(this.m20R(), this.m33R(), op4), Radical1.mul(this.m23R(), this.m30R(), op5), op6), l4);
        Radical1.mul(Radical1.sub(Radical1.mul(this.m01R(), this.m13R(), op1), Radical1.mul(this.m03R(), this.m11R(), op2), op3), Radical1.sub(Radical1.mul(this.m20R(), this.m32R(), op4), Radical1.mul(this.m22R(), this.m30R(), op5), op6), l5);
        Radical1.mul(Radical1.sub(Radical1.mul(this.m02R(), this.m13R(), op1), Radical1.mul(this.m03R(), this.m12R(), op2), op3), Radical1.sub(Radical1.mul(this.m02R(), this.m31R(), op4), Radical1.mul(this.m21R(), this.m30R(), op5), op6), l6);
        Radical1 ans = new Radical1();
        Radical1.sub(l1, l2, ans);
        Radical1.add(ans, l3, ans);
        Radical1.add(ans, l4, ans);
        Radical1.sub(ans, l5, ans);
        Radical1.add(ans, l6, ans);
        return ans;
    }

    private static Radical1 mulR(Radical1 a, Radical1 b, Radical1 ans) {
        return Radical1.mul(a, b, ans);
    }

    private static Radical1 addR(Radical1 a, Radical1 b, Radical1 ans) {
        return Radical1.add(a, b, ans);
    }

    private static Radical1 subR(Radical1 a, Radical1 b, Radical1 ans) {
        return Radical1.sub(a, b, ans);
    }

    public final void invert() {
        Radical1 s = this.determinant();
        if (s.equals(Radical1.ZERO)) {
            return;
        }
        if (!s.equals(Radical1.ONE)) {
            throw new ArithmeticException("can't invert radical expressions that have non-1 determinant (i.e. that rescale)");
        }
        l1.setZero();
        l2.setZero();
        l3.setZero();
        l4.setZero();
        l5.setZero();
        l6.setZero();
        l7.setZero();
        l8.setZero();
        l9.setZero();
        l10.setZero();
        l11.setZero();
        l12.setZero();
        l13.setZero();
        l14.setZero();
        l15.setZero();
        l16.setZero();
        this.calcPartInverse(5, 10, 15, 11, 14, op1, op2, op3, op4, l1);
        this.calcPartInverse(6, 11, 13, 9, 15, op1, op2, op3, op4, l1);
        this.calcPartInverse(7, 9, 14, 10, 13, op1, op2, op3, op4, l1);
        this.calcPartInverse(9, 2, 15, 3, 14, op1, op2, op3, op4, l2);
        this.calcPartInverse(10, 3, 13, 1, 15, op1, op2, op3, op4, l2);
        this.calcPartInverse(11, 1, 14, 2, 13, op1, op2, op3, op4, l2);
        this.calcPartInverse(13, 2, 7, 3, 6, op1, op2, op3, op4, l3);
        this.calcPartInverse(14, 3, 5, 1, 7, op1, op2, op3, op4, l3);
        this.calcPartInverse(15, 1, 6, 2, 5, op1, op2, op3, op4, l3);
        this.calcPartInverse(1, 7, 10, 6, 11, op1, op2, op3, op4, l4);
        this.calcPartInverse(2, 5, 11, 7, 9, op1, op2, op3, op4, l4);
        this.calcPartInverse(3, 6, 9, 5, 10, op1, op2, op3, op4, l4);
        this.calcPartInverse(6, 8, 15, 11, 12, op1, op2, op3, op4, l5);
        this.calcPartInverse(7, 10, 12, 8, 14, op1, op2, op3, op4, l5);
        this.calcPartInverse(4, 11, 14, 10, 15, op1, op2, op3, op4, l5);
        this.calcPartInverse(10, 0, 15, 3, 12, op1, op2, op3, op4, l6);
        this.calcPartInverse(11, 2, 12, 0, 14, op1, op2, op3, op4, l6);
        this.calcPartInverse(8, 3, 14, 2, 15, op1, op2, op3, op4, l6);
        this.calcPartInverse(14, 0, 7, 3, 4, op1, op2, op3, op4, l7);
        this.calcPartInverse(15, 2, 4, 0, 6, op1, op2, op3, op4, l7);
        this.calcPartInverse(12, 3, 6, 2, 7, op1, op2, op3, op4, l7);
        this.calcPartInverse(2, 7, 8, 4, 11, op1, op2, op3, op4, l8);
        this.calcPartInverse(3, 4, 10, 6, 8, op1, op2, op3, op4, l8);
        this.calcPartInverse(0, 6, 11, 7, 10, op1, op2, op3, op4, l8);
        this.calcPartInverse(7, 8, 13, 9, 12, op1, op2, op3, op4, l9);
        this.calcPartInverse(4, 9, 15, 11, 13, op1, op2, op3, op4, l9);
        this.calcPartInverse(5, 11, 12, 8, 15, op1, op2, op3, op4, l9);
        this.calcPartInverse(11, 0, 13, 1, 12, op1, op2, op3, op4, l10);
        this.calcPartInverse(8, 1, 15, 3, 13, op1, op2, op3, op4, l10);
        this.calcPartInverse(9, 3, 12, 0, 15, op1, op2, op3, op4, l10);
        this.calcPartInverse(15, 0, 5, 1, 4, op1, op2, op3, op4, l11);
        this.calcPartInverse(12, 1, 7, 3, 5, op1, op2, op3, op4, l11);
        this.calcPartInverse(13, 3, 4, 0, 7, op1, op2, op3, op4, l11);
        this.calcPartInverse(3, 5, 8, 4, 9, op1, op2, op3, op4, l12);
        this.calcPartInverse(0, 7, 9, 5, 11, op1, op2, op3, op4, l12);
        this.calcPartInverse(1, 4, 11, 7, 8, op1, op2, op3, op4, l12);
        this.calcPartInverse(4, 10, 13, 9, 14, op1, op2, op3, op4, l13);
        this.calcPartInverse(5, 8, 14, 10, 12, op1, op2, op3, op4, l13);
        this.calcPartInverse(6, 9, 12, 8, 13, op1, op2, op3, op4, l13);
        this.calcPartInverse(8, 2, 13, 1, 14, op1, op2, op3, op4, l14);
        this.calcPartInverse(9, 0, 14, 2, 12, op1, op2, op3, op4, l14);
        this.calcPartInverse(10, 1, 12, 0, 13, op1, op2, op3, op4, l14);
        this.calcPartInverse(12, 2, 5, 1, 6, op1, op2, op3, op4, l15);
        this.calcPartInverse(13, 0, 6, 2, 4, op1, op2, op3, op4, l15);
        this.calcPartInverse(14, 1, 4, 0, 5, op1, op2, op3, op4, l15);
        this.calcPartInverse(0, 5, 10, 6, 9, op1, op2, op3, op4, l16);
        this.calcPartInverse(1, 6, 8, 4, 10, op1, op2, op3, op4, l16);
        this.calcPartInverse(2, 4, 9, 5, 8, op1, op2, op3, op4, l16);
        this.values[0].set(l1);
        this.values[1].set(l2);
        this.values[2].set(l3);
        this.values[3].set(l4);
        this.values[4].set(l5);
        this.values[5].set(l6);
        this.values[6].set(l7);
        this.values[7].set(l8);
        this.values[8].set(l9);
        this.values[9].set(l10);
        this.values[10].set(l11);
        this.values[11].set(l12);
        this.values[12].set(l13);
        this.values[13].set(l14);
        this.values[14].set(l15);
        this.values[15].set(l16);
        if (s.equals(Radical1.MINUS_ONE)) {
            this.negate();
        }
    }

    private void calcPartInverse(int i, int i1, int i2, int i3, int i4, Radical1 op1, Radical1 op2, Radical1 op3, Radical1 op4, Radical1 l1) {
        Matrix4rad.addR(l1, Matrix4rad.mulR(this.values[i], Matrix4rad.subR(Matrix4rad.mulR(this.values[i1], this.values[i2], op3), Matrix4rad.mulR(this.values[i3], this.values[i4], op4), op2), op1), l1);
    }

    public final void invert(Matrix4rad toInvert) {
        this.set(toInvert);
        this.invert();
    }

    public static Matrix4rad parseMatrix4rad(String str) {
        StringReader in = new StringReader(str);
        try {
            Matrix4rad ret = new Parser(in).matrix4rad();
            in.close();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getReference(0, 3));
        out.writeObject(this.getReference(1, 3));
        out.writeObject(this.getReference(2, 3));
        out.writeObject(this.getReference(0, 0));
        out.writeObject(this.getReference(0, 1));
        out.writeObject(this.getReference(1, 0));
        out.writeObject(this.getReference(1, 1));
        out.writeObject(this.getReference(0, 2));
        out.writeObject(this.getReference(1, 2));
        out.writeObject(this.getReference(2, 0));
        out.writeObject(this.getReference(2, 1));
        out.writeObject(this.getReference(2, 2));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setReference(0, 3, (Radical1)in.readObject());
        this.setReference(1, 3, (Radical1)in.readObject());
        this.setReference(2, 3, (Radical1)in.readObject());
        this.setReference(0, 0, (Radical1)in.readObject());
        this.setReference(0, 1, (Radical1)in.readObject());
        this.setReference(1, 0, (Radical1)in.readObject());
        this.setReference(1, 1, (Radical1)in.readObject());
        this.setReference(0, 2, (Radical1)in.readObject());
        this.setReference(1, 2, (Radical1)in.readObject());
        this.setReference(2, 0, (Radical1)in.readObject());
        this.setReference(2, 1, (Radical1)in.readObject());
        this.setReference(2, 2, (Radical1)in.readObject());
    }

    protected Matrix4rad(boolean readOnly) {
        super(readOnly, 4, 4);
    }

    public Matrix4rad() {
        this(false);
    }

    public Matrix4rad(Tuple3rad translation, Matrix3rad rotation) {
        this();
        this.setTranslation(translation);
        this.setRotation(rotation);
    }

    public static Matrix4rad newReadOnly() {
        return new Matrix4rad(true);
    }
}

