/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import org.openmali.FastMath;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.ConvexHull;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public final class IntersectionFactory {
    private static final float EPSILON_ANGLE = 1.0E-5f;

    public static boolean sphereIntersectsSphere(float x1, float y1, float z1, float r1, float x2, float y2, float z2, float r2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        float dz = z1 - z2;
        float d_sq = dx * dx + dy * dy + dz * dz;
        return !(d_sq > (r1 + r2) * (r1 + r2));
    }

    public static boolean sphereIntersectsSphere(Sphere sphere1, float x2, float y2, float z2, float r2) {
        return IntersectionFactory.sphereIntersectsSphere(sphere1.getCenterX(), sphere1.getCenterY(), sphere1.getCenterZ(), sphere1.getRadius(), x2, y2, z2, r2);
    }

    public static boolean sphereIntersectsSphere(Sphere sphere1, Sphere sphere2) {
        return IntersectionFactory.sphereIntersectsSphere(sphere1.getCenterX(), sphere1.getCenterY(), sphere1.getCenterZ(), sphere1.getRadius(), sphere2.getCenterX(), sphere2.getCenterY(), sphere2.getCenterZ(), sphere2.getRadius());
    }

    private static float distance(float point, float min, float max) {
        if (point < min) {
            return min - point;
        }
        if (point > max) {
            return point - max;
        }
        return 0.0f;
    }

    public static final boolean sphereIntersectsBox(float sphereX, float sphereY, float sphereZ, float sphereR, float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ) {
        float d = 0.0f;
        float s = IntersectionFactory.distance(sphereX, boxLowerX, boxUpperX);
        d += s * s;
        s = IntersectionFactory.distance(sphereY, boxLowerY, boxUpperY);
        d += s * s;
        s = IntersectionFactory.distance(sphereZ, boxLowerZ, boxUpperZ);
        return (d += s * s) <= sphereR * sphereR;
    }

    public static final boolean sphereIntersectsBox(float sphereX, float sphereY, float sphereZ, float sphereR, Tuple3f boxLower, Tuple3f boxUpper) {
        return IntersectionFactory.sphereIntersectsBox(sphereX, sphereY, sphereZ, sphereR, boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ());
    }

    public static final boolean sphereIntersectsBox(Sphere sphere, Tuple3f boxLower, Tuple3f boxUpper) {
        return IntersectionFactory.sphereIntersectsBox(sphere, boxLower, boxUpper);
    }

    public static final boolean sphereIntersectsBox(float sphereX, float sphereY, float sphereZ, float sphereR, Box box) {
        return IntersectionFactory.sphereIntersectsBox(sphereX, sphereY, sphereZ, sphereR, box.getLower(), box.getUpper());
    }

    public static final boolean sphereIntersectsBox(Sphere sphere, Box box) {
        return IntersectionFactory.sphereIntersectsBox(sphere, box.getLower(), box.getUpper());
    }

    public static boolean boxIntersectsBox(float lowerX1, float lowerY1, float lowerZ1, float upperX1, float upperY1, float upperZ1, float lowerX2, float lowerY2, float lowerZ2, float upperX2, float upperY2, float upperZ2) {
        if (upperX1 < lowerX2) {
            return false;
        }
        if (upperY1 < lowerY2) {
            return false;
        }
        if (upperZ1 < lowerZ2) {
            return false;
        }
        if (upperX2 < lowerX1) {
            return false;
        }
        if (upperY2 < lowerY1) {
            return false;
        }
        return !(upperZ2 < lowerZ1);
    }

    public static boolean boxIntersectsBox(Tuple3f lower1, Tuple3f upper1, Tuple3f lower2, Tuple3f upper2) {
        return IntersectionFactory.boxIntersectsBox(lower1.getX(), lower1.getY(), lower1.getZ(), upper1.getX(), upper1.getY(), upper1.getZ(), lower2.getX(), lower2.getY(), lower2.getZ(), upper2.getX(), upper2.getY(), upper2.getZ());
    }

    public static boolean boxIntersectsBox(Box box1, Box box2) {
        return IntersectionFactory.boxIntersectsBox(box1.getLower(), box1.getUpper(), box2.getLower(), box2.getUpper());
    }

    public static boolean sphereIntersectsRay(Tuple3f sphereCenter, float sphereRadiusSquared, Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        Vector3f EO = Vector3f.fromPool();
        EO.set((TupleNf)sphereCenter);
        EO.sub(rayOrigin);
        Vector3f V = Vector3f.fromPool();
        V.set((TupleNf)rayDirection);
        float dist2 = EO.lengthSquared();
        if (dist2 < sphereRadiusSquared) {
            V.negate();
        }
        float v = EO.dot(V);
        float dist = sphereRadiusSquared - (dist2 - (v *= FastMath.sqrt(dist2)) * v);
        boolean result = false;
        if (dist > 0.0f) {
            if (intersection != null) {
                float d = FastMath.sqrt(dist);
                V.scale(v - d);
                intersection.add(rayOrigin, V);
            }
            result = true;
        }
        Vector3f.toPool(V);
        Vector3f.toPool(EO);
        return result;
    }

    public static boolean sphereIntersectsRay(Tuple3f sphereCenter, float sphereRadiusSquared, Point3f rayOrigin, Vector3f rayDirection) {
        return IntersectionFactory.sphereIntersectsRay(sphereCenter, sphereRadiusSquared, rayOrigin, rayDirection, null);
    }

    public static boolean intersectsRay(Tuple3f sphereCenter, float sphereRadiusSquared, Ray3f ray, Tuple3f intersect) {
        return IntersectionFactory.sphereIntersectsRay(sphereCenter, sphereRadiusSquared, ray.getOrigin(), ray.getDirection(), intersect);
    }

    public static boolean sphereIntersectsRay(Sphere sphere, Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        return IntersectionFactory.sphereIntersectsRay(sphere.getCenter(), sphere.getRadiusSquared(), rayOrigin, rayDirection, intersection);
    }

    public static boolean sphereIntersectsRay(Sphere sphere, Point3f rayOrigin, Vector3f rayDirection) {
        return IntersectionFactory.sphereIntersectsRay(sphere, rayOrigin, rayDirection, null);
    }

    public static boolean intersectsRay(Sphere sphere, Ray3f ray, Tuple3f intersect) {
        return IntersectionFactory.sphereIntersectsRay(sphere, ray.getOrigin(), ray.getDirection(), intersect);
    }

    public static boolean intersectsRay(Sphere sphere, Ray3f ray) {
        return IntersectionFactory.sphereIntersectsRay(sphere, ray.getOrigin(), ray.getDirection(), null);
    }

    public static boolean sphereIntersectsRayInFront(Tuple3f sphereCenter, float sphereRadiusSquared, Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        Vector3f sect = Vector3f.fromPool();
        boolean hit = IntersectionFactory.sphereIntersectsRay(sphereCenter, sphereRadiusSquared, rayOrigin, rayDirection, sect);
        boolean result = false;
        if (hit) {
            Vector3f dir = Vector3f.fromPool();
            dir.sub(sect, rayOrigin);
            float dot = dir.dot(rayDirection);
            if (dot >= 0.0f) {
                if (intersection != null) {
                    intersection.set((TupleNf)sect);
                }
                result = true;
            }
            Vector3f.toPool(dir);
        }
        Vector3f.toPool(sect);
        return result;
    }

    public static boolean sphereIntersectsRayInFront(Tuple3f sphereCenter, float sphereRadiusSquared, Ray3f ray, Tuple3f intersection) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphereCenter, sphereRadiusSquared, ray.getOrigin(), ray.getDirection(), intersection);
    }

    public static boolean sphereIntersectsRayInFront(Tuple3f sphereCenter, float sphereRadiusSquared, Point3f rayOrigin, Vector3f rayDirection) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphereCenter, sphereRadiusSquared, rayOrigin, rayDirection, null);
    }

    public static boolean sphereIntersectsRayInFront(Tuple3f sphereCenter, float sphereRadiusSquared, Ray3f ray) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphereCenter, sphereRadiusSquared, ray, null);
    }

    public static boolean sphereIntersectsRayInFront(Sphere sphere, Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphere.getCenter(), sphere.getRadiusSquared(), rayOrigin, rayDirection, null);
    }

    public static boolean sphereIntersectsRayInFront(Sphere sphere, Ray3f ray, Tuple3f intersection) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphere, ray.getOrigin(), ray.getDirection(), intersection);
    }

    public static boolean sphereIntersectsRayInFront(Sphere sphere, Point3f rayOrigin, Vector3f rayDirection) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphere, rayOrigin, rayDirection, null);
    }

    public static boolean sphereIntersectsRayInFront(Sphere sphere, Ray3f ray) {
        return IntersectionFactory.sphereIntersectsRayInFront(sphere, ray, null);
    }

    private static boolean boxIntersectsRayStep(Tuple2f xMin_yMax, float vd, float vn) {
        if (Math.abs(vd) < 1.0E-5f) {
            return !(vn > 0.0f);
        }
        float t = -vn / vd;
        if (vd < 0.0f) {
            if (t > xMin_yMax.getY()) {
                return false;
            }
            if (t > xMin_yMax.getX()) {
                xMin_yMax.setX(t);
            }
        } else {
            if (t < xMin_yMax.getX()) {
                return false;
            }
            if (t < xMin_yMax.getY()) {
                xMin_yMax.setY(t);
            }
        }
        return true;
    }

    public static boolean boxIntersectsRay(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, Point3f origin, Vector3f dir, Tuple3f intersection) {
        float rayOriX = origin.getX();
        float rayOriY = origin.getY();
        float rayOriZ = origin.getZ();
        float rayDirX = dir.getX();
        float rayDirY = dir.getY();
        float rayDirZ = dir.getZ();
        Tuple2f tmp = Tuple2f.fromPool(Float.MIN_VALUE, Float.MAX_VALUE);
        boolean hit = IntersectionFactory.boxIntersectsRayStep(tmp, -rayDirX, boxLowerX - rayOriX) && IntersectionFactory.boxIntersectsRayStep(tmp, -rayDirY, boxLowerY - rayOriY) && IntersectionFactory.boxIntersectsRayStep(tmp, -rayDirZ, boxLowerZ - rayOriZ) && IntersectionFactory.boxIntersectsRayStep(tmp, rayDirX, rayOriX - boxUpperX) && IntersectionFactory.boxIntersectsRayStep(tmp, rayDirY, rayOriY - boxUpperY) && IntersectionFactory.boxIntersectsRayStep(tmp, rayDirZ, rayOriZ - boxUpperZ);
        float tnear = tmp.getX();
        float tfar = tmp.getY();
        Tuple2f.toPool(tmp);
        if (!hit) {
            return false;
        }
        float tresult = 0.0f;
        if (tnear >= 0.0f) {
            tresult = tnear;
        } else if (tfar >= 0.0f) {
            tresult = tfar;
        } else {
            return false;
        }
        if (intersection != null) {
            intersection.scaleAdd(tresult, dir, origin);
        }
        return true;
    }

    public static boolean boxIntersectsRay(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, Ray3f ray, Tuple3f intersection) {
        return IntersectionFactory.boxIntersectsRay(boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUpperY, boxUpperZ, ray.getOrigin(), ray.getDirection(), intersection);
    }

    public static boolean boxIntersectsRay(Tuple3f boxLower, Tuple3f boxUpper, Point3f origin, Vector3f dir, Tuple3f intersection) {
        return IntersectionFactory.boxIntersectsRay(boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ(), origin, dir, intersection);
    }

    public static boolean boxIntersectsRay(Tuple3f boxLower, Tuple3f boxUpper, Ray3f ray, Tuple3f intersection) {
        return IntersectionFactory.boxIntersectsRay(boxLower, boxUpper, ray.getOrigin(), ray.getDirection(), intersection);
    }

    public static boolean boxIntersectsRay(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, Point3f origin, Vector3f dir) {
        return IntersectionFactory.boxIntersectsRay(boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUpperY, boxUpperZ, origin, dir, null);
    }

    public static boolean boxIntersectsRay(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, Ray3f ray) {
        return IntersectionFactory.boxIntersectsRay(boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUpperY, boxUpperZ, ray.getOrigin(), ray.getDirection());
    }

    public static boolean boxIntersectsRay(Tuple3f boxLower, Tuple3f boxUpper, Point3f origin, Vector3f dir) {
        return IntersectionFactory.boxIntersectsRay(boxLower.getX(), boxLower.getX(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ(), origin, dir);
    }

    public static boolean boxIntersectsRay(Tuple3f boxLower, Tuple3f boxUpper, Ray3f ray) {
        return IntersectionFactory.boxIntersectsRay(boxLower, boxUpper, ray.getOrigin(), ray.getDirection());
    }

    public static boolean convexHullIntersectsRay(ConvexHull hull, Point3f origin, Vector3f dir, Tuple3f intersection) {
        float tfar = Float.POSITIVE_INFINITY;
        float tnear = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < hull.slabs.length) {
            float vd = hull.slabs[i].getNormal().dot(dir);
            float vn = hull.slabs[i].distanceTo(origin);
            if (Math.abs(vd) < 1.0E-5f) {
                return !(vn > 0.0f);
            }
            float t = -vn / vd;
            if (vd < 0.0f) {
                if (t > tfar) {
                    return false;
                }
                if (t > tnear) {
                    tnear = t;
                }
            } else {
                if (t < tnear) {
                    return false;
                }
                if (t < tfar) {
                    tfar = t;
                }
            }
            ++i;
        }
        float tresult = 0.0f;
        if (tnear >= 0.0f) {
            tresult = tnear;
        } else if (tfar >= 0.0f) {
            tresult = tfar;
        } else {
            return false;
        }
        if (intersection != null) {
            intersection.scaleAdd(tresult, dir, origin);
        }
        return true;
    }

    public static boolean convexHullIntersectsRay(ConvexHull hull, Ray3f ray, Tuple3f intersection) {
        return IntersectionFactory.convexHullIntersectsRay(hull, ray.getOrigin(), ray.getDirection(), intersection);
    }
}

