/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.pooling.ObjectPool;
import org.openmali.spatial.bodies.Line;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.FloatUtils;

public final class Plane
implements Externalizable {
    private static final long serialVersionUID = 9114612905166638720L;
    private static final ObjectPool<Plane> POOL = new ObjectPool<Plane>(32){

        @Override
        protected Plane newInstance() {
            return new Plane();
        }
    };
    private static final float EPSILON = 1.0E-6f;
    private final Vector3f normal = new Vector3f();
    private float nx;
    private float ny;
    private float nz;
    private float d = 0.0f;

    public void setNormal(Vector3f normal) {
        this.nx = normal.getX();
        this.ny = normal.getY();
        this.nz = normal.getZ();
        this.normalize();
    }

    public final Vector3f getNormal() {
        this.normal.set(this.nx, this.ny, this.nz);
        return this.normal;
    }

    public void setA(float a) {
        this.nx = a;
        this.normalize();
    }

    public final float getA() {
        return this.nx;
    }

    public final float getNX() {
        return this.nx;
    }

    public void setB(float b) {
        this.ny = b;
        this.normalize();
    }

    public final float getB() {
        return this.ny;
    }

    public final float getNY() {
        return this.ny;
    }

    public void setC(float c) {
        this.nz = c;
        this.normalize();
    }

    public final float getC() {
        return this.nz;
    }

    public final float getNZ() {
        return this.nz;
    }

    public void setD(float d) {
        this.d = d;
        this.normalize();
    }

    public final float getD() {
        return this.d;
    }

    public final float distanceTo(float x, float y, float z) {
        return this.nx * x + this.ny * y + this.nz * z + this.d;
    }

    public final float distanceTo(Tuple3f v) {
        return this.distanceTo(v.getX(), v.getY(), v.getZ());
    }

    public boolean intersects(Plane rkPlane1, Line rkLine) {
        float fN00 = FloatUtils.vectorLengthSquared(this.nx, this.ny, this.nz);
        float fN01 = FloatUtils.dot(this.nx, this.ny, this.nz, rkPlane1.nx, rkPlane1.ny, rkPlane1.nz);
        float fN11 = FloatUtils.vectorLengthSquared(rkPlane1.nx, rkPlane1.ny, rkPlane1.nz);
        float fDet = fN00 * fN11 - fN01 * fN01;
        if (Math.abs(fDet) < 1.0E-6f) {
            return false;
        }
        float fInvDet = 1.0f / fDet;
        float fC0 = (fN11 * this.d - fN01 * rkPlane1.d) * fInvDet;
        float fC1 = (fN00 * rkPlane1.d - fN01 * this.d) * fInvDet;
        FloatUtils.cross(this.nx, this.ny, this.nz, rkPlane1.nx, rkPlane1.ny, rkPlane1.nz, rkLine.getDirection());
        rkLine.getOrigin().set(this.nx * fC0, this.ny * fC0, this.nz * fC0);
        rkLine.getOrigin().add(rkPlane1.nx * fC1, rkPlane1.ny * fC1, rkPlane1.nz * fC1);
        return true;
    }

    public float rayIntersectionParametric(Point3f rayOrigin, Vector3f dir, Tuple3f intersection) {
        if (Math.abs(dir.dot(this.getNormal())) < 1.0E-6f) {
            return Float.NaN;
        }
        float t = -this.distanceTo(rayOrigin) / this.getNormal().dot(dir);
        if (intersection != null) {
            intersection.scaleAdd(t, dir, rayOrigin);
        }
        return t;
    }

    public float rayIntersectionParametric(Ray3f ray, Tuple3f intersection) {
        return this.rayIntersectionParametric(ray.getOrigin(), ray.getDirection(), intersection);
    }

    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        return this.rayIntersectionParametric(rayOrigin, rayDirection, intersection) >= 0.0f;
    }

    public boolean intersects(Ray3f ray, Tuple3f intersection) {
        return this.intersects(ray.getOrigin(), ray.getDirection(), intersection);
    }

    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return this.intersects(rayOrigin, rayDirection, null);
    }

    public boolean intersects(Ray3f ray) {
        return this.intersects(ray, null);
    }

    public boolean segmentIntersection(Point3f from, Point3f to, Tuple3f intersect) {
        Vector3f dir = Vector3f.fromPool();
        dir.sub(to, from);
        float t = this.rayIntersectionParametric(from, dir, intersect);
        Vector3f.toPool(dir);
        return Math.abs(t) <= 1.0f;
    }

    public float intersectsSegment(Tuple3f va, Tuple3f vb, Tuple3f intersection) {
        float da = va.getX() * this.nx + va.getY() * this.ny + va.getZ() * this.nz + this.d;
        float db = vb.getX() * this.nx + vb.getY() * this.ny + vb.getZ() * this.nz + this.d;
        if (da <= 0.0f && db >= 0.0f) {
            float s = da / (da - db);
            if (intersection != null) {
                intersection.setX(va.getX() + s * (vb.getX() - va.getX()));
                intersection.setY(va.getY() + s * (vb.getY() - va.getY()));
                intersection.setZ(va.getZ() + s * (vb.getZ() - va.getZ()));
            }
            return Math.abs(da);
        }
        if (db <= 0.0f && da >= 0.0f) {
            float s = da / (da - db);
            if (intersection != null) {
                intersection.setX(va.getX() + s * (vb.getX() - va.getX()));
                intersection.setY(va.getY() + s * (vb.getY() - va.getY()));
                intersection.setZ(va.getZ() + s * (vb.getZ() - va.getZ()));
            }
            return Math.abs(da);
        }
        return Float.NEGATIVE_INFINITY;
    }

    public boolean intersects(Plane rkPlane1) {
        float crossX = this.ny * rkPlane1.nz - this.nz * rkPlane1.ny;
        float crossY = this.nz * rkPlane1.nx - this.nx * rkPlane1.nz;
        float crossZ = this.nx * rkPlane1.ny - this.ny * rkPlane1.nx;
        float length_sq = FloatUtils.vectorLengthSquared(crossX, crossY, crossZ);
        return length_sq > 1.0E-6f;
    }

    public Plane normalize() {
        float t = FloatUtils.vectorLength(this.nx, this.ny, this.nz);
        this.nx /= t;
        this.ny /= t;
        this.nz /= t;
        this.d /= t;
        return this;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nx = in.readFloat();
        this.ny = in.readFloat();
        this.nz = in.readFloat();
        this.d = in.readFloat();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.nx);
        out.writeFloat(this.ny);
        out.writeFloat(this.nz);
        out.writeFloat(this.d);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getSimpleName());
        sb.append(" { A:");
        sb.append(this.nx);
        sb.append(", B:");
        sb.append(this.ny);
        sb.append(", C:");
        sb.append(this.nz);
        sb.append(", D:");
        sb.append(this.d);
        sb.append(" }");
        return sb.toString();
    }

    public void set(float a, float b, float c, float d) {
        this.nx = a;
        this.ny = b;
        this.nz = c;
        this.d = d;
        this.normalize();
    }

    public void set(Plane plane) {
        this.nx = plane.nx;
        this.ny = plane.ny;
        this.nz = plane.nz;
        this.d = plane.d;
    }

    public Plane(float a, float b, float c, float d) {
        this.nx = a;
        this.ny = b;
        this.nz = c;
        this.d = d;
        this.normalize();
    }

    public Plane(Vector3f normal, float d) {
        this(normal.getX(), normal.getY(), normal.getZ(), d);
    }

    public Plane(Plane plane) {
        this(plane.nx, plane.ny, plane.nz, plane.d);
    }

    public Plane() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public static final Plane fromPool() {
        return POOL.alloc();
    }

    public static final void toPool(Plane plane) {
        POOL.free(plane);
    }
}

