/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.quadtree;

import org.openmali.spatial.PlaneIndicator;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;

class BoundsHelper {
    BoundsHelper() {
    }

    public static final float getMinX(PlaneIndicator plane, Bounds bounds, BoundsType type) {
        if (plane == PlaneIndicator.X_Z_PLANE || plane == PlaneIndicator.X_Y_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getLowerX();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterX() - ((BoundingSphere)bounds).getRadius();
            }
        } else if (plane == PlaneIndicator.Z_Y_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getLowerZ();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterZ() - ((BoundingSphere)bounds).getRadius();
            }
        }
        return 0.0f;
    }

    public static final float getMinDepth(PlaneIndicator plane, Bounds bounds, BoundsType type) {
        if (plane == PlaneIndicator.X_Z_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getLowerZ();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterZ() - ((BoundingSphere)bounds).getRadius();
            }
        } else if (plane == PlaneIndicator.X_Y_PLANE || plane == PlaneIndicator.Z_Y_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getLowerY();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterY() - ((BoundingSphere)bounds).getRadius();
            }
        }
        return 0.0f;
    }

    public static final float getMaxX(PlaneIndicator plane, Bounds bounds, BoundsType type) {
        if (plane == PlaneIndicator.X_Z_PLANE || plane == PlaneIndicator.X_Y_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getUpperX();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterX() + ((BoundingSphere)bounds).getRadius();
            }
        } else if (plane == PlaneIndicator.Z_Y_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getUpperZ();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterZ() + ((BoundingSphere)bounds).getRadius();
            }
        }
        return 0.0f;
    }

    public static final float getMaxDepth(PlaneIndicator plane, Bounds bounds, BoundsType type) {
        if (plane == PlaneIndicator.X_Z_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getUpperZ();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterZ() + ((BoundingSphere)bounds).getRadius();
            }
        } else if (plane == PlaneIndicator.X_Y_PLANE || plane == PlaneIndicator.Z_Y_PLANE) {
            if (type == BoundsType.AABB) {
                return ((BoundingBox)bounds).getUpperY();
            }
            if (type == BoundsType.SPHERE) {
                return ((BoundingSphere)bounds).getCenterY() + ((BoundingSphere)bounds).getRadius();
            }
        }
        return 0.0f;
    }
}

