/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.openmali.FastMath;
import org.openmali.decomposition.CholeskyDecomposition;
import org.openmali.decomposition.LUDecomposition;
import org.openmali.decomposition.QRDecomposition;
import org.openmali.decomposition.SingularValueDecomposition;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.SubMatrix3f;
import org.openmali.vecmath2.SubMatrix4f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.VectorInterface;
import org.openmali.vecmath2.VectorNf;
import org.openmali.vecmath2.util.SerializationUtils;
import org.openmali.vecmath2.util.VecMathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixMxNf
implements Cloneable {
    protected final float[] values;
    private final int rows;
    private final int cols;
    protected final int dataBegin;
    protected final int colSkip;
    protected final int roTrick;
    protected final boolean[] isDirty;
    private MatrixMxNf readOnlyInstance = null;
    private MatrixMxNf TEMP_MAT = null;
    private VectorNf TEMP_VEC1 = null;
    private VectorNf TEMP_VEC2 = null;
    private VectorNf TEMP_VEC3 = null;
    private final StringBuffer tmpSB = new StringBuffer();

    public final int getNumRows() {
        return this.rows;
    }

    public final int getNumCols() {
        return this.cols;
    }

    public final boolean isSquare() {
        return this.getNumRows() == this.getNumCols();
    }

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        if (this.isReadOnly()) {
            throw new Error("This instance is read-only.");
        }
        boolean oldValue = this.isDirty[0];
        this.isDirty[0] = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty[0];
    }

    public final boolean isSubMatrix() {
        return this.dataBegin != 0 || this.colSkip != this.cols;
    }

    public final MatrixMxNf set(int row, int column, float value) {
        this.values[this.roTrick + this.dataBegin + row * this.colSkip + column] = value;
        this.isDirty[0] = true;
        return this;
    }

    protected final MatrixMxNf set(int row, int colSkip, int column, float value) {
        this.values[this.roTrick + this.dataBegin + row * colSkip + column] = value;
        this.isDirty[0] = true;
        return this;
    }

    public final float get(int row, int column) {
        return this.values[this.dataBegin + row * this.colSkip + column];
    }

    protected final float get(int row, int colSkip, int column) {
        return this.values[this.dataBegin + row * colSkip + column];
    }

    public final MatrixMxNf add(int row, int column, float summand) {
        int n = this.roTrick + this.dataBegin + row * this.colSkip + column;
        this.values[n] = this.values[n] + summand;
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf sub(int row, int column, float value) {
        int n = this.roTrick + this.dataBegin + row * this.colSkip + column;
        this.values[n] = this.values[n] - value;
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf mul(int row, int column, float factor) {
        int n = this.roTrick + this.dataBegin + row * this.colSkip + column;
        this.values[n] = this.values[n] * factor;
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf div(int row, int column, float divisor) {
        int n = this.roTrick + this.dataBegin + row * this.colSkip + column;
        this.values[n] = this.values[n] / divisor;
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf setRow(int row, float[] values) {
        System.arraycopy(values, 0, this.values, this.roTrick + this.dataBegin + row * this.colSkip, this.cols);
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf setRow(int row, TupleNf<?> tuple) {
        int i = 0;
        while (i < this.cols) {
            this.set(row, i, tuple.getValue(i));
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final void getRow(int row, float[] buffer) {
        System.arraycopy(this.values, this.dataBegin + row * this.colSkip, buffer, 0, this.cols);
    }

    public final void getRow(int row, TupleNf<?> tuple) {
        int i = 0;
        while (i < this.cols) {
            tuple.setValue(i, this.get(row, i));
            ++i;
        }
    }

    public final MatrixMxNf setColumn(int col, float[] values) {
        int i = 0;
        while (i < this.rows) {
            this.set(i, col, values[i]);
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf setColumn(int col, TupleNf<?> tuple) {
        int i = 0;
        while (i < this.rows) {
            this.set(i, col, tuple.getValue(i));
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final void getColumn(int col, float[] buffer) {
        int i = 0;
        while (i < this.rows) {
            buffer[i] = this.get(i, col);
            ++i;
        }
    }

    public final void getColumn(int col, TupleNf<?> tuple) {
        int i = 0;
        while (i < this.rows) {
            tuple.setValue(i, this.get(i, col));
            ++i;
        }
    }

    public final void setRowMajor(float[] values, int offset) {
        if (!this.isSubMatrix()) {
            System.arraycopy(values, offset, this.values, this.roTrick + 0, this.rows * this.cols);
        } else {
            int r = 0;
            while (r < this.rows) {
                System.arraycopy(values, offset + r * this.cols, this.values, this.roTrick + this.dataBegin + r * this.colSkip, this.cols);
                ++r;
            }
        }
        this.isDirty[0] = true;
    }

    public final void setRowMajor(float[] values) {
        this.setRowMajor(values, 0);
    }

    public final void setColumnMajor(float[] values, int offset) {
        int i = 0;
        int c = 0;
        while (c < this.getNumCols()) {
            int r = 0;
            while (r < this.getNumRows()) {
                this.set(r, c, values[offset + i++]);
                ++r;
            }
            ++c;
        }
        this.isDirty[0] = true;
    }

    public final void setColumnMajor(float[] values) {
        this.setColumnMajor(values, 0);
    }

    public void set(Matrix3f mat) {
        this.values[this.roTrick + this.dataBegin + 0] = mat.m00();
        this.values[this.roTrick + this.dataBegin + 1] = mat.m01();
        this.values[this.roTrick + this.dataBegin + 2] = mat.m02();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 0] = mat.m10();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 1] = mat.m11();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 2] = mat.m12();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 0] = mat.m20();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 1] = mat.m21();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 2] = mat.m22();
        this.isDirty[0] = true;
    }

    public final void set(Matrix4f mat) {
        this.values[this.roTrick + this.dataBegin + 0] = mat.m00();
        this.values[this.roTrick + this.dataBegin + 1] = mat.m01();
        this.values[this.roTrick + this.dataBegin + 2] = mat.m02();
        this.values[this.roTrick + this.dataBegin + 3] = mat.m03();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 0] = mat.m10();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 1] = mat.m11();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 2] = mat.m12();
        this.values[this.roTrick + this.dataBegin + this.colSkip + 3] = mat.m13();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 0] = mat.m20();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 1] = mat.m21();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 2] = mat.m22();
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 3] = mat.m23();
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 0] = mat.m30();
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 1] = mat.m31();
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 2] = mat.m32();
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 3] = mat.m33();
        this.isDirty[0] = true;
    }

    public final void set(MatrixMxNf mat) {
        if (mat.getNumRows() < this.getNumRows() || mat.getNumCols() < this.getNumCols()) {
            throw new ArrayIndexOutOfBoundsException("mat smaller than this matrix");
        }
        if (!this.isSubMatrix()) {
            System.arraycopy(mat.values, 0, this.values, this.roTrick + 0, this.rows * this.cols);
        } else {
            int r = 0;
            while (r < this.rows) {
                System.arraycopy(mat.values, mat.dataBegin + r * mat.colSkip, this.values, this.roTrick + this.dataBegin + r * this.colSkip, this.cols);
                ++r;
            }
        }
        this.isDirty[0] = true;
    }

    public final void getRowMajor(float[] values, int offset) {
        if (!this.isSubMatrix()) {
            System.arraycopy(this.values, 0, values, offset, this.rows * this.cols);
        } else {
            int r = 0;
            while (r < this.rows) {
                System.arraycopy(this.values, this.dataBegin + r * this.colSkip, values, offset + r * this.cols, this.cols);
                ++r;
            }
        }
    }

    public final void getRowMajor(float[] values) {
        this.getRowMajor(values, 0);
    }

    public final void getColumnMajor(float[] values, int offset) {
        int i = 0;
        int c = 0;
        while (c < this.getNumCols()) {
            int r = 0;
            while (r < this.getNumRows()) {
                values[offset + i++] = this.get(r, c);
                ++r;
            }
            ++c;
        }
    }

    public final void getColumnMajor(float[] values) {
        this.getColumnMajor(values, 0);
    }

    public void get(Matrix3f mat) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                mat.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final void get(Matrix4f mat) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                mat.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final void get(MatrixMxNf mat) {
        if (mat.rows < this.rows || mat.cols < this.cols) {
            throw new IllegalArgumentException("mat matrix is smaller than this matrix.");
        }
        if (mat.colSkip == this.colSkip) {
            System.arraycopy(this.values, this.dataBegin, mat.values, this.dataBegin, this.getNumRows() * this.getNumCols());
        } else {
            int i = 0;
            while (i < this.getNumRows()) {
                System.arraycopy(this.values, this.dataBegin + i * this.colSkip, mat.values, mat.dataBegin + i * mat.colSkip, this.getNumCols());
                ++i;
            }
        }
    }

    public MatrixMxNf setScale(float scale) {
        this.setZero();
        int min = this.rows < this.cols ? this.rows : this.cols;
        int i = 0;
        while (i < min) {
            this.values[this.roTrick + this.dataBegin + i * this.colSkip + i] = scale;
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf setZero() {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, 0.0f);
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf setIdentity() {
        this.setZero();
        int min = this.rows < this.cols ? this.rows : this.cols;
        int i = 0;
        while (i < min) {
            this.set(i, i, 1.0f);
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf negate() {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, -this.get(r, c));
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf negate(MatrixMxNf m) {
        this.set(m);
        this.negate();
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf identityMinus() {
        this.negate();
        int min = this.rows < this.cols ? this.rows : this.cols;
        int i = 0;
        while (i < min) {
            int n = this.roTrick + this.dataBegin + i * this.colSkip + i;
            this.values[n] = (float)((double)this.values[n] + 1.0);
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf invert() {
        if (this.rows != this.cols) {
            throw new ArrayIndexOutOfBoundsException("not a square matrix");
        }
        int n = this.rows;
        if (this.TEMP_MAT == null) {
            this.TEMP_MAT = new MatrixMxNf(this.rows, this.rows);
        }
        if (this.TEMP_VEC1 == null) {
            this.TEMP_VEC1 = new VectorNf(this.rows);
        }
        if (this.TEMP_VEC2 == null) {
            this.TEMP_VEC2 = new VectorNf(this.rows);
        }
        if (this.TEMP_VEC3 == null) {
            this.TEMP_VEC3 = new VectorNf(this.rows);
        }
        MatrixMxNf LU = this.TEMP_MAT;
        VectorNf permutation = this.TEMP_VEC1;
        VectorNf column = this.TEMP_VEC2;
        VectorNf unit = this.TEMP_VEC3;
        this.LUD(LU, permutation);
        int j = 0;
        while (j < n) {
            unit.setZero();
            unit.setValue(j, 1.0f);
            column.LUDBackSolve(LU, unit, permutation);
            this.setColumn(j, column);
            ++j;
        }
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf invert(MatrixMxNf m) {
        this.set(m);
        this.invert();
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf transpose() {
        if (!this.isSquare()) {
            throw new RuntimeException("In-place transpose() only works on square matrices");
        }
        int i = 0;
        while (i < this.rows) {
            int j = i + 1;
            while (j < this.cols) {
                float tmp = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, tmp);
                ++j;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf transpose(MatrixMxNf mat) {
        if (mat.getNumRows() != this.getNumCols() || mat.getNumCols() != this.getNumRows()) {
            throw new IllegalArgumentException("Failed to transpose matrix due to size mismatch. Transposing an MxN matrix requires a destination matrix to be sized NxM");
        }
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, mat.get(c, r));
                ++c;
            }
            ++r;
        }
        return this;
    }

    public float norm1() {
        float f = 0.0f;
        int j = 0;
        while (j < this.getNumCols()) {
            float s = 0.0f;
            int i = 0;
            while (i < this.getNumRows()) {
                s += Math.abs(this.get(i, j));
                ++i;
            }
            f = Math.max(f, s);
            ++j;
        }
        return f;
    }

    public final float norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public float normInfinity() {
        float f = 0.0f;
        int i = 0;
        while (i < this.getNumRows()) {
            float s = 0.0f;
            int j = 0;
            while (j < this.getNumCols()) {
                s += Math.abs(this.get(i, j));
                ++j;
            }
            f = Math.max(f, s);
            ++i;
        }
        return f;
    }

    public float normFrobenius() {
        float f = 0.0f;
        int i = 0;
        while (i < this.getNumRows()) {
            int j = 0;
            while (j < this.getNumCols()) {
                f = FastMath.hypot(f, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return f;
    }

    public boolean isPositiveDefinite(int n) {
        MatrixMxNf upperLeft = this.getNumRows() == n && this.getNumCols() == n ? this : this.getSharedSubMatrix(0, 0, n, n);
        int i = 0;
        while (i < n) {
            upperLeft.set(i, i, upperLeft.get(i, i) * 2.0f);
            int j = 0;
            while (j <= i) {
                float s = upperLeft.get(i, j) + upperLeft.get(j, i);
                upperLeft.set(i, j, s);
                upperLeft.set(j, i, s);
                ++j;
            }
            ++i;
        }
        return new CholeskyDecomposition(upperLeft).isSPD();
    }

    public boolean isPositiveDefinite() {
        if (!this.isSquare()) {
            return false;
        }
        return this.isPositiveDefinite(this.getNumRows());
    }

    public final float trace() {
        int min = this.rows < this.cols ? this.rows : this.cols;
        float trace = 0.0f;
        int i = 0;
        while (i < min) {
            trace += this.values[this.dataBegin + i * this.colSkip + i];
            ++i;
        }
        return trace;
    }

    public final int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public final float cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public final void copySubMatrix(int rowSource, int colSource, int numRows, int numCols, int rowDest, int colDest, MatrixMxNf target) {
        if (rowSource < 0 || colSource < 0 || rowDest < 0 || colDest < 0) {
            throw new ArrayIndexOutOfBoundsException("rowSource, colSource, rowDest, colDest < 0.");
        }
        if (this.rows < numRows + rowSource || this.cols < numCols + colSource) {
            throw new ArrayIndexOutOfBoundsException("Source Matrix too small.");
        }
        if (target.rows < numRows + rowDest || target.cols < numCols + colDest) {
            throw new ArrayIndexOutOfBoundsException("Target Matrix too small.");
        }
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                target.set(i + rowDest, j + colDest, this.get(i + rowSource, j + colSource));
                ++j;
            }
            ++i;
        }
    }

    public final MatrixMxNf add(float scalar) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] + scalar;
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf add(MatrixMxNf m2) {
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m2.rows + "x" + m2.cols + ").");
        }
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] + m2.get(r, c);
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf add(MatrixMxNf m1, MatrixMxNf m2) {
        if (this.rows != m1.rows || this.cols != m1.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m1.rows + "x" + m1.cols + ").");
        }
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m2:(" + m2.rows + "x" + m2.cols + ").");
        }
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, m1.get(r, c) + m2.get(r, c));
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf sub(float scalar) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] - scalar;
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf sub(MatrixMxNf m2) {
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m2.rows + "x" + m2.cols + ").");
        }
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] - m2.get(r, c);
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf sub(MatrixMxNf m1, MatrixMxNf m2) {
        if (this.rows != m1.rows || this.cols != m1.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m1:(" + m1.rows + "x" + m1.cols + ").");
        }
        if (this.rows != m2.rows || this.cols != m2.cols) {
            throw new IllegalArgumentException("this:(" + this.rows + "x" + this.cols + ") != m2:(" + m2.rows + "x" + m2.cols + ").");
        }
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, m1.get(r, c) - m2.get(r, c));
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mul(float scalar) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] * scalar;
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mul(MatrixMxNf m1, MatrixMxNf m2) {
        if (this.rows != m1.rows) {
            throw new ArrayIndexOutOfBoundsException("rows:" + this.rows + " != m1.rows:" + m1.rows);
        }
        if (this.cols != m2.cols) {
            throw new ArrayIndexOutOfBoundsException("cols:" + this.cols + " != m2.cols:" + m2.cols);
        }
        if (m1.cols != m2.rows) {
            throw new ArrayIndexOutOfBoundsException("m1.cols:" + m1.cols + " != m2.rows:" + m2.rows);
        }
        float[] newData = new float[this.cols * this.rows];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                float sum = 0.0f;
                int k = 0;
                while (k < m1.cols) {
                    sum += m1.get(i, k) * m2.get(k, j);
                    ++k;
                }
                newData[i * this.cols + j] = sum;
                ++j;
            }
            ++i;
        }
        this.setRowMajor(newData);
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mul(MatrixMxNf mat2) {
        this.mul(this, mat2);
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf mulComp(MatrixMxNf m1, MatrixMxNf m2) {
        if (this.rows != m1.rows || this.rows != m2.rows) {
            throw new ArrayIndexOutOfBoundsException("rows:" + this.rows + " != m1.rows:" + m1.rows);
        }
        if (this.cols != m1.cols || this.cols != m2.cols) {
            throw new ArrayIndexOutOfBoundsException("cols:" + this.cols + " != m2.cols:" + m2.cols);
        }
        int i = 0;
        while (i < this.getNumRows()) {
            int j = 0;
            while (j < this.getNumCols()) {
                this.set(i, j, m1.get(i, j) * m2.get(i, j));
                ++j;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final MatrixMxNf mulComp(MatrixMxNf mat2) {
        this.mulComp(this, mat2);
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mul(TupleNf<?> v1, TupleNf<?> v2) {
        if (this.rows < v1.getSize()) {
            throw new IllegalArgumentException("rows:" + this.rows + " < v1.getSize():" + v1.getSize());
        }
        if (this.cols < v2.getSize()) {
            throw new IllegalArgumentException("cols:" + this.cols + " < v2.getSize():" + v2.getSize());
        }
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.set(i, j, v1.getValue(i) * v2.getValue(j));
                ++j;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mulTransposeBoth(MatrixMxNf m1, MatrixMxNf m2) {
        this.mul(m2, m1);
        this.transpose();
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mulTransposeLeft(MatrixMxNf m1, MatrixMxNf m2) {
        this.transpose(m1);
        this.mul(m2);
        this.isDirty[0] = true;
        return this;
    }

    public MatrixMxNf mulTransposeRight(MatrixMxNf m1, MatrixMxNf m2) {
        if (m1.cols != m2.cols || this.rows != m1.rows || this.cols != m2.rows) {
            throw new ArrayIndexOutOfBoundsException("matrices mismatch");
        }
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                float sum = 0.0f;
                int k = 0;
                while (k < m1.cols) {
                    sum += m1.get(i, k) * m2.get(j, k);
                    ++k;
                }
                this.set(i, j, sum);
                ++j;
            }
            ++i;
        }
        this.isDirty[0] = true;
        return this;
    }

    public final void solve(MatrixMxNf m2, MatrixMxNf result) {
        if (this.isSquare()) {
            result.set(new LUDecomposition(this).solve(m2));
        } else {
            new QRDecomposition(this).solve(m2, result);
        }
    }

    public boolean solve(TupleNf<?> b, TupleNf<?> passback) {
        if (!this.isSquare()) {
            throw new Error("This matrix must be a square matrix.");
        }
        int N = b.getSize();
        if (N != this.getNumCols()) {
            return false;
        }
        TupleNf tmp = (TupleNf)((Object)VecMathUtils.getVectorFromPool(N));
        TupleNf maxRow = (TupleNf)((Object)VecMathUtils.getVectorFromPool(N));
        int p = 0;
        while (p < N) {
            int max = p;
            int i = p + 1;
            while (i < N) {
                if (Math.abs(this.get(i, p)) > Math.abs(this.get(max, p))) {
                    max = i;
                }
                ++i;
            }
            this.getRow(max, maxRow);
            this.getRow(p, tmp);
            this.setRow(p, maxRow);
            this.setRow(max, tmp);
            float t = b.getValue(p);
            b.setValue(p, b.getValue(max));
            b.setValue(max, t);
            if (this.get(p, p) == 0.0f) {
                VecMathUtils.putVectorToPool((VectorInterface)((Object)maxRow));
                VecMathUtils.putVectorToPool((VectorInterface)((Object)tmp));
                return false;
            }
            int i2 = p + 1;
            while (i2 < N) {
                float alpha = this.get(i2, p) / this.get(p, p);
                b.subValue(i2, alpha * b.getValue(p));
                int j = p;
                while (j < N) {
                    this.set(i2, j, this.get(i2, j) - alpha * this.get(p, j));
                    ++j;
                }
                ++i2;
            }
            ++p;
        }
        int i = N - 1;
        while (i >= 0) {
            float sum = 0.0f;
            int j = i + 1;
            while (j < N) {
                sum += this.get(i, j) * passback.getValue(j);
                ++j;
            }
            passback.setValue(i, (b.getValue(i) - sum) / this.get(i, i));
            --i;
        }
        VecMathUtils.putVectorToPool((VectorInterface)((Object)maxRow));
        VecMathUtils.putVectorToPool((VectorInterface)((Object)tmp));
        return true;
    }

    private final void setDiag(int i, float value) {
        this.values[this.roTrick + this.dataBegin + i * this.colSkip + i] = value;
    }

    private final float getDiag(int i) {
        return this.values[this.dataBegin + i * this.colSkip + i];
    }

    private final float dpythag(float a, float b) {
        float absb;
        float absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            if (absa == 0.0f) {
                return 0.0f;
            }
            float term = absb / absa;
            if (Math.abs(term) <= Float.MIN_VALUE) {
                return absa;
            }
            return absa * FastMath.sqrt(1.0f + term * term);
        }
        if (absb == 0.0f) {
            return 0.0f;
        }
        float term = absa / absb;
        if (Math.abs(term) <= Float.MIN_VALUE) {
            return absb;
        }
        return absb * FastMath.sqrt(1.0f + term * term);
    }

    public int SVD(MatrixMxNf u, MatrixMxNf w, MatrixMxNf v) {
        float h;
        float f;
        int k;
        float s;
        int j;
        if (u.rows != this.rows || u.cols != this.rows) {
            throw new ArrayIndexOutOfBoundsException("The U Matrix invalid size");
        }
        if (v.rows != this.cols || v.cols != this.cols) {
            throw new ArrayIndexOutOfBoundsException("The V Matrix invalid size");
        }
        if (w.cols != this.cols || w.rows != this.rows) {
            throw new ArrayIndexOutOfBoundsException("The W Matrix invalid size");
        }
        int m = this.rows;
        int n = this.cols;
        int imax = m > n ? m : n;
        float[] U = u.values;
        float[] V = v.values;
        int l = 0;
        int nm = 0;
        float[] rv1 = new float[n];
        this.get(u);
        int i = m;
        while (i < imax) {
            j = 0;
            while (j < imax) {
                U[u.roTrick + i * m + j] = 0.0f;
                ++j;
            }
            ++i;
        }
        j = n;
        while (j < imax) {
            i = 0;
            while (i < imax) {
                U[u.roTrick + i * m + j] = 0.0f;
                ++i;
            }
            ++j;
        }
        u.isDirty[0] = true;
        w.setZero();
        float anorm = 0.0f;
        float scale = 0.0f;
        float g = 0.0f;
        i = 0;
        while (i < n) {
            float a1;
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0f;
            s = 0.0f;
            g = 0.0f;
            if (i < m) {
                k = i;
                while (k < m) {
                    scale += Math.abs(U[k * m + i]);
                    ++k;
                }
                if (scale != 0.0f) {
                    k = i;
                    while (k < m) {
                        int n2 = u.roTrick + k * m + i;
                        U[n2] = U[n2] / scale;
                        s += U[k * m + i] * U[k * m + i];
                        ++k;
                    }
                    f = U[i * m + i];
                    g = f < 0.0f ? FastMath.sqrt(s) : -FastMath.sqrt(s);
                    h = f * g - s;
                    U[u.roTrick + i * m + i] = f - g;
                    j = l;
                    while (j < n) {
                        s = 0.0f;
                        k = i;
                        while (k < m) {
                            s += U[k * m + i] * U[k * m + j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < m) {
                            int n3 = u.roTrick + k * m + j;
                            U[n3] = U[n3] + f * U[k * m + i];
                            ++k;
                        }
                        ++j;
                    }
                    k = i;
                    while (k < m) {
                        int n4 = u.roTrick + k * m + i;
                        U[n4] = U[n4] * scale;
                        ++k;
                    }
                }
            }
            w.setDiag(i, scale * g);
            scale = 0.0f;
            s = 0.0f;
            g = 0.0f;
            if (i < m && i != n - 1) {
                k = l;
                while (k < n) {
                    scale += Math.abs(U[i * m + k]);
                    ++k;
                }
                if (scale != 0.0f) {
                    k = l;
                    while (k < n) {
                        int n5 = u.roTrick + i * m + k;
                        U[n5] = U[n5] / scale;
                        s += U[i * m + k] * U[i * m + k];
                        ++k;
                    }
                    f = U[i * m + l];
                    g = f < 0.0f ? FastMath.sqrt(s) : -FastMath.sqrt(s);
                    h = f * g - s;
                    U[u.roTrick + i * m + l] = f - g;
                    k = l;
                    while (k < n) {
                        rv1[k] = U[i * m + k] / h;
                        ++k;
                    }
                    j = l;
                    while (j < m) {
                        s = 0.0f;
                        k = l;
                        while (k < n) {
                            s += U[j * m + k] * U[i * m + k];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            int n6 = u.roTrick + j * m + k;
                            U[n6] = U[n6] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k = l;
                    while (k < n) {
                        int n7 = u.roTrick + i * m + k;
                        U[n7] = U[n7] * scale;
                        ++k;
                    }
                }
            }
            if ((a1 = Math.abs(w.getDiag(i)) + Math.abs(rv1[i])) > anorm) {
                anorm = a1;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0f) {
                    j = l;
                    while (j < n) {
                        V[v.roTrick + j * n + i] = U[i * m + j] / U[i * m + l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0f;
                        k = l;
                        while (k < n) {
                            s += U[i * m + k] * V[k * n + j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            int n8 = v.roTrick + k * n + j;
                            V[n8] = V[n8] + s * V[k * n + i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    V[j * n + i] = 0.0f;
                    V[v.roTrick + i * n + j] = 0.0f;
                    ++j;
                }
            }
            V[v.roTrick + i * n + i] = 1.0f;
            g = rv1[i];
            l = i--;
        }
        v.isDirty[0] = true;
        int imin = m < n ? m : n;
        i = imin - 1;
        while (i >= 0) {
            l = i + 1;
            g = w.getDiag(i);
            j = l;
            while (j < n) {
                U[u.roTrick + i * m + j] = 0.0f;
                ++j;
            }
            if (g != 0.0f) {
                g = 1.0f / g;
                j = l;
                while (j < n) {
                    s = 0.0f;
                    k = l;
                    while (k < m) {
                        s += U[k * m + i] * U[k * m + j];
                        ++k;
                    }
                    f = s / U[i * m + i] * g;
                    k = i;
                    while (k < m) {
                        int n9 = u.roTrick + k * m + j;
                        U[n9] = U[n9] + f * U[k * m + i];
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < m) {
                    int n10 = u.roTrick + j * m + i;
                    U[n10] = U[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    U[u.roTrick + j * m + i] = 0.0f;
                    ++j;
                }
            }
            int n11 = u.roTrick + i * m + i;
            U[n11] = U[n11] + 1.0f;
            --i;
        }
        k = n - 1;
        while (k >= 0) {
            int its = 1;
            while (its <= 30) {
                float z;
                float y;
                float c;
                boolean flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w.getDiag(nm)) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0f;
                    s = 1.0f;
                    i = l;
                    while (i <= k) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w.getDiag(i);
                        h = this.dpythag(f, g);
                        w.setDiag(i, h);
                        h = 1.0f / h;
                        c = g * h;
                        s = -f * h;
                        j = 0;
                        while (j < m) {
                            y = U[j * m + nm];
                            z = U[j * m + i];
                            U[u.roTrick + j * m + nm] = y * c + z * s;
                            U[u.roTrick + j * m + i] = z * c - y * s;
                            ++j;
                        }
                        ++i;
                    }
                }
                z = w.getDiag(k);
                if (l == k) {
                    if (!(z < 0.0f)) break;
                    w.setDiag(k, -z);
                    j = 0;
                    while (j < n) {
                        V[v.roTrick + j * n + k] = -V[j * n + k];
                        ++j;
                    }
                    break;
                }
                if ((float)its == 30.0f) {
                    return 0;
                }
                float x = w.getDiag(l);
                nm = k - 1;
                y = w.getDiag(nm);
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0f * h * y);
                g = this.dpythag(f, 1.0f);
                f = ((x - z) * (x + z) + h * (y / (f + (f >= 0.0f ? Math.abs(g) : -Math.abs(g))) - h)) / x;
                s = 1.0f;
                c = 1.0f;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w.getDiag(i);
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = this.dpythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < n) {
                        x = V[jj * n + j];
                        z = V[jj * n + i];
                        V[v.roTrick + jj * n + j] = x * c + z * s;
                        V[v.roTrick + jj * n + i] = z * c - x * s;
                        ++jj;
                    }
                    z = this.dpythag(f, h);
                    w.setDiag(j, z);
                    if (z != 0.0f) {
                        z = 1.0f / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < m) {
                        y = U[jj * m + j];
                        z = U[jj * m + i];
                        U[u.roTrick + jj * m + j] = y * c + z * s;
                        U[u.roTrick + jj * m + i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0f;
                rv1[k] = f;
                w.setDiag(k, x);
                ++its;
            }
            --k;
        }
        int rank = 0;
        i = 0;
        while (i < n) {
            if (w.getDiag(i) > 0.0f) {
                ++rank;
            }
            ++i;
        }
        return rank;
    }

    private final void swapRows(int i, int j) {
        int k = 0;
        while (k < this.cols) {
            float tmp = this.values[this.dataBegin + i * this.colSkip + k];
            this.values[this.roTrick + this.dataBegin + i * this.colSkip + k] = this.values[this.dataBegin + j * this.colSkip + k];
            this.values[this.roTrick + this.dataBegin + j * this.colSkip + k] = tmp;
            ++k;
        }
    }

    public int LUD(MatrixMxNf lu, VectorNf permutation) {
        if (this.rows != this.cols) {
            throw new ArrayIndexOutOfBoundsException("not a square matrix");
        }
        int n = this.rows;
        if (n != lu.rows) {
            throw new ArrayIndexOutOfBoundsException("this.nRow:" + n + " != LU.nRow:" + lu.rows);
        }
        if (n != lu.cols) {
            throw new ArrayIndexOutOfBoundsException("this.nCol:" + n + " != LU.nCol:" + lu.cols);
        }
        if (permutation.getSize() < n) {
            throw new ArrayIndexOutOfBoundsException("permutation.size:" + permutation.getSize() + " < this.nCol:" + n);
        }
        if (this != lu) {
            lu.set(this);
        }
        float[] a = lu.values;
        int even = 1;
        int i = 0;
        while (i < n) {
            permutation.setValue(i, i);
            ++i;
        }
        int j = 0;
        while (j < n) {
            float dum;
            int k;
            float sum;
            int i2 = 0;
            while (i2 < j) {
                sum = a[i2 * n + j];
                k = 0;
                while (k < i2) {
                    if (a[i2 * n + k] != 0.0f && a[k * n + j] != 0.0f) {
                        sum -= a[i2 * n + k] * a[k * n + j];
                    }
                    ++k;
                }
                a[lu.roTrick + i2 * n + j] = sum;
                ++i2;
            }
            float big = 0.0f;
            int imax = j;
            i2 = j;
            while (i2 < n) {
                sum = a[i2 * n + j];
                k = 0;
                while (k < j) {
                    if (a[i2 * n + k] != 0.0f && a[k * n + j] != 0.0f) {
                        sum -= a[i2 * n + k] * a[k * n + j];
                    }
                    ++k;
                }
                a[lu.roTrick + i2 * n + j] = sum;
                dum = Math.abs(sum);
                if (dum >= big) {
                    big = dum;
                    imax = i2;
                }
                ++i2;
            }
            if (j != imax) {
                lu.swapRows(imax, j);
                float tmp = permutation.getValue(imax);
                permutation.setValue(imax, permutation.getValue(j));
                permutation.setValue(j, tmp);
                even = -even;
            }
            if (j != n - 1) {
                dum = 1.0f / a[j * n + j];
                i = j + 1;
                while (i < n) {
                    int n2 = lu.roTrick + i * n + j;
                    a[n2] = a[n2] * dum;
                    ++i;
                }
            }
            ++j;
        }
        return even;
    }

    public void interpolate(MatrixMxNf m1, MatrixMxNf m2, float alpha) {
        if (m1.getNumCols() != m2.getNumCols() || m1.getNumRows() != m2.getNumRows() || m1.getNumRows() != this.getNumRows() || m1.getNumRows() != this.getNumRows()) {
            throw new IllegalArgumentException("All three matrices must be of tame size");
        }
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, m1.get(r, c) + (m2.get(r, c) - m1.get(r, c)) * alpha);
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
    }

    public int hashCode() {
        int hash = 0;
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                int bits = VecMathUtils.floatToIntBits(this.get(r, c));
                hash ^= bits ^ bits >> 32;
                ++c;
            }
            ++r;
        }
        return hash;
    }

    public boolean equals(MatrixMxNf mat2) {
        if (mat2 == null) {
            return false;
        }
        if (mat2.rows != this.rows) {
            return false;
        }
        if (mat2.cols != this.cols) {
            return false;
        }
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (this.get(i, j) != mat2.get(i, j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof MatrixMxNf && this.equals((MatrixMxNf)o);
    }

    public boolean epsilonEquals(MatrixMxNf mat2, float epsilon) {
        if (mat2.rows != this.rows) {
            return false;
        }
        if (mat2.cols != this.cols) {
            return false;
        }
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (epsilon < Math.abs(this.get(i, j) - mat2.get(i, j))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        this.tmpSB.setLength(0);
        this.tmpSB.append("[");
        this.tmpSB.append(nl);
        int i = 0;
        while (i < this.rows) {
            this.tmpSB.append("  [ ");
            int j = 0;
            while (j < this.cols) {
                int oldLen = this.tmpSB.length();
                this.tmpSB.append(this.get(i, j));
                int dl = this.tmpSB.length() - oldLen;
                if (dl < 16) {
                    int s = dl;
                    while (s < 16) {
                        this.tmpSB.append(" ");
                        ++s;
                    }
                }
                ++j;
            }
            if (i + 1 < this.rows) {
                this.tmpSB.append(" ]");
                this.tmpSB.append(nl);
            } else {
                this.tmpSB.append(" ]");
                this.tmpSB.append(nl);
                this.tmpSB.append("]");
            }
            ++i;
        }
        return this.tmpSB.toString();
    }

    public MatrixMxNf clone() {
        MatrixMxNf obj = new MatrixMxNf(this.rows, this.cols);
        obj.set(this);
        return obj;
    }

    public MatrixMxNf getSharedSubMatrix(boolean readOnly, int beginRow, int beginCol, int rows, int cols) {
        int begin = this.dataBegin + beginCol + beginRow * this.colSkip;
        if (rows == 3 && cols == 3) {
            return new SubMatrix3f(readOnly, begin, this.colSkip, this.values);
        }
        if (rows == 4 && cols == 4) {
            return new SubMatrix4f(readOnly, begin, this.colSkip, this.values);
        }
        return new MatrixMxNf(readOnly, begin, this.colSkip, rows, cols, this.values, null);
    }

    public MatrixMxNf getSharedSubMatrix(int beginRow, int beginCol, int rows, int cols) {
        return this.getSharedSubMatrix(false, beginRow, beginCol, rows, cols);
    }

    public MatrixMxNf asReadOnly() {
        return new MatrixMxNf(true, this.dataBegin, this.colSkip, this.rows, this.cols, this.values, this.isDirty);
    }

    public MatrixMxNf getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    public int serialize(int pos, byte[] buffer) {
        int n = this.rows * this.cols;
        int i = 0;
        while (i < n) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int n = this.rows * this.cols;
        int i = 0;
        while (i < n) {
            this.values[i] = SerializationUtils.readFloatFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty[0] = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 4 * this.rows * this.cols + 1;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected MatrixMxNf(boolean readOnly, int rows, int cols) {
        if (rows < 0) {
            throw new NegativeArraySizeException(String.valueOf(rows) + " < 0");
        }
        if (cols < 0) {
            throw new NegativeArraySizeException(String.valueOf(cols) + " < 0");
        }
        this.rows = rows;
        this.cols = cols;
        this.values = new float[rows * cols];
        this.dataBegin = 0;
        this.colSkip = cols;
        Arrays.fill(this.values, 0.0f);
        int min = rows < cols ? rows : cols;
        int i = 0;
        while (i < min) {
            this.values[this.dataBegin + i * this.colSkip + i] = 1.0f;
            ++i;
        }
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected MatrixMxNf(boolean readOnly, int rows, int cols, float[] values) {
        if (rows < 0) {
            throw new NegativeArraySizeException(String.valueOf(rows) + " < 0");
        }
        if (cols < 0) {
            throw new NegativeArraySizeException(String.valueOf(cols) + " < 0");
        }
        this.rows = rows;
        this.cols = cols;
        this.values = new float[rows * cols];
        this.dataBegin = 0;
        this.colSkip = cols;
        int size = rows * cols;
        System.arraycopy(values, 0, this.values, 0, size);
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected MatrixMxNf(boolean readOnly, MatrixMxNf matrix) {
        this.rows = matrix.rows;
        this.cols = matrix.cols;
        this.dataBegin = 0;
        this.colSkip = this.cols;
        this.values = new float[this.rows * this.cols];
        this.set(matrix);
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
        this.isDirty = new boolean[1];
    }

    protected MatrixMxNf(boolean readOnly, int dataBegin, int colskip, int rows, int cols, float[] values, boolean[] isDirty) {
        this.dataBegin = dataBegin;
        this.colSkip = colskip;
        this.cols = cols;
        this.rows = rows;
        this.values = values;
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
        this.isDirty = isDirty == null ? new boolean[1] : isDirty;
    }

    public MatrixMxNf(int rows, int cols) {
        this(false, rows, cols);
    }

    public MatrixMxNf(int rows, int cols, float[] values) {
        this(false, rows, cols, values);
    }

    public MatrixMxNf(MatrixMxNf matrix) {
        this(false, matrix);
    }

    protected MatrixMxNf(int dataBegin, int colskip, int rows, int cols, float[] values) {
        this(false, dataBegin, colskip, rows, cols, values, null);
    }

    public static MatrixMxNf newReadOnly(int rows, int cols) {
        return new MatrixMxNf(true, rows, cols);
    }

    public static MatrixMxNf newReadOnly(int rows, int cols, float[] values) {
        return new MatrixMxNf(true, rows, cols, values);
    }

    public static MatrixMxNf newReadOnly(MatrixMxNf matrix) {
        return new MatrixMxNf(true, matrix);
    }

    public static MatrixMxNf sharedSubMatrixMxNf(MatrixMxNf mat, int beginRow, int beginCol, int rows, int cols, boolean readOnly) {
        return mat.getSharedSubMatrix(readOnly, beginRow, beginCol, rows, cols);
    }

    public static MatrixMxNf sharedSubMatrixMxNf(MatrixMxNf mat, int beginRow, int beginCol, int rows, int cols) {
        return mat.getSharedSubMatrix(beginRow, beginCol, rows, cols);
    }
}

