/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.pools.Point2iPool;

public class Point2i
extends Tuple2i
implements Externalizable {
    private static final long serialVersionUID = 887936353758486269L;
    public static final Point2i ZERO = Point2i.newReadOnly(0, 0);
    private static final ThreadLocal<Point2iPool> POOL = new ThreadLocal<Point2iPool>(){

        @Override
        protected Point2iPool initialValue() {
            return new Point2iPool(128);
        }
    };
    private Point2i readOnlyInstance = null;

    public Point2i clone() {
        return new Point2i(this);
    }

    public Point2i asReadOnly() {
        return new Point2i(true, this.values, this.isDirty, false);
    }

    public Point2i getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    protected Point2i(boolean readOnly, int x, int y) {
        super(readOnly, x, y);
    }

    protected Point2i(boolean readOnly, int[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, copy);
    }

    protected Point2i(boolean readOnly, Tuple2i tuple) {
        this(readOnly, tuple.getX(), tuple.getY());
    }

    protected Point2i(boolean readOnly) {
        this(readOnly, 0, 0);
    }

    public Point2i(int x, int y) {
        this(false, x, y);
    }

    public Point2i(int[] values) {
        this(false, values, null, true);
    }

    public Point2i(Tuple2i tuple) {
        this(false, tuple);
    }

    public Point2i() {
        this(false);
    }

    public static Point2i newReadOnly(int x, int y) {
        return new Point2i(true, x, y);
    }

    public static Point2i newReadOnly(int[] values) {
        return new Point2i(true, values, null, true);
    }

    public static Point2i newReadOnly(Tuple2i tuple) {
        return new Point2i(true, tuple);
    }

    public static Point2i newReadOnly() {
        return new Point2i(true);
    }

    public static Point2i fromPool() {
        return POOL.get().alloc();
    }

    public static Point2i fromPool(int x, int y) {
        return POOL.get().alloc(x, y);
    }

    public static Point2i fromPool(Tuple2i tuple) {
        return Point2i.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Point2i o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple2i newReadOnly() {
        return Point2i.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple2i newReadOnly(Tuple2i tuple2i) {
        return Point2i.newReadOnly(tuple2i);
    }

    public static /* bridge */ /* synthetic */ Tuple2i newReadOnly(int[] nArray) {
        return Point2i.newReadOnly(nArray);
    }

    public static /* bridge */ /* synthetic */ Tuple2i newReadOnly(int n, int n2) {
        return Point2i.newReadOnly(n, n2);
    }

    public static /* bridge */ /* synthetic */ Tuple2i fromPool(Tuple2i tuple2i) {
        return Point2i.fromPool(tuple2i);
    }

    public static /* bridge */ /* synthetic */ Tuple2i fromPool(int n, int n2) {
        return Point2i.fromPool(n, n2);
    }

    public static /* bridge */ /* synthetic */ Tuple2i fromPool() {
        return Point2i.fromPool();
    }
}

