/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.pools.TexCoord1fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexCoord1f
extends TexCoordf<TexCoord1f>
implements Externalizable {
    private static final long serialVersionUID = -8577168782997168074L;
    private static final ThreadLocal<TexCoord1fPool> POOL = new ThreadLocal<TexCoord1fPool>(){

        @Override
        protected TexCoord1fPool initialValue() {
            return new TexCoord1fPool(128);
        }
    };

    @Override
    public final TexCoord1f set(float s) {
        this.setS(s);
        return this;
    }

    public final TexCoord1f setS(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float getS() {
        return this.values[0];
    }

    public final TexCoord1f s(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float s() {
        return this.values[0];
    }

    public final TexCoord1f addS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f subS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f mulS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f mul(float vs) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vs;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f divS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord1f div(float vs) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vs;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TexCoord1f add(float s) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + s;
        this.isDirty = true;
        return this;
    }

    @Override
    public final TexCoord1f sub(float s) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - s;
        this.isDirty = true;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof TexCoord1f && this.equals((TexCoord1f)o);
    }

    public TexCoord1f clone() {
        return new TexCoord1f(this);
    }

    protected TexCoord1f(boolean readOnly, float s) {
        super(readOnly, new float[]{s});
    }

    protected TexCoord1f(boolean readOnly, float[] values) {
        this(readOnly, values[0]);
    }

    protected TexCoord1f(boolean readOnly, TexCoordf<?> texCoord) {
        super(readOnly, TexCoord1f.newArray(texCoord.values, 1));
    }

    protected TexCoord1f(boolean readOnly) {
        this(readOnly, 0.0f);
    }

    public TexCoord1f(float s) {
        this(false, s);
    }

    public TexCoord1f(float[] values) {
        this(false, values);
    }

    public TexCoord1f(TexCoordf<?> texCoord) {
        this(false, texCoord);
    }

    public TexCoord1f() {
        this(false);
    }

    public static final TexCoord1f newReadOnly(float s) {
        return new TexCoord1f(true, s);
    }

    public static final TexCoord1f newReadOnly(float[] values) {
        return new TexCoord1f(true, values);
    }

    public static final TexCoord1f newReadOnly(TexCoordf<?> texCoord) {
        return new TexCoord1f(true, texCoord);
    }

    public static TexCoord1f fromPool() {
        return POOL.get().alloc();
    }

    public static TexCoord1f fromPool(float s) {
        return POOL.get().alloc(s);
    }

    public static void toPool(TexCoord1f o) {
        POOL.get().free(o);
    }
}

