/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import org.openmali.vecmath2.TupleNi;
import org.openmali.vecmath2.pools.Tuple4iPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple4i
extends TupleNi<Tuple4i> {
    private static final long serialVersionUID = 586023996166921455L;
    private static final ThreadLocal<Tuple4iPool> POOL = new ThreadLocal<Tuple4iPool>(){

        @Override
        protected Tuple4iPool initialValue() {
            return new Tuple4iPool(128);
        }
    };
    private Tuple4i readOnlyInstance = null;

    public final Tuple4i setX(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple4i setY(int y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple4i setZ(int z) {
        this.setValue(2, z);
        return this;
    }

    public final Tuple4i setW(int w) {
        this.setValue(3, w);
        return this;
    }

    public final int getX() {
        return this.getValue(0);
    }

    public final int getY() {
        return this.getValue(1);
    }

    public final int getZ() {
        return this.getValue(2);
    }

    public final int getW() {
        return this.getValue(3);
    }

    public final Tuple4i x(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple4i y(int y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple4i z(int z) {
        this.setValue(2, z);
        return this;
    }

    public final Tuple4i w(int w) {
        this.setValue(3, w);
        return this;
    }

    public final int x() {
        return this.getValue(0);
    }

    public final int y() {
        return this.getValue(1);
    }

    public final int z() {
        return this.getValue(2);
    }

    public final int w() {
        return this.getValue(3);
    }

    public final Tuple4i setValues(int x, int y, int z, int w) {
        this.setValue(0, x);
        this.setValue(1, y);
        this.setValue(2, z);
        this.setValue(3, w);
        return this;
    }

    public final Tuple4i addX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i addY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i addZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i addW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i add(int x, int y, int z, int w) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + z;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] + w;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i subX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i subY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i subZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i subW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i sub(int x, int y, int z, int w) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - z;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] - w;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i mulX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i mulY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i mulZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i mulW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i mul(int vx, int vy, int vz, int vw) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vz;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] * vw;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i divX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i divY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i divZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i divW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i div(int vx, int vy, int vz, int vw) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vz;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] / vw;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple4i scale(int factorX, int factorY, int factorZ, int factorW) {
        this.mul(factorX, factorY, factorZ, factorW);
        return this;
    }

    @Override
    public Tuple4i asReadOnly() {
        return new Tuple4i(true, this.values, this.isDirty, false);
    }

    @Override
    public Tuple4i getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    @Override
    public int hashCode() {
        return this.values[0] ^ this.values[1] ^ this.values[2] ^ this.values[3];
    }

    @Override
    public boolean equals(Tuple4i tuple2) {
        int i = 0;
        while (i < this.N) {
            if (tuple2.getValue(i) != this.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple4i && this.equals((Tuple4i)tuple2);
    }

    @Override
    public String toString() {
        return "(" + this.getValue(0) + ", " + this.getValue(1) + ", " + this.getValue(2) + ", " + this.getValue(3) + ")";
    }

    public Tuple4i clone() {
        return new Tuple4i(this);
    }

    protected Tuple4i(boolean readOnly, int x, int y, int z, int w) {
        super(readOnly, 4);
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
        this.values[3] = w;
    }

    protected Tuple4i(boolean readOnly, int[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, 4, copy);
    }

    protected Tuple4i(boolean readOnly, Tuple4i that) {
        super(readOnly, that);
    }

    protected Tuple4i(boolean readOnly) {
        this(readOnly, 0, 0, 0, 0);
    }

    public Tuple4i(int x, int y, int z, int w) {
        this(false, x, y, z, w);
    }

    public Tuple4i(int[] values) {
        this(false, values, null, true);
    }

    public Tuple4i(Tuple4i that) {
        this(false, that);
    }

    public Tuple4i() {
        this(false, 0, 0, 0, 0);
    }

    public static Tuple4i newReadOnly(int x, int y, int z, int w) {
        return new Tuple4i(true, x, y, z, w);
    }

    public static Tuple4i newReadOnly(int[] values) {
        return new Tuple4i(true, values, null, true);
    }

    public static Tuple4i newReadOnly(Tuple4i tuple) {
        return new Tuple4i(true, tuple);
    }

    public static Tuple4i newReadOnly() {
        return new Tuple4i(true);
    }

    public static Tuple4i fromPool() {
        return POOL.get().alloc();
    }

    public static Tuple4i fromPool(int x, int y, int z, int w) {
        return POOL.get().alloc(x, y, z, w);
    }

    public static Tuple4i fromPool(Tuple4i tuple) {
        return Tuple4i.fromPool(tuple.getX(), tuple.getY(), tuple.getZ(), tuple.getW());
    }

    public static void toPool(Tuple4i o) {
        POOL.get().free(o);
    }
}

