/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.TupleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatUtils {
    public static final float vectorLengthSquared(float vx, float vy, float vz) {
        return vx * vx + vy * vy + vz * vz;
    }

    public static final float vectorLength(float vx, float vy, float vz) {
        return FastMath.sqrt(FloatUtils.vectorLengthSquared(vx, vy, vz));
    }

    public static final float pointsDistanceSquared(float px1, float py1, float pz1, float px2, float py2, float pz2) {
        float result = 0.0f;
        float d = px1 - px2;
        result += d * d;
        d = py1 - py2;
        result += d * d;
        d = pz1 - pz2;
        return result += d * d;
    }

    public static final float pointsDistance(float px1, float py1, float pz1, float px2, float py2, float pz2) {
        return FastMath.sqrt(FloatUtils.pointsDistanceSquared(px1, py1, pz1, px2, py2, pz2));
    }

    public static final float pointsDistanceSquared(Point3f p1, float px2, float py2, float pz2) {
        float result = 0.0f;
        float d = p1.getX() - px2;
        result += d * d;
        d = p1.getY() - py2;
        result += d * d;
        d = p1.getZ() - pz2;
        return result += d * d;
    }

    public static final float pointsDistance(Point3f p1, float px2, float py2, float pz2) {
        return FastMath.sqrt(FloatUtils.pointsDistanceSquared(p1, px2, py2, pz2));
    }

    public static final <T extends Tuple3f> T cross(float v1x, float v1y, float v1z, float v2x, float v2y, float v2z, T result) {
        result.set(v1y * v2z - v1z * v2y, v1z * v2x - v1x * v2z, v1x * v2y - v1y * v2x);
        return result;
    }

    public static final float dot(float v1x, float v1y, float v1z, float v2x, float v2y, float v2z) {
        return v1x * v2x + v1y * v2y + v1z * v2z;
    }

    public static final float angle(float v1x, float v1y, float v1z, float v2x, float v2y, float v2z) {
        float vDot = FloatUtils.dot(v1x, v1y, v1z, v2x, v2y, v2z) / (FloatUtils.vectorLength(v1x, v1y, v1z) * FloatUtils.vectorLength(v2x, v2y, v2z));
        if (vDot < -1.0f) {
            vDot = -1.0f;
        }
        if (vDot > 1.0f) {
            vDot = 1.0f;
        }
        return FastMath.acos(vDot);
    }

    public static final AxisAngle3f computeRotation(float v1x, float v1y, float v1z, float v2x, float v2y, float v2z, int normalize, AxisAngle3f result) {
        Tuple3f t;
        if ((normalize & 3) != 0) {
            t = Tuple3f.fromPool();
            t.set(v1x, v1y, v1z);
            TupleUtils.normalizeVector(t);
            v1x = t.getX();
            v1y = t.getY();
            v1z = t.getZ();
            t.set(v2x, v2y, v2z);
            TupleUtils.normalizeVector(t);
            v2x = t.getX();
            v2y = t.getY();
            v2z = t.getZ();
            Tuple3f.toPool(t);
        } else if ((normalize & 1) != 0) {
            t = Tuple3f.fromPool();
            t.set(v1x, v1y, v1z);
            TupleUtils.normalizeVector(t);
            v1x = t.getX();
            v1y = t.getY();
            v1z = t.getZ();
            Tuple3f.toPool(t);
        } else if ((normalize & 2) != 0) {
            t = Tuple3f.fromPool();
            t.set(v2x, v2y, v2z);
            TupleUtils.normalizeVector(t);
            v2x = t.getX();
            v2y = t.getY();
            v2z = t.getZ();
            Tuple3f.toPool(t);
        }
        FloatUtils.cross(v2x, v2y, v2z, v1x, v1y, v1z, result);
        float angle = FastMath.acos(FloatUtils.dot(v2x, v2y, v2z, v1x, v1y, v1z));
        result.setAngle(angle);
        return result;
    }
}

