/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops;

import java.util.ArrayList;
import java.util.List;
import org.softmed.jops.Particle;
import org.softmed.jops.ParticleBehaviour;
import org.softmed.jops.operators.AlphaOperator;
import org.softmed.jops.operators.AngleOperator;
import org.softmed.jops.operators.BounceOperator;
import org.softmed.jops.operators.ColorOperator;
import org.softmed.jops.operators.HeightOperator;
import org.softmed.jops.operators.MassOperator;
import org.softmed.jops.operators.PAngleHOperator;
import org.softmed.jops.operators.PAngleVOperator;
import org.softmed.jops.operators.PSpinHOperator;
import org.softmed.jops.operators.PSpinVOperator;
import org.softmed.jops.operators.ParticleOperator;
import org.softmed.jops.operators.SizeOperator;
import org.softmed.jops.operators.SpeedOperator;
import org.softmed.jops.operators.SpinOperator;
import org.softmed.jops.operators.TexHeightOperator;
import org.softmed.jops.operators.TexWidthOperator;
import org.softmed.jops.operators.WidthOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledBehaviour {
    private List<Particle> particles;
    private List<ParticleOperator> operators = new ArrayList<ParticleOperator>();
    private ParticleOperator operator;
    private Particle part;

    public CompiledBehaviour(List<Particle> list) {
        this.particles = list;
    }

    public CompiledBehaviour() {
    }

    public void updateParticleBehaviour(boolean bl) {
        block6: {
            if (this.particles == null) break block6;
            if (bl) {
                for (int i = 0; i < this.operators.size(); ++i) {
                    this.operator = this.operators.get(i);
                    for (int j = 0; j < this.particles.size(); ++j) {
                        this.part = this.particles.get(j);
                        if (!(this.part.life >= 0.0f)) continue;
                        this.operator.myupdate(this.part);
                    }
                }
            } else {
                for (int i = 0; i < this.operators.size(); ++i) {
                    this.operator = this.operators.get(i);
                    for (int j = 0; j < this.particles.size(); ++j) {
                        this.part = this.particles.get(j);
                        this.operator.myupdate(this.part);
                    }
                }
            }
        }
    }

    private void compileBehaviour(ParticleBehaviour particleBehaviour) {
        if (this.operators != null) {
            this.getOperators().clear();
        } else {
            this.operators = new ArrayList<ParticleOperator>();
        }
        if (particleBehaviour.getAlpha().isActive()) {
            this.getOperators().add(new AlphaOperator(particleBehaviour));
        }
        if (particleBehaviour.getElasticity() != null && particleBehaviour.getElasticity().isActive()) {
            this.getOperators().add(new BounceOperator(particleBehaviour));
        }
        if (particleBehaviour.getColor().isActive()) {
            this.getOperators().add(new ColorOperator(particleBehaviour));
        }
        if (particleBehaviour.getMass().isActive()) {
            this.getOperators().add(new MassOperator(particleBehaviour));
        }
        if (particleBehaviour.getSize().isActive()) {
            this.getOperators().add(new SizeOperator(particleBehaviour));
        }
        if (particleBehaviour.getSpin().isActive()) {
            this.getOperators().add(new SpinOperator(particleBehaviour));
        }
        if (particleBehaviour.getAngle().isActive()) {
            this.getOperators().add(new AngleOperator(particleBehaviour));
        }
        if (particleBehaviour.getSpeed().isActive()) {
            this.getOperators().add(new SpeedOperator(particleBehaviour));
        }
        if (particleBehaviour.particleAngleH.isActive()) {
            this.getOperators().add(new PAngleHOperator(particleBehaviour));
        }
        if (particleBehaviour.particleAngleV.isActive()) {
            this.getOperators().add(new PAngleVOperator(particleBehaviour));
        }
        if (particleBehaviour.particleSpinV.isActive()) {
            this.getOperators().add(new PSpinVOperator(particleBehaviour));
        }
        if (particleBehaviour.particleSpinH.isActive()) {
            this.getOperators().add(new PSpinHOperator(particleBehaviour));
        }
        if (particleBehaviour.width.isActive()) {
            this.getOperators().add(new WidthOperator(particleBehaviour));
        }
        if (particleBehaviour.height.isActive()) {
            this.getOperators().add(new HeightOperator(particleBehaviour));
        }
        if (particleBehaviour.texWidth.isActive()) {
            this.getOperators().add(new TexWidthOperator(particleBehaviour));
        }
        if (particleBehaviour.texHeight.isActive()) {
            this.getOperators().add(new TexHeightOperator(particleBehaviour));
        }
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public List<ParticleOperator> getOperators() {
        return this.operators;
    }

    public void setBehaviour(ParticleBehaviour particleBehaviour) {
        if (particleBehaviour == null) {
            this.particles = null;
            if (this.operators != null) {
                this.operators.clear();
            }
            this.operators = null;
        } else {
            this.compileBehaviour(particleBehaviour);
        }
    }

    protected void setParticles(List<Particle> list) {
        this.particles = list;
    }
}

