/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops;

import java.util.List;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Vector3f;
import org.softmed.jops.Particle;
import org.softmed.jops.ParticleBehaviour;
import org.softmed.jops.operators.ParticleOperator;
import org.softmed.jops.random.RandomGenerator;
import org.softmed.jops.valuelists.ValueListf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorBehaviour
extends ParticleBehaviour
implements IUnmarshallable,
IMarshallable {
    Vector3f vector = new Vector3f();
    private List<Particle> particles;
    RandomGenerator rand = new RandomGenerator();
    private ValueListf life = new ValueListf();
    private ValueListf rate = new ValueListf();
    private ValueListf angleV = new ValueListf();
    private ValueListf angleH = new ValueListf();
    private ValueListf spinV = new ValueListf();
    private ValueListf spinH = new ValueListf();
    private ValueListf angleSpreadV = new ValueListf();
    private ValueListf angleSpreadH = new ValueListf();
    private int number = 1000;
    ParticleOperator operator = null;
    Particle part = null;
    float vangleH;
    float vangleV;
    float sinH;
    float cosH;
    float sinV;
    float cosV;
    private float currentAlpha;
    private Colorf currentColor;
    private float currentMass;
    private float currentSpin;
    private float currentSize;
    private float currentBounce;
    private float currentSpeed;
    private Vector3f currentPosition;
    private float currentAngleH;
    private float currentAngleV;
    private float currentSpinH;
    private float currentSpinV;
    private float oldSpinH;
    private float oldSpinV;
    private float currentAngleSpreadH;
    private float currentAngleSpreadV;
    private float currentRate;
    private float currentLife;
    private float currentAngle;
    private float time;
    private Matrix4f rotation;
    private Matrix4f frameRotation;
    public static final String JiBX_bindingList = "|org.softmed.jops.JiBX_bin_org_softmed_jops_fileloading_bindingsFactory|";

    @Override
    public void rebuild() {
        this.rand = new RandomGenerator();
    }

    public GeneratorBehaviour() {
        this.setNumber(50);
        this.getSpeed().addValue(Float.valueOf(1.0f), 0.0f);
        this.getLife().addValue(Float.valueOf(1.0f), 0.0f);
        this.getRate().addValue(Float.valueOf(50.0f), 0.0f);
        this.getAlpha().addValue(Float.valueOf(1.0f), 0.0f);
        this.getAngleH().addValue(Float.valueOf(0.0f), 0.0f);
        this.getAngleV().addValue(Float.valueOf(0.5f), 0.0f);
        this.getAngleSpreadH().addValue(Float.valueOf(0.2f), 0.0f);
        this.getAngleSpreadV().addValue(Float.valueOf(0.2f), 0.0f);
        this.getSize().addValue(Float.valueOf(0.5f), 0.0f);
        this.recompile();
    }

    @Override
    public void recompile() {
        this.thisrebuildIfNecessary();
        super.recompile();
        this.speed.compileArray();
        this.life.compileArray();
        this.rate.compileArray();
        this.angleV.compileArray();
        this.angleH.compileArray();
        this.spinV.compileArray();
        this.spinH.compileArray();
        this.angleSpreadV.compileArray();
        this.angleSpreadH.compileArray();
    }

    private void thisrebuildIfNecessary() {
        if (this.spinV == null) {
            this.spinV = new ValueListf();
        }
        if (this.spinH == null) {
            this.spinH = new ValueListf();
        }
    }

    public void setInitialState(Particle particle, float f) {
        particle.speed = ((Float)this.speed.getValueAt(this.time)).floatValue();
        particle.life = ((Float)this.life.getValueAt(this.time)).floatValue();
        particle.age = 0.0f;
        particle.alpha = ((Float)this.alpha.getValueAt(this.time)).floatValue();
        particle.color = new Colorf((Colorf)this.color.getValueAt(this.time));
        particle.mass = ((Float)this.mass.getValueAt(this.time)).floatValue();
        particle.spin = ((Float)this.spin.getValueAt(this.time)).floatValue();
        particle.angle = ((Float)this.angle.getValueAt(this.time)).floatValue();
        particle.size = ((Float)this.size.getValueAt(this.time)).floatValue();
        particle.elasticity = ((Float)this.elasticity.getValueAt(this.time)).floatValue();
        this.vangleH = this.rand.getFloat(this.currentAngleSpreadH);
        this.vangleV = this.rand.getFloat(this.currentAngleSpreadV);
        if (this.currentAngleSpreadH > 0.0f) {
            this.vangleH -= this.currentAngleSpreadH / 2.0f;
        }
        if (this.currentAngleSpreadV > 0.0f) {
            this.vangleV -= this.currentAngleSpreadV / 2.0f;
        }
        this.vangleH += this.currentAngleH;
        this.vangleV += this.currentAngleV;
        this.cosH = FastMath.cos(this.vangleH);
        this.sinH = FastMath.sin(this.vangleH);
        this.cosV = FastMath.cos(this.vangleV);
        this.sinV = FastMath.sin(this.vangleV);
        particle.direction.setX(this.sinH * this.cosV);
        particle.direction.setY(this.sinV);
        particle.direction.setZ(this.cosH * this.cosV);
        particle.direction.normalize();
        if (this.rotation != null) {
            this.rotation.transform(particle.direction);
            particle.rotation = this.frameRotation;
        }
        particle.angleH = ((Float)this.particleAngleH.getValueAt(this.time)).floatValue();
        particle.angleV = ((Float)this.particleAngleV.getValueAt(this.time)).floatValue();
        particle.spinH = ((Float)this.particleSpinH.getValueAt(this.time)).floatValue();
        particle.spinV = ((Float)this.particleSpinV.getValueAt(this.time)).floatValue();
        particle.height = ((Float)this.height.getValueAt(this.time)).floatValue();
        particle.width = ((Float)this.width.getValueAt(this.time)).floatValue();
        particle.texHeight = ((Float)this.texHeight.getValueAt(this.time)).floatValue();
        particle.texWidth = ((Float)this.texWidth.getValueAt(this.time)).floatValue();
    }

    public void update(float f, float f2) {
        this.time = f;
        this.currentAlpha = ((Float)this.alpha.getValueAt(f)).floatValue();
        this.currentColor = (Colorf)this.color.getValueAt(f);
        this.currentMass = ((Float)this.mass.getValueAt(f)).floatValue();
        this.currentSpin = ((Float)this.spin.getValueAt(f)).floatValue();
        this.currentAngle = ((Float)this.angle.getValueAt(f)).floatValue();
        this.currentSize = ((Float)this.size.getValueAt(f)).floatValue();
        this.currentBounce = ((Float)this.elasticity.getValueAt(f)).floatValue();
        this.currentSpeed = ((Float)this.speed.getValueAt(f)).floatValue();
        this.currentLife = ((Float)this.life.getValueAt(f)).floatValue();
        this.currentRate = ((Float)this.rate.getValueAt(f)).floatValue();
        this.currentAngleH = ((Float)this.angleH.getValueAt(f)).floatValue();
        this.currentAngleV = ((Float)this.angleV.getValueAt(f)).floatValue();
        this.currentSpinH = ((Float)this.spinH.getValueAt(f)).floatValue();
        this.currentSpinV = ((Float)this.spinV.getValueAt(f)).floatValue();
        this.oldSpinV += this.currentSpinV * f2;
        this.oldSpinH += this.currentSpinH * f2;
        if (this.oldSpinV >= 360.0f) {
            this.oldSpinV %= 360.0f;
        } else if (this.oldSpinV < -360.0f) {
            this.oldSpinV = -this.oldSpinV % 360.0f;
        }
        if (this.oldSpinH >= 360.0f) {
            this.oldSpinH %= 360.0f;
        } else if (this.oldSpinH < -360.0f) {
            this.oldSpinH = -this.oldSpinH % 360.0f;
        }
        this.currentAngleH += this.oldSpinH;
        this.currentAngleV += this.oldSpinV;
        this.currentAngleSpreadH = ((Float)this.angleSpreadH.getValueAt(f)).floatValue();
        this.currentAngleSpreadV = ((Float)this.angleSpreadV.getValueAt(f)).floatValue();
    }

    @Override
    public void setParticles(List<Particle> list) {
        this.particles = list;
    }

    public ValueListf getLife() {
        return this.life;
    }

    public void setLife(ValueListf valueListf) {
        this.life = valueListf;
    }

    public ValueListf getRate() {
        return this.rate;
    }

    public void setRate(ValueListf valueListf) {
        this.rate = valueListf;
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public float getCurrentAlpha() {
        return this.currentAlpha;
    }

    public Colorf getCurrentColor() {
        return this.currentColor;
    }

    public float getCurrentMass() {
        return this.currentMass;
    }

    public float getCurrentSpin() {
        return this.currentSpin;
    }

    public float getCurrentSize() {
        return this.currentSize;
    }

    public float getCurrentBounce() {
        return this.currentBounce;
    }

    public float getCurrentSpeed() {
        return this.currentSpeed;
    }

    public Vector3f getCurrentPosition() {
        return this.currentPosition;
    }

    public float getCurrentRate() {
        return this.currentRate;
    }

    public float getCurrentLife() {
        return this.currentLife;
    }

    public ValueListf getAngleV() {
        return this.angleV;
    }

    public ValueListf getAngleH() {
        return this.angleH;
    }

    public ValueListf getAngleSpreadV() {
        return this.angleSpreadV;
    }

    public ValueListf getAngleSpreadH() {
        return this.angleSpreadH;
    }

    @Override
    public ValueListf getSpeed() {
        return this.speed;
    }

    public void setAngleH(ValueListf valueListf) {
        this.angleH = valueListf;
    }

    public void setAngleSpreadH(ValueListf valueListf) {
        this.angleSpreadH = valueListf;
    }

    public void setAngleSpreadV(ValueListf valueListf) {
        this.angleSpreadV = valueListf;
    }

    public void setAngleV(ValueListf valueListf) {
        this.angleV = valueListf;
    }

    public Float getCurrentAngle() {
        return Float.valueOf(this.currentAngle);
    }

    @Override
    public void setResolution(int n) {
        super.setResolution(n);
        this.speed.setResolution(n);
        this.life.setResolution(n);
        this.rate.setResolution(n);
        this.angleV.setResolution(n);
        this.angleH.setResolution(n);
        this.angleSpreadV.setResolution(n);
        this.angleSpreadH.setResolution(n);
    }

    public ValueListf getSpinH() {
        return this.spinH;
    }

    public void setSpinH(ValueListf valueListf) {
        this.spinH = valueListf;
    }

    public ValueListf getSpinV() {
        return this.spinV;
    }

    public void setSpinV(ValueListf valueListf) {
        this.spinV = valueListf;
    }

    public void reset() {
        this.oldSpinV = 0.0f;
        this.oldSpinH = 0.0f;
    }

    public void setRotation(Matrix4f matrix4f) {
        this.rotation = matrix4f;
        this.frameRotation = matrix4f != null ? new Matrix4f(matrix4f) : null;
    }

    public static /* synthetic */ GeneratorBehaviour JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_3_0(UnmarshallingContext arg1) throws JiBXException {
        return new GeneratorBehaviour();
    }

    public final /* synthetic */ GeneratorBehaviour JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_3_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        GeneratorBehaviour generatorBehaviour = this;
        arg1.parsePastStartTag(null, "ParticleBehaviour");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "ParticleBehaviour");
        this.number = arg1.parseElementInt(null, "Number");
        arg1.parsePastStartTag(null, "Life");
        ValueListf valueListf = this.life;
        if (valueListf == null) {
            valueListf = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.life = valueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "Life");
        arg1.parsePastStartTag(null, "Rate");
        ValueListf valueListf2 = this.rate;
        if (valueListf2 == null) {
            valueListf2 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.rate = valueListf2.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "Rate");
        arg1.parsePastStartTag(null, "AngleV");
        ValueListf valueListf3 = this.angleV;
        if (valueListf3 == null) {
            valueListf3 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.angleV = valueListf3.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "AngleV");
        arg1.parsePastStartTag(null, "AngleH");
        ValueListf valueListf4 = this.angleH;
        if (valueListf4 == null) {
            valueListf4 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.angleH = valueListf4.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "AngleH");
        arg1.parsePastStartTag(null, "SpinV");
        ValueListf valueListf5 = this.spinV;
        if (valueListf5 == null) {
            valueListf5 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.spinV = valueListf5.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "SpinV");
        arg1.parsePastStartTag(null, "SpinH");
        ValueListf valueListf6 = this.spinH;
        if (valueListf6 == null) {
            valueListf6 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.spinH = valueListf6.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "SpinH");
        arg1.parsePastStartTag(null, "AngleSpreadV");
        ValueListf valueListf7 = this.angleSpreadV;
        if (valueListf7 == null) {
            valueListf7 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.angleSpreadV = valueListf7.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "AngleSpreadV");
        arg1.parsePastStartTag(null, "AngleSpreadH");
        ValueListf valueListf8 = this.angleSpreadH;
        if (valueListf8 == null) {
            valueListf8 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.angleSpreadH = valueListf8.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "AngleSpreadH");
        arg1.popObject();
        return this;
    }

    @Override
    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(12).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_3_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        arg1.startTag(0, "ParticleBehaviour");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_1(arg1);
        arg1.endTag(0, "ParticleBehaviour");
        MarshallingContext marshallingContext = arg1.element(0, "Number", Utility.serializeInt((int)this.number));
        arg1.startTag(0, "Life");
        this.life.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "Life");
        arg1.startTag(0, "Rate");
        this.rate.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "Rate");
        arg1.startTag(0, "AngleV");
        this.angleV.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "AngleV");
        arg1.startTag(0, "AngleH");
        this.angleH.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "AngleH");
        arg1.startTag(0, "SpinV");
        this.spinV.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "SpinV");
        arg1.startTag(0, "SpinH");
        this.spinH.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "SpinH");
        arg1.startTag(0, "AngleSpreadV");
        this.angleSpreadV.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "AngleSpreadV");
        arg1.startTag(0, "AngleSpreadH");
        this.angleSpreadH.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "AngleSpreadH");
        arg1.popObject();
    }

    @Override
    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(12, "org.softmed.jops.GeneratorBehaviour").marshal((Object)this, arg1);
    }

    @Override
    public /* synthetic */ int JiBX_getIndex() {
        return 12;
    }
}

