/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.modifiers;

import java.util.Map;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.softmed.jops.Particle;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.PositionAnimator;
import org.softmed.jops.cloner.StandaloneClonerNeedsCopyList;
import org.softmed.jops.modifiers.DistanceCalculator;
import org.softmed.jops.modifiers.InverseDistanceCalculator;
import org.softmed.jops.modifiers.Modifier;
import org.softmed.jops.modifiers.pointmass.constant;
import org.softmed.jops.modifiers.pointmass.linear;
import org.softmed.jops.modifiers.pointmass.squared;
import org.softmed.jops.valuelists.ValueListf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointMass
extends Modifier
implements StandaloneClonerNeedsCopyList,
IUnmarshallable,
IMarshallable {
    public static final String CONSTANT = "constant";
    public static final String LINEAR = "linear";
    public static final String SQUARED = "squared";
    public static final String DIRECT = "direct";
    public static final String INVERSE = "inverse";
    ParticleSystem reference;
    private Point3f framePosition = new Point3f();
    String distanceVariation = "constant";
    String distanceProportion = "direct";
    boolean threshold = false;
    protected PositionAnimator animator;
    int positionAnimatorIndex = -1;
    DistanceCalculator strengthCalculator = new constant(this);
    ValueListf strength = new ValueListf();
    ValueListf massImportance = new ValueListf();
    ValueListf distanceImportance = new ValueListf();
    ValueListf thresholdValue = new ValueListf();
    float currentStrenght;
    float currentMassImportance;
    float currentDistanceImportance;
    float currentTreshold;
    float massScaler;
    float strengthScaler;
    Vector3f particleSpeedVector = new Vector3f();
    Vector3f temp = new Vector3f();
    public static final String JiBX_bindingList = "|org.softmed.jops.JiBX_bin_org_softmed_jops_fileloading_bindingsFactory|";

    protected void configureCalculator() {
        if (this.distanceVariation.equals(CONSTANT)) {
            this.strengthCalculator = new constant(this);
        } else if (this.distanceVariation.equals(LINEAR)) {
            this.strengthCalculator = new linear(this);
        } else if (this.distanceVariation.equals(SQUARED)) {
            this.strengthCalculator = new squared(this);
        }
        if (this.distanceProportion.equals(INVERSE)) {
            this.strengthCalculator = new InverseDistanceCalculator(this, this.strengthCalculator);
        }
    }

    public PointMass() {
        this.strength.addValue(Float.valueOf(1.8f), 0.0f);
        this.massImportance.addValue(Float.valueOf(1.0f), 0.0f);
        this.distanceImportance.addValue(Float.valueOf(1.0f), 0.0f);
        this.thresholdValue.addValue(Float.valueOf(1.0f), 0.0f);
    }

    @Override
    public void update(Point3f point3f, Matrix4f matrix4f, float f, float f2) {
        this.framePosition.set(0.0f, 0.0f, 0.0f);
        if (this.animator != null) {
            this.animator.setInitialPosition(this.framePosition);
        }
        if (this.reference != null) {
            this.framePosition.add(this.reference.getPosition());
        }
        if (matrix4f != null) {
            matrix4f.transform(this.framePosition);
        }
        this.currentMassImportance = ((Float)this.massImportance.getValueAt(f)).floatValue();
        this.currentDistanceImportance = ((Float)this.distanceImportance.getValueAt(f)).floatValue();
        this.currentTreshold = ((Float)this.thresholdValue.getValueAt(f)).floatValue();
        this.currentStrenght = ((Float)this.strength.getValueAt(f)).floatValue() * f2;
    }

    @Override
    public void modify(Particle particle) {
        this.temp.sub(this.framePosition, particle.position);
        if (this.temp.getX() == 0.0f && this.temp.getY() == 0.0f && this.temp.getZ() == 0.0f) {
            return;
        }
        if (this.threshold && this.temp.length() >= this.currentTreshold) {
            return;
        }
        this.strengthScaler = this.strengthCalculator.calculateStrength(this.temp);
        this.massScaler = particle.mass * this.currentMassImportance;
        this.massScaler = this.strengthScaler * this.currentStrenght * (1.0f + this.massScaler);
        this.temp.normalize();
        this.temp.scale(this.massScaler);
        this.particleSpeedVector.set((TupleNf)particle.direction);
        this.particleSpeedVector.scale(particle.speed);
        this.particleSpeedVector.add(this.temp);
        particle.speed = this.particleSpeedVector.length();
        this.particleSpeedVector.normalize();
        particle.direction.set((TupleNf)this.particleSpeedVector);
    }

    @Override
    public void recompile() {
        this.massImportance.compileArray();
        this.strength.compileArray();
        this.distanceImportance.compileArray();
        this.thresholdValue.compileArray();
        this.configureCalculator();
    }

    @Override
    public void setResolution(int n) {
        this.massImportance.setResolution(n);
        this.strength.setResolution(n);
        this.distanceImportance.setResolution(n);
        this.thresholdValue.setResolution(n);
    }

    public ValueListf getMassImportance() {
        return this.massImportance;
    }

    public void setMassImportance(ValueListf valueListf) {
        this.massImportance = valueListf;
    }

    public ValueListf getStrength() {
        return this.strength;
    }

    public void setStrength(ValueListf valueListf) {
        this.strength = valueListf;
    }

    public Point3f getPosition() {
        return this.framePosition;
    }

    public PositionAnimator getPositionAnimator() {
        return this.animator;
    }

    public void setPositionAnimator(PositionAnimator positionAnimator) {
        this.animator = positionAnimator;
    }

    public String getDistanceProportion() {
        return this.distanceProportion;
    }

    public void setDistanceProportion(String string) {
        this.distanceProportion = string;
        this.configureCalculator();
    }

    public String getDistanceVariation() {
        return this.distanceVariation;
    }

    public void setDistanceVariation(String string) {
        this.distanceVariation = string;
        this.configureCalculator();
    }

    public boolean isThreshold() {
        return this.threshold;
    }

    public void setThreshold(boolean bl) {
        this.threshold = bl;
        this.configureCalculator();
    }

    public ValueListf getDistanceImportance() {
        return this.distanceImportance;
    }

    public ValueListf getThresholdValue() {
        return this.thresholdValue;
    }

    public float getCurrentDistanceImportance() {
        return this.currentDistanceImportance;
    }

    public float getCurrentMassImportance() {
        return this.currentMassImportance;
    }

    public float getCurrentStrenght() {
        return this.currentStrenght;
    }

    public float getCurrentTreshold() {
        return this.currentTreshold;
    }

    public int getPositionAnimatorIndex() {
        return this.positionAnimatorIndex;
    }

    public void setPositionAnimatorIndex(int n) {
        this.positionAnimatorIndex = n;
    }

    public ParticleSystem getReference() {
        return this.reference;
    }

    public void setReference(ParticleSystem particleSystem) {
        this.reference = particleSystem;
    }

    @Override
    public Object getStandaloneCopy(Map<Object, Object> map) {
        PointMass pointMass = new PointMass();
        pointMass.distanceImportance = this.distanceImportance.getStandaloneCopy();
        pointMass.strength = this.strength.getStandaloneCopy();
        pointMass.massImportance = this.massImportance.getStandaloneCopy();
        pointMass.thresholdValue = this.thresholdValue.getStandaloneCopy();
        pointMass.animator = (PositionAnimator)map.get(this.animator);
        pointMass.threshold = this.threshold;
        pointMass.setDistanceProportion(this.distanceProportion);
        pointMass.setDistanceVariation(this.distanceVariation);
        return pointMass;
    }

    public static /* synthetic */ PointMass JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_3_0(UnmarshallingContext arg1) throws JiBXException {
        return new PointMass();
    }

    public final /* synthetic */ PointMass JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_3_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        PointMass pointMass = this;
        arg1.parsePastStartTag(null, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_1(arg1);
        arg1.parsePastCurrentEndTag(null, "InfoObject");
        arg1.parsePastStartTag(null, "Strength");
        ValueListf valueListf = this.strength;
        if (valueListf == null) {
            valueListf = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.strength = valueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "Strength");
        arg1.parsePastStartTag(null, "MassImportance");
        ValueListf valueListf2 = this.massImportance;
        if (valueListf2 == null) {
            valueListf2 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.massImportance = valueListf2.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "MassImportance");
        arg1.parsePastStartTag(null, "DistanceImportance");
        ValueListf valueListf3 = this.distanceImportance;
        if (valueListf3 == null) {
            valueListf3 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.distanceImportance = valueListf3.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "DistanceImportance");
        arg1.parsePastStartTag(null, "ThresholdValue");
        ValueListf valueListf4 = this.thresholdValue;
        if (valueListf4 == null) {
            valueListf4 = ValueListf.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(arg1);
        }
        this.thresholdValue = valueListf4.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_1(arg1);
        arg1.parsePastCurrentEndTag(null, "ThresholdValue");
        String string = arg1.parseElementText(null, "DistanceVariation");
        if (string == null) {
            string = null;
        }
        this.setDistanceVariation(string);
        String string2 = arg1.parseElementText(null, "DistanceProportion");
        if (string2 == null) {
            string2 = null;
        }
        this.setDistanceProportion(string2);
        this.setThreshold(arg1.parseElementBoolean(null, "Threshold"));
        this.positionAnimatorIndex = arg1.parseElementInt(null, "PositionAnimatorIndex");
        arg1.popObject();
        return this;
    }

    @Override
    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(27).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_3_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        arg1.startTag(0, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_1(arg1);
        arg1.endTag(0, "InfoObject");
        arg1.startTag(0, "Strength");
        this.strength.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "Strength");
        arg1.startTag(0, "MassImportance");
        this.massImportance.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "MassImportance");
        arg1.startTag(0, "DistanceImportance");
        this.distanceImportance.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "DistanceImportance");
        arg1.startTag(0, "ThresholdValue");
        this.thresholdValue.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_3(arg1);
        arg1.endTag(0, "ThresholdValue");
        MarshallingContext marshallingContext = arg1.element(0, "DistanceVariation", this.distanceVariation).element(0, "DistanceProportion", this.distanceProportion).element(0, "Threshold", Utility.serializeBoolean((boolean)this.threshold)).element(0, "PositionAnimatorIndex", Utility.serializeInt((int)this.positionAnimatorIndex));
        arg1.popObject();
    }

    @Override
    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(27, "org.softmed.jops.modifiers.PointMass").marshal((Object)this, arg1);
    }

    @Override
    public /* synthetic */ int JiBX_getIndex() {
        return 27;
    }
}

