/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.util.WindowClosingListener;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

public abstract class BenchmarkBase
extends Xith3DTest
implements WindowClosingListener {
    protected Xith3DEnvironment env = new Xith3DEnvironment(this);
    private long duration = 0L;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                System.out.println("Benchmark canceled after " + this.getTimingMode().getSecondsAsFloat(this.getGameTime()) + " seconds.");
                this.end();
            }
        }
    }

    public void onWindowCloseRequested(Canvas3D canvas) {
        System.out.println("Benchmark canceled after " + this.getTimingMode().getSecondsAsFloat(this.getGameTime()) + " seconds.");
        this.end();
    }

    protected void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        super.onRenderLoopStopped(gameTime, timingMode, averageFPS);
        System.out.println("Rendered frames: " + this.getIterationsCount());
        System.out.println("Average FPS: " + averageFPS);
        System.out.println("Triangles in the scene: " + this.env.getRenderer().getNumRenderedTriangles());
    }

    protected void renderNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.renderNextFrame(gameTime, frameTime, timingMode);
        if (gameTime >= this.duration) {
            System.out.println("Benchmark ended regulary after " + (int)timingMode.getSecondsAsFloat(gameTime) + " seconds.");
            this.end();
        }
    }

    protected void startBenchmark(long duration) {
        System.out.println(this.getClass().getSimpleName() + " started to last for " + duration + " seconds. (Hit ESC to cancel.)");
        this.duration = duration * 1000000L;
    }

    protected abstract void initSceneBeforeCanvas(Xith3DEnvironment var1, Sized2iRO var2);

    protected abstract void initSceneAfterCanvas(Xith3DEnvironment var1);

    public BenchmarkBase(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("HUD");
        resLoc.createAndAddTSL("models");
        resLoc.createAndAddTSL("shader");
        resLoc.createAndAddTSL("skyboxes");
        resLoc.createAndAddTSL("sounds");
        resLoc.createAndAddTSL("textures");
        this.initSceneBeforeCanvas(this.env, arguments.getResolution());
        CanvasConstructionInfo cci = arguments.getCanvasConstructionInfo();
        cci.setVSyncEnabled(false);
        Canvas3D canvas = this.createCanvas(cci, this.getClass().getSimpleName());
        canvas.addWindowClosingListener(this);
        this.env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.initSceneAfterCanvas(this.env);
    }
}

