/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import java.util.Random;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.spatial.bodies.Plane;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.benchmarks.BenchmarkBase;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"Renders some bouncing balls in a scene."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BouncingBallsBenchmark
extends BenchmarkBase {
    private static final int BALLS_COUNT = 20;
    private static final int BALL_COMPLEXITY = 32;
    private static final float BALL_SIZE = 0.035f;
    private static float MAX_X_POS;
    private static float MAX_Y_POS;
    private static final float GRAVITY = 0.5f;
    private BouncingBall[] balls;

    protected void initSceneBeforeCanvas(Xith3DEnvironment env, Sized2iRO resolution) {
    }

    private static CollideableGroup createFrustumCollideable(Frustum frustum, CollisionEngine collEngine) {
        CollideableGroup frustumCollGroup = collEngine.newGroup("Simple");
        Plane plane = frustum.getPlaneRight();
        frustumCollGroup.addCollideable(collEngine.newPlane(plane.getA(), plane.getB(), plane.getC(), -plane.getD()));
        plane = frustum.getPlaneLeft();
        frustumCollGroup.addCollideable(collEngine.newPlane(plane.getA(), plane.getB(), plane.getC(), -plane.getD()));
        plane = frustum.getPlaneBottom();
        frustumCollGroup.addCollideable(collEngine.newPlane(plane.getA(), plane.getB(), plane.getC(), -plane.getD()));
        plane = frustum.getPlaneTop();
        frustumCollGroup.addCollideable(collEngine.newPlane(plane.getA(), plane.getB(), plane.getC(), -plane.getD()));
        plane = frustum.getPlaneFar();
        frustumCollGroup.addCollideable(collEngine.newPlane(plane.getA(), plane.getB(), plane.getC(), -plane.getD()));
        plane = frustum.getPlaneNear();
        frustumCollGroup.addCollideable(collEngine.newPlane(plane.getA(), plane.getB(), plane.getC(), -plane.getD()));
        return frustumCollGroup;
    }

    protected void initSceneAfterCanvas(Xith3DEnvironment env) {
        JoodePhysicsEngine physEngine = new JoodePhysicsEngine();
        env.setPhysicsEngine(physEngine);
        SimulationWorld simWorld = physEngine.getSimulationEngine().newWorld();
        CollisionEngine collEngine = physEngine.getCollisionEngine();
        simWorld.setGravity(0.0f, -0.5f, 0.0f);
        physEngine.getDefaultSurfaceParameters().setParameter("bounce", Float.valueOf(1.0f));
        MAX_X_POS = 0.965f;
        MAX_Y_POS = 1.0f / env.getCanvas().getAspect() - 0.035f;
        Random rnd = new Random(System.nanoTime());
        this.balls = new BouncingBall[20];
        BranchGroup scene = new BranchGroup();
        CollideableGroup ballsCollider = collEngine.newGroup();
        for (int i = 0; i < 20; ++i) {
            Point2f position = new Point2f(-MAX_X_POS + rnd.nextFloat() * MAX_X_POS * 2.0f, -MAX_Y_POS + rnd.nextFloat() * MAX_Y_POS * 2.0f);
            Vector2f velocity = new Vector2f(-1.0f + rnd.nextFloat() * 2.0f, 0.0f + rnd.nextFloat() * 1.0f);
            Colorf color = new Colorf(rnd.nextFloat() * 0.4f, rnd.nextFloat() * 0.4f, rnd.nextFloat() * 0.4f);
            BouncingBall ball = new BouncingBall(position, velocity, color, physEngine.getCollisionEngine(), simWorld);
            scene.addChild(ball);
            physEngine.getGFXManager().add(ball.collider, (TransformGroup)ball);
            this.balls[i] = ball;
            ballsCollider.addCollideable(this.balls[i].collider);
        }
        DirectionalLight light = new DirectionalLight(true, Colorf.GRAY50, new Vector3f(1.0f, -1.0f, -1.0f));
        scene.addChild(light);
        RenderPass renderPass = env.addPerspectiveBranch(scene);
        renderPass.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        this.addUpdatable(new Updatable(){

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                for (int i = 0; i < BouncingBallsBenchmark.this.balls.length; ++i) {
                    BouncingBallsBenchmark.this.balls[i].body.setPositionZ(0.0f);
                }
            }
        });
        env.getView().setFieldOfView(0.15707964f);
        env.getView().setPosition(0.0f, 0.0f, 4.7f);
        CollideableGroup frustumCollGroup = BouncingBallsBenchmark.createFrustumCollideable(env.getView().getFrustum(env.getCanvas()), collEngine);
        physEngine.addCollisionResolver(new CollisionResolver(ballsCollider, (Collideable)frustumCollGroup));
        physEngine.addCollisionResolver(new CollisionResolver(ballsCollider));
    }

    public BouncingBallsBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super(arguments);
        this.startBenchmark(30L);
    }

    public static void main(String[] args) throws Throwable {
        BouncingBallsBenchmark test = new BouncingBallsBenchmark(BouncingBallsBenchmark.parseCommandLine(args));
        test.begin();
    }

    private class BouncingBall
    extends TransformGroup {
        private SphereCollideable collider;
        private Body body;

        public BouncingBall(Point2f position, Vector2f velocity, Colorf color, CollisionEngine collEngine, SimulationWorld simWorld) {
            Sphere sph = new Sphere(0.035f, 32, 32, 3, false, 2);
            Appearance a = new Appearance();
            Material m = new Material();
            m.setEmissiveColor(color);
            m.setColorTarget(Material.NONE);
            m.setLightingEnabled(true);
            a.setMaterial(m);
            sph.setAppearance(a);
            this.addChild(sph);
            this.collider = collEngine.newSphere(sph);
            this.body = simWorld.newBody();
            this.body.setMass(120.0f);
            this.body.addCollideable(this.collider);
            this.body.setPosition(position.getX(), position.getY(), 0.0f);
            this.body.setLinearVelocity(velocity.getX(), velocity.getY(), 0.0f);
            simWorld.addBody(this.body);
        }
    }
}

